/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen;

import com.db.plexus.interop.dsl.gen.GenTask;
import com.db.plexus.interop.dsl.gen.PlexusGenConfig;
import com.db.plexus.interop.dsl.gen.ResourceSetValidator;
import com.db.plexus.interop.dsl.gen.errors.CodeGenerationException;
import com.db.plexus.interop.dsl.gen.util.FileUtils;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResourceSet;

public abstract class BaseGenTask
implements GenTask {
    @Inject
    protected ResourceSetValidator validator;
    protected Logger logger = Logger.getLogger("PlexusCodeGenerator");
    private URI workingDirUri;
    private URI baseDirUri;
    private URI outDirUri;
    private URI resourceBaseUri;

    @Override
    public void doGen(PlexusGenConfig config) throws IOException, URISyntaxException {
        this.workingDirUri = this.getWorkingDir();
        this.baseDirUri = this.getRelativeURI(config.getBaseDir(), this.workingDirUri);
        this.outDirUri = this.getRelativeURI(config.getOutDir(), this.workingDirUri);
        this.resourceBaseUri = this.detectResourceBaseUri();
        XtextResourceSet resourceSet = new XtextResourceSet();
        this.loadResources(resourceSet, this.getBaseDirUri(), config.isVerbose(), this.inputFilesGlob(config));
        if (config.isVerbose()) {
            this.printResources(resourceSet);
        }
        this.validateResources(config, resourceSet);
        this.doGenWithResources(config, resourceSet);
    }

    protected String inputFilesGlob(PlexusGenConfig config) {
        return config.getInput();
    }

    protected URI getWorkingDir() {
        return URI.createFileURI(Paths.get("", new String[0]).toAbsolutePath().toString()).appendSegment("");
    }

    public void printResources(XtextResourceSet resourceSet) {
        resourceSet.getResources().forEach(r -> this.logger.info("Loaded resource: " + r.getURI()));
    }

    public void validateResources(PlexusGenConfig config, XtextResourceSet resourceSet) {
        this.validator.validateResources(resourceSet);
    }

    public void validateInteropResourceLoaded(PlexusGenConfig config, XtextResourceSet resourceSet) {
        boolean containsInterop = resourceSet.getResources().stream().anyMatch(r -> r.getURI().toString().endsWith(".interop"));
        if (!containsInterop) {
            String errorMessage = String.format("No *.interop files match provided [%s] criteria, please check your input arguments.", config.getInput());
            this.logger.severe(errorMessage);
            throw new CodeGenerationException(errorMessage);
        }
    }

    protected void doGenWithResources(PlexusGenConfig config, XtextResourceSet resourceSet) throws IOException {
    }

    protected URI getWorkingDirUri() {
        return this.workingDirUri;
    }

    protected URI getBaseDirUri() {
        return this.baseDirUri;
    }

    protected URI getOutDirUri() {
        return this.outDirUri;
    }

    protected URI getResourceBaseUri() {
        return this.resourceBaseUri;
    }

    protected String getAbsolutePath(String relativePath) {
        return Paths.get(".", new String[0]).resolve(relativePath).toAbsolutePath().toString();
    }

    protected List<String> getProtoFilePaths(EList<Resource> resources, PlexusGenConfig config) {
        String excludePattern = config.getExcludePattern();
        boolean excludePatternIsEmpty = excludePattern == null || excludePattern.trim().isEmpty();
        return resources.stream().filter(x -> x.getURI().lastSegment().endsWith(".proto")).filter(x -> config.isIncludeProtoDescriptors() || !x.getURI().toString().endsWith("google/protobuf/descriptor.proto")).filter(x -> excludePatternIsEmpty || !x.getURI().toString().matches(excludePattern)).filter(x -> config.isIncludeProtoDescriptors() || !x.getURI().toString().endsWith("interop/descriptor.proto")).filter(x -> x.getURI().toFileString() != null).map(resource -> new File(resource.getURI().resolve(this.workingDirUri).toFileString()).getAbsolutePath()).collect(Collectors.toList());
    }

    protected void loadResources(XtextResourceSet resourceSet, URI baseDirUri, boolean isVerbose, String inputGlob) throws IOException {
        FileUtils.processFiles(new File(baseDirUri.toFileString()).getPath(), inputGlob, path -> {
            if (isVerbose) {
                this.logger.info("Loading file: " + path.toAbsolutePath());
            }
            this.loadResource((Path)path, resourceSet);
        });
        EcoreUtil2.resolveAll(resourceSet);
    }

    private void loadResource(Path path, XtextResourceSet resourceSet) {
        URI uri = URI.createFileURI(path.toString());
        resourceSet.getResource(uri, true);
    }

    protected URI getRelativeURI(String path, URI workingDirURI) {
        URI uri = URI.createFileURI(path).resolve(workingDirURI);
        if (!uri.lastSegment().equals("")) {
            uri = uri.appendSegment("");
        }
        return uri;
    }

    protected URI detectResourceBaseUri() throws URISyntaxException {
        URI commonUri = URI.createURI(ClassLoader.getSystemClassLoader().getResource("interop/options.proto").toURI().toString());
        URI resourceBaseUri = commonUri.trimSegments(2).appendSegment("");
        return resourceBaseUri;
    }

    protected void writeToFile(String outPath, String content) throws IOException {
        this.logger.info("Saving to: " + outPath);
        FileUtils.writeStringToFile(new File(outPath), content);
    }

    protected int generateMessages(List<String> args) throws IOException {
        this.logger.info(String.format("Running compiler with args [%s]", String.join((CharSequence)" ", args)));
        try {
            int resultCode = new ProcessBuilder(args).inheritIO().start().waitFor();
            if (resultCode != 0) {
                this.logger.log(Level.WARNING, "Compiler has returned non-zero result code " + resultCode);
            }
            return resultCode;
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Could not generate messages definitions");
            e.printStackTrace();
            return 1;
        }
    }
}

