/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.protobuf.validation;

import com.db.plexus.interop.dsl.protobuf.Enum;
import com.db.plexus.interop.dsl.protobuf.EnumValue;
import com.db.plexus.interop.dsl.protobuf.Field;
import com.db.plexus.interop.dsl.protobuf.Import;
import com.db.plexus.interop.dsl.protobuf.Method;
import com.db.plexus.interop.dsl.protobuf.NamedElement;
import com.db.plexus.interop.dsl.protobuf.Package;
import com.db.plexus.interop.dsl.protobuf.Proto;
import com.db.plexus.interop.dsl.protobuf.ProtoLangConfig;
import com.db.plexus.interop.dsl.protobuf.ProtoLangImportResolver;
import com.db.plexus.interop.dsl.protobuf.ProtobufPackage;
import com.db.plexus.interop.dsl.protobuf.validation.AbstractProtoLangValidator;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ProtoLangValidator
extends AbstractProtoLangValidator {
    private static final char DOT_CHAR = '.';
    private static final char UNDERSCORE_CHAR = '_';
    @Inject
    private IContainer.Manager containermanager;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private ProtoLangImportResolver importResolver;
    @Inject
    private ProtoLangConfig protoLangConfig;

    @Check
    public void checkSinglePackageDeclaration(Package ele) {
        boolean _greaterThan;
        int _length = ((Object[])Conversions.unwrapArray(Iterables.filter(ele.eContainer().eContents(), Package.class), Object.class)).length;
        boolean bl = _greaterThan = _length > 1;
        if (_greaterThan) {
            this.error("Duplicated package declaration", ProtobufPackage.Literals.PACKAGE__IMPORTED_NAMESPACE);
        }
    }

    @Check
    public void checkFullNameIsUnique(NamedElement element) {
        QualifiedName name = this.qualifiedNameProvider.getFullyQualifiedName(element);
        IResourceDescriptions resourceDescriptions = this.resourceDescriptionsProvider.getResourceDescriptions(element.eResource());
        IResourceDescription resourceDescription = resourceDescriptions.getResourceDescription(element.eResource().getURI());
        List<IContainer> _visibleContainers = this.containermanager.getVisibleContainers(resourceDescription, resourceDescriptions);
        for (IContainer c : _visibleContainers) {
            Iterable<IEObjectDescription> _exportedObjectsByType = c.getExportedObjectsByType(ProtobufPackage.Literals.NAMED_ELEMENT);
            for (IEObjectDescription od : _exportedObjectsByType) {
                if (!name.equals(od.getQualifiedName()) || od.getEObjectOrProxy().equals(element)) continue;
                String _name = od.getEClass().getName();
                String _plus = "Duplicated qualified name: " + name + ". " + _name;
                String _plus_1 = _plus + " with the same qualified name is already defined in ";
                URI _uRI = od.getEObjectOrProxy().eResource().getURI();
                String _plus_2 = _plus_1 + _uRI;
                this.error(_plus_2, ProtobufPackage.Literals.NAMED_ELEMENT__NAME);
            }
        }
    }

    @Check
    public void checkEnumValueFullNameIsUnique(NamedElement element) {
        QualifiedName name = this.qualifiedNameProvider.getFullyQualifiedName(element);
        IResourceDescriptions resourceDescriptions = this.resourceDescriptionsProvider.getResourceDescriptions(element.eResource());
        IResourceDescription resourceDescription = resourceDescriptions.getResourceDescription(element.eResource().getURI());
        List<IContainer> _visibleContainers = this.containermanager.getVisibleContainers(resourceDescription, resourceDescriptions);
        for (IContainer c : _visibleContainers) {
            Iterable<IEObjectDescription> _exportedObjectsByType = c.getExportedObjectsByType(ProtobufPackage.Literals.ENUM_VALUE);
            for (IEObjectDescription od : _exportedObjectsByType) {
                if (!name.equals(od.getQualifiedName()) || od.getEObjectOrProxy().equals(element)) continue;
                EObject _eObjectOrProxy = od.getEObjectOrProxy();
                String _name = ((EnumValue)_eObjectOrProxy).getName();
                String _plus = "\"" + _name;
                String _plus_1 = _plus + "\" must be unique within \"";
                QualifiedName _skipLast = od.getQualifiedName().skipLast(1);
                String _plus_2 = _plus_1 + _skipLast;
                String _plus_3 = _plus_2 + "\", not just within \"";
                EObject _eContainer = od.getEObjectOrProxy().eContainer();
                String _name_1 = ((Enum)_eContainer).getName();
                String _plus_4 = _plus_3 + _name_1;
                String _plus_5 = _plus_4 + "\", because enum values use C++ scoping rules, meaning that enum values are siblings of their type, not children of it.";
                this.error(_plus_5, ProtobufPackage.Literals.NAMED_ELEMENT__NAME);
            }
        }
    }

    @Check
    public void checkImport(Import ele) {
        boolean _tripleEquals;
        String path = ele.getImportURI();
        URI _resolveURI = this.importResolver.resolveURI(ele.eResource().getResourceSet(), path);
        boolean bl = _tripleEquals = _resolveURI == null;
        if (_tripleEquals) {
            ArrayList<URI> resolveCandidates = this.importResolver.getResolveCandidates(path);
            this.error("Imported resource cannot be resolved: " + path + ". The following candidates were checked: " + resolveCandidates, ProtobufPackage.Literals.IMPORT__IMPORT_URI);
        }
    }

    @Check
    public void checkFieldNumbers(Field field) {
        Iterable<Field> fields = Iterables.filter(field.eContainer().eContents(), Field.class);
        for (Field otherField : fields) {
            if (!Objects.equal(otherField.getNumber(), field.getNumber()) || otherField.equals(field)) continue;
            String _name = otherField.getName();
            String _plus = "The same number assigned to field \"" + _name;
            String _plus_1 = _plus + "\"";
            this.error(_plus_1, ProtobufPackage.Literals.FIELD__NUMBER);
        }
    }

    @Check
    public void checkProtoResourceName(Proto proto) {
        boolean _not;
        boolean _strictMode = this.protoLangConfig.getStrictMode();
        boolean bl = _not = !_strictMode;
        if (_not) {
            return;
        }
        String fileName = proto.eResource().getURI().lastSegment();
        boolean isValid = true;
        for (int i = 0; isValid && i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            isValid = Character.isLowerCase(c) && Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '.';
        }
        if (!isValid) {
            this.error("Resource name \"" + fileName + "\" is not valid. Only lower-case letters, digits, underscores and dots allowed.", proto, ProtobufPackage.Literals.PROTO__ELEMENTS);
        }
    }

    @Check
    public void checkFieldName(Field field) {
        boolean _not;
        boolean _strictMode = this.protoLangConfig.getStrictMode();
        boolean bl = _not = !_strictMode;
        if (_not) {
            return;
        }
        String name = field.getName();
        boolean isValid = name.length() > 0 && Character.isLetter(name.charAt(0));
        for (int i = 0; isValid && i < name.length(); ++i) {
            char c = name.charAt(i);
            isValid = Character.isLowerCase(c) && Character.isLetter(c) || Character.isDigit(c) || c == '_';
        }
        if (!isValid) {
            String message = "Field name \"" + name + "\" is not valid. Only lower-case letters, digits and underscores allowed. First symbol must be lower-cased letter.";
            this.error(message, field, ProtobufPackage.Literals.FIELD__NAME);
        }
    }

    @Check
    public void checkDefinitionName(NamedElement ele) {
        boolean _not;
        boolean _strictMode = this.protoLangConfig.getStrictMode();
        boolean bl = _not = !_strictMode;
        if (_not) {
            return;
        }
        if (ele instanceof EnumValue) {
            return;
        }
        String name = ele.getName();
        boolean isValid = name.length() > 0 && Character.isLetter(name.charAt(0)) && Character.isUpperCase(name.charAt(0));
        for (int i = 0; isValid && i < name.length(); ++i) {
            char c = name.charAt(i);
            isValid = Character.isLetter(c) || Character.isDigit(c);
        }
        if (!isValid) {
            String _name = ele.eClass().getName();
            String _plus = "Name of " + _name;
            String _plus_1 = _plus + " \"";
            String _plus_2 = _plus_1 + name;
            String message = _plus_2 + "\" is not valid. Only letters and digits allowed. First symbol must be upper-cased letter.";
            this.error(message, ele, ProtobufPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkEnumValueName(EnumValue ele) {
        boolean _not;
        boolean _strictMode = this.protoLangConfig.getStrictMode();
        boolean bl = _not = !_strictMode;
        if (_not) {
            return;
        }
        String name = ele.getName();
        boolean isValid = true;
        for (int i = 0; isValid && i < name.length(); ++i) {
            char c = name.charAt(i);
            isValid = Character.isLetter(c) && Character.isUpperCase(name.charAt(0)) || Character.isDigit(c) || c == '_';
        }
        if (!isValid) {
            String _name = ele.eClass().getName();
            String _plus = "Name of " + _name;
            String _plus_1 = _plus + " \"";
            String _plus_2 = _plus_1 + name;
            String message = _plus_2 + "\" is not valid. Only letters, digits and underscores allowed. All letters must be upper-cased.";
            this.error(message, ele, ProtobufPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkMethodName(Method ele) {
        boolean _not;
        boolean _strictMode = this.protoLangConfig.getStrictMode();
        boolean bl = _not = !_strictMode;
        if (_not) {
            return;
        }
        String name = ele.getName();
        boolean isValid = name.length() > 0 && Character.isLetter(name.charAt(0)) && Character.isUpperCase(name.charAt(0));
        for (int i = 0; isValid && i < name.length(); ++i) {
            char c = name.charAt(i);
            isValid = Character.isLetter(c) || Character.isDigit(c);
        }
        if (!isValid) {
            String message = "Name of method \"" + name + "\" is not valid. Only letters and digits allowed. First symbol must be upper-cased letter.";
            this.error(message, ele, ProtobufPackage.Literals.METHOD__NAME);
        }
    }

    @Check
    public void checkPackageName(Package package_) {
        boolean _not;
        boolean _strictMode = this.protoLangConfig.getStrictMode();
        boolean bl = _not = !_strictMode;
        if (_not) {
            return;
        }
        String name = package_.getImportedNamespace();
        boolean isValid = true;
        for (int i = 0; isValid && i < name.length(); ++i) {
            char c = name.charAt(i);
            isValid = Character.isLowerCase(c) && Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '.';
        }
        if (!isValid) {
            String message = "Package name \"" + name + "\" is not valid. Only lower-case letters, digits, underscores and dots allowed.";
            this.error(message, package_, ProtobufPackage.Literals.PACKAGE__IMPORTED_NAMESPACE);
        }
    }

    @Check
    public void checkProtoResourceLocation(Proto proto) {
        boolean _greaterThan;
        boolean _not;
        boolean _strictMode = this.protoLangConfig.getStrictMode();
        boolean bl = _not = !_strictMode;
        if (_not) {
            return;
        }
        Resource resource = proto.eResource();
        QualifiedName name = this.qualifiedNameProvider.getFullyQualifiedName(proto);
        List<String> segments = name.skipFirst(1).getSegments();
        String _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray(segments, Object.class)).length;
        boolean bl2 = _greaterThan = _length > 0;
        if (_greaterThan) {
            String _join = IterableExtensions.join(segments, "/");
            String _plus = _join + "/";
            String _lastSegment = resource.getURI().lastSegment();
            _xifexpression = _plus + _lastSegment;
        } else {
            _xifexpression = resource.getURI().lastSegment();
        }
        String importPath = _xifexpression;
        URI resolvedUri = this.importResolver.resolveURI(resource.getResourceSet(), importPath);
        if (resolvedUri == null) {
            ArrayList<URI> candidates = this.importResolver.getResolveCandidates(importPath);
            QualifiedName _skipFirst = name.skipFirst(1);
            String _plus_1 = "Resource folder do not correspond to its package name \"" + _skipFirst;
            String _plus_2 = _plus_1 + "\". Valid locations for the resource: ";
            String message = _plus_2 + candidates;
            Functions.Function1<Package, Boolean> _function = x -> true;
            Package package_ = IterableExtensions.findFirst(Iterables.filter(proto.getElements(), Package.class), _function);
            if (package_ == null) {
                this.error(message, proto, ProtobufPackage.Literals.PROTO__ELEMENTS);
            } else {
                this.error(message, package_, ProtobufPackage.Literals.PACKAGE__IMPORTED_NAMESPACE);
            }
        }
    }
}

