/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.hooks;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class EclipseLazyStarter
extends ClassLoaderHook {
    private static final EnumSet<Module.State> alreadyActive = EnumSet.of(Module.State.ACTIVE, Module.State.STOPPING, Module.State.UNINSTALLED);
    private static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private final ThreadLocal<List<Object>> activationStack = new ThreadLocal();
    private final Map<ClasspathManager, ClassNotFoundException> errors = Collections.synchronizedMap(new WeakHashMap());
    private final EquinoxContainer container;

    public EclipseLazyStarter(EquinoxContainer container) {
        this.container = container;
    }

    @Override
    public void preFindLocalClass(String name, ClasspathManager manager) throws ClassNotFoundException {
        int size;
        ModuleRevision revision = manager.getGeneration().getRevision();
        Module module = revision.getRevisions().getModule();
        if (alreadyActive.contains((Object)module.getState())) {
            return;
        }
        if (!this.shouldActivateFor(name, module, revision, manager)) {
            return;
        }
        List<Object> stack = this.activationStack.get();
        if (stack == null) {
            stack = new ArrayList<Object>(6);
            this.activationStack.set(stack);
        }
        if ((size = stack.size()) > 1) {
            int i = size - 1;
            while (i >= 1) {
                if (manager == stack.get(i)) {
                    return;
                }
                --i;
            }
        }
        if (size == 0) {
            stack.add(name);
        }
        stack.add(manager);
    }

    @Override
    public void postFindLocalClass(String name, Class<?> clazz, ClasspathManager manager) throws ClassNotFoundException {
        List<Object> stack = this.activationStack.get();
        if (stack == null) {
            return;
        }
        int size = stack.size();
        if (size <= 1 || stack.get(0) != name) {
            return;
        }
        ClasspathManager[] managers = null;
        managers = new ClasspathManager[size - 1];
        int i = 1;
        while (i < size) {
            managers[i - 1] = (ClasspathManager)stack.get(i);
            ++i;
        }
        stack.clear();
        if (clazz == null) {
            return;
        }
        i = managers.length - 1;
        while (i >= 0) {
            if (this.errors.get(managers[i]) != null) {
                if (this.container.getConfiguration().throwErrorOnFailedStart) {
                    throw this.errors.get(managers[i]);
                }
            } else {
                long startTime = System.currentTimeMillis();
                Module m3 = managers[i].getGeneration().getRevision().getRevisions().getModule();
                try {
                    secureAction.start(m3, Module.StartOptions.LAZY_TRIGGER);
                }
                catch (BundleException e) {
                    String message;
                    Bundle bundle = managers[i].getGeneration().getRevision().getBundle();
                    if (e.getType() == 7) {
                        message = NLS.bind(Msg.ECLIPSE_CLASSLOADER_CONCURRENT_STARTUP, new Object[]{Thread.currentThread(), name, m3.getStateChangeOwner(), bundle, new Long(System.currentTimeMillis() - startTime)});
                        this.container.getLogServices().log("org.eclipse.osgi", 2, message, e);
                    }
                    message = NLS.bind(Msg.ECLIPSE_CLASSLOADER_ACTIVATION, bundle.getSymbolicName(), Long.toString(bundle.getBundleId()));
                    ClassNotFoundException error = new ClassNotFoundException(message, e);
                    this.errors.put(managers[i], error);
                    if (this.container.getConfiguration().throwErrorOnFailedStart) {
                        this.container.getLogServices().log("org.eclipse.osgi", 4, message, e, null);
                        throw error;
                    }
                    this.container.getEventPublisher().publishFrameworkEvent(2, bundle, new BundleException(message, e));
                }
            }
            --i;
        }
    }

    private boolean shouldActivateFor(String className, Module module, ModuleRevision revision, ClasspathManager manager) throws ClassNotFoundException {
        Module.State state = module.getState();
        if (!Module.State.LAZY_STARTING.equals((Object)state)) {
            if (Module.State.STARTING.equals((Object)state) && manager.getClassLoader().getBundleLoader().isTriggerSet()) {
                return true;
            }
            if (Module.State.RESOLVED.equals((Object)module.getState())) {
                ClassNotFoundException error;
                if (this.container.getConfiguration().throwErrorOnFailedStart && (error = this.errors.get(manager)) != null) {
                    throw error;
                }
                return module.isPersistentlyStarted() && this.isLazyStartable(className, revision);
            }
            return false;
        }
        return this.isLazyStartable(className, revision);
    }

    private boolean isLazyStartable(String className, ModuleRevision revision) {
        if (!revision.hasLazyActivatePolicy()) {
            return false;
        }
        List<ModuleCapability> moduleDatas = revision.getModuleCapabilities("equinox.module.data");
        if (moduleDatas.isEmpty()) {
            return false;
        }
        Map<String, Object> moduleDataAttrs = moduleDatas.get(0).getAttributes();
        List excludes = (List)moduleDataAttrs.get("lazy.exclude");
        List includes = (List)moduleDataAttrs.get("lazy.include");
        if (excludes == null && includes == null) {
            return true;
        }
        int dotPosition = className.lastIndexOf(46);
        if (dotPosition == -1) {
            return true;
        }
        String packageName = className.substring(0, dotPosition);
        return !(includes != null && !includes.contains(packageName) || excludes != null && excludes.contains(packageName));
    }
}

