/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtend.lib.annotations.ToStringConfiguration;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Beta
public class ToStringProcessor
extends AbstractClassProcessor {
    @Override
    public void doTransform(MutableClassDeclaration it, final @Extension TransformationContext context) {
        boolean _tripleNotEquals;
        AnnotationReference _findAnnotation = it.findAnnotation(context.findTypeGlobally(Data.class));
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        Util util = new Util(context);
        AnnotationReference annotation = it.findAnnotation(context.findTypeGlobally(ToString.class));
        ToStringConfiguration configuration = new ToStringConfiguration(annotation);
        boolean _hasToString = util.hasToString(it);
        if (_hasToString) {
            context.addWarning(annotation, "toString is already defined, this annotation has no effect.");
        } else {
            TypeReference _object;
            boolean _notEquals;
            TypeReference _extendedClass = it.getExtendedClass();
            boolean bl2 = _notEquals = !Objects.equal(_extendedClass, _object = context.getObject());
            if (_notEquals) {
                util.addReflectiveToString(it, configuration);
            } else {
                Functions.Function1<MutableFieldDeclaration, Boolean> _function = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

                    @Override
                    public Boolean apply(MutableFieldDeclaration it) {
                        return context.isThePrimaryGeneratedJavaElement(it) && !it.isStatic() && !it.isTransient();
                    }
                };
                util.addToString(it, IterableExtensions.filter(it.getDeclaredFields(), _function), configuration);
            }
        }
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        public boolean hasToString(ClassDeclaration it) {
            MethodDeclaration _findDeclaredMethod = it.findDeclaredMethod("toString", new TypeReference[0]);
            return _findDeclaredMethod != null;
        }

        public ToStringConfiguration getToStringConfig(ClassDeclaration it) {
            ToStringConfiguration _xblockexpression = null;
            AnnotationReference anno = it.findAnnotation(this.context.findTypeGlobally(ToString.class));
            ToStringConfiguration _xifexpression = null;
            _xifexpression = anno == null ? null : new ToStringConfiguration(anno);
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public void addReflectiveToString(final MutableClassDeclaration cls, final ToStringConfiguration config) {
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                @Override
                public void apply(MutableMethodDeclaration it) {
                    Util.this.context.setPrimarySourceElement(it, Util.this.context.getPrimarySourceElement(cls));
                    it.setReturnType(Util.this.context.getString());
                    it.addAnnotation(Util.this.context.newAnnotationReference(Override.class));
                    it.addAnnotation(Util.this.context.newAnnotationReference(Pure.class));
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        @Override
                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append("String result = new ");
                            _builder.append(ToStringBuilder.class);
                            _builder.append("(this)");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append(".addAllFields()");
                            _builder.newLine();
                            _builder.append("\t");
                            boolean _isSkipNulls = config.isSkipNulls();
                            if (_isSkipNulls) {
                                _builder.append(".skipNulls()");
                            }
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            boolean _isSingleLine = config.isSingleLine();
                            if (_isSingleLine) {
                                _builder.append(".singleLine()");
                            }
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            boolean _isHideFieldNames = config.isHideFieldNames();
                            if (_isHideFieldNames) {
                                _builder.append(".hideFieldNames()");
                            }
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            boolean _isVerbatimValues = config.isVerbatimValues();
                            if (_isVerbatimValues) {
                                _builder.append(".verbatimValues()");
                            }
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append(".toString();");
                            _builder.newLine();
                            _builder.append("return result;");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                }
            };
            cls.addMethod("toString", _function);
        }

        public void addToString(final MutableClassDeclaration cls, final Iterable<? extends FieldDeclaration> fields, final ToStringConfiguration config) {
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                @Override
                public void apply(MutableMethodDeclaration it) {
                    Util.this.context.setPrimarySourceElement(it, Util.this.context.getPrimarySourceElement(cls));
                    it.setReturnType(Util.this.context.getString());
                    it.addAnnotation(Util.this.context.newAnnotationReference(Override.class));
                    it.addAnnotation(Util.this.context.newAnnotationReference(Pure.class));
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        @Override
                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append(ToStringBuilder.class);
                            _builder.append(" b = new ");
                            _builder.append(ToStringBuilder.class);
                            _builder.append("(this);");
                            _builder.newLineIfNotEmpty();
                            boolean _isSkipNulls = config.isSkipNulls();
                            if (_isSkipNulls) {
                                _builder.append("b.skipNulls();");
                            }
                            _builder.newLineIfNotEmpty();
                            boolean _isSingleLine = config.isSingleLine();
                            if (_isSingleLine) {
                                _builder.append("b.singleLine();");
                            }
                            _builder.newLineIfNotEmpty();
                            boolean _isHideFieldNames = config.isHideFieldNames();
                            if (_isHideFieldNames) {
                                _builder.append("b.hideFieldNames();");
                            }
                            _builder.newLineIfNotEmpty();
                            boolean _isVerbatimValues = config.isVerbatimValues();
                            if (_isVerbatimValues) {
                                _builder.append("b.verbatimValues();");
                            }
                            _builder.newLineIfNotEmpty();
                            for (FieldDeclaration field : fields) {
                                _builder.append("b.add(\"");
                                String _simpleName = field.getSimpleName();
                                _builder.append(_simpleName);
                                _builder.append("\", this.");
                                String _simpleName_1 = field.getSimpleName();
                                _builder.append(_simpleName_1);
                                _builder.append(");");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append("return b.toString();");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                }
            };
            cls.addMethod("toString", _function);
        }
    }
}

