/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

@FinalFieldsConstructor
public class Source2GeneratedMapping
implements Externalizable {
    private final Multimap<URI, URI> source2generated;
    private final Multimap<URI, URI> generated2source;
    private final Map<URI, String> generated2OutputConfigName;

    public Source2GeneratedMapping() {
        this(HashMultimap.create(), HashMultimap.create(), CollectionLiterals.newHashMap());
    }

    public Source2GeneratedMapping copy() {
        HashMultimap<URI, URI> _create = HashMultimap.create(this.source2generated);
        HashMultimap<URI, URI> _create_1 = HashMultimap.create(this.generated2source);
        HashMap<URI, String> _hashMap = new HashMap<URI, String>(this.generated2OutputConfigName);
        return new Source2GeneratedMapping(_create, _create_1, _hashMap);
    }

    public void addSource2Generated(URI source, URI generated) {
        this.addSource2Generated(source, generated, "DEFAULT_OUTPUT");
    }

    public void addSource2Generated(URI source, URI generated, String outputCfgName) {
        this.source2generated.put(source, generated);
        this.generated2source.put(generated, source);
        this.generated2OutputConfigName.put(generated, outputCfgName);
    }

    public void removeSource2Generated(URI source, URI generated) {
        this.source2generated.remove(source, generated);
        this.generated2source.remove(generated, source);
    }

    public Set<URI> deleteSource(URI source) {
        Collection<URI> _removeAll = this.source2generated.removeAll(source);
        HashSet<URI> generated = new HashSet<URI>(_removeAll);
        Consumer<URI> _function = it -> this.generated2source.remove(it, source);
        generated.forEach(_function);
        return generated;
    }

    public void deleteGenerated(URI generated) {
        Consumer<URI> _function = it -> this.source2generated.remove(it, generated);
        this.generated2source.removeAll(generated).forEach(_function);
        this.generated2OutputConfigName.remove(generated);
    }

    public String getOutputConfigName(URI generated) {
        return this.generated2OutputConfigName.get(generated);
    }

    public List<URI> getGenerated(URI source) {
        return Lists.newArrayList(this.source2generated.get(source));
    }

    public List<URI> getSource(URI generated) {
        return Lists.newArrayList(this.generated2source.get(generated));
    }

    public List<URI> getAllGenerated() {
        return Lists.newArrayList(this.generated2source.keySet());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int numEntries = in.readInt();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, numEntries, true);
        for (Integer i : _doubleDotLessThan) {
            URI source = URI.createURI(in.readUTF());
            int numGenerated = in.readInt();
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, numGenerated, true);
            for (Integer j : _doubleDotLessThan_1) {
                URI generated = URI.createURI(in.readUTF());
                String outputConfig = in.readUTF();
                this.addSource2Generated(source, generated, outputConfig);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Set<Map.Entry<URI, Collection<URI>>> entries = this.source2generated.asMap().entrySet();
        out.writeInt(entries.size());
        Consumer<Map.Entry> _function = it -> {
            try {
                out.writeUTF(((URI)it.getKey()).toString());
                out.writeInt(((Collection)it.getValue()).size());
                Consumer<URI> _function_1 = it_1 -> {
                    try {
                        out.writeUTF(it_1.toString());
                        String _elvis = null;
                        String _get = this.generated2OutputConfigName.get(it_1);
                        _elvis = _get != null ? _get : "DEFAULT_OUTPUT";
                        out.writeUTF(_elvis);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow(_e);
                    }
                };
                ((Collection)it.getValue()).forEach(_function_1);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
            }
        };
        entries.forEach(_function);
    }

    public Source2GeneratedMapping(Multimap<URI, URI> source2generated, Multimap<URI, URI> generated2source, Map<URI, String> generated2OutputConfigName) {
        this.source2generated = source2generated;
        this.generated2source = generated2source;
        this.generated2OutputConfigName = generated2OutputConfigName;
    }
}

