/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;

public class DefaultTerminalConverter
extends AbstractLexerBasedConverter<Object> {
    private EDataType dataType;

    protected DefaultTerminalConverter() {
    }

    protected void setDataType(EDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public Object toValue(String string, INode node) throws ValueConverterException {
        try {
            return this.dataType.getEPackage().getEFactoryInstance().createFromString(this.dataType, string);
        }
        catch (Exception exc) {
            throw new ValueConverterException("Error converting string to value", node, exc);
        }
    }

    @Override
    protected String toEscapedString(Object value) {
        return this.dataType.getEPackage().getEFactoryInstance().convertToString(this.dataType, value);
    }

    public static class Factory {
        @Inject
        protected Provider<DefaultTerminalConverter> provider;

        public DefaultTerminalConverter create(TerminalRule terminalRule) {
            EDataType dataType = (EDataType)terminalRule.getType().getClassifier();
            DefaultTerminalConverter defaultTerminalConverter = this.provider.get();
            defaultTerminalConverter.setDataType(dataType);
            defaultTerminalConverter.setRule(terminalRule);
            return defaultTerminalConverter;
        }
    }
}

