/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class STRINGValueConverter
extends AbstractLexerBasedConverter<String> {
    @Override
    protected String toEscapedString(String value) {
        return '\"' + Strings.convertToJavaString(value, false) + '\"';
    }

    @Override
    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            if (string.length() == 1) {
                throw new ValueConverterWithValueException(this.getStringNotClosedMessage(), node, "", null);
            }
            return this.convertFromString(string, node);
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, e);
        }
    }

    protected String convertFromString(String literal, INode node) throws ValueConverterWithValueException {
        char aChar;
        char[] convtBuf;
        char[] in = literal.toCharArray();
        int off = 1;
        int len = literal.length() - 1;
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        String errorMessage = null;
        int errorIndex = -1;
        int errorLength = -1;
        block16: while (off < end - 1) {
            if ((aChar = in[off++]) == '\\') {
                if (off < end) {
                    aChar = in[off++];
                    switch (aChar) {
                        case 'u': {
                            int value = 0;
                            if (off + 4 > end || !this.isHexSequence(in, off, 4)) {
                                out[outLen++] = aChar;
                                if (errorMessage != null) continue block16;
                                errorMessage = "Invalid unicode";
                                errorIndex = off - 2;
                                errorLength = 2;
                                continue block16;
                            }
                            block17: for (int i = 0; i < 4; ++i) {
                                aChar = in[off++];
                                switch (aChar) {
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        value = (value << 4) + aChar - 48;
                                        continue block17;
                                    }
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': {
                                        value = (value << 4) + 10 + aChar - 97;
                                        continue block17;
                                    }
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': {
                                        value = (value << 4) + 10 + aChar - 65;
                                        continue block17;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                }
                            }
                            out[outLen++] = (char)value;
                            continue block16;
                        }
                        case 't': {
                            out[outLen++] = 9;
                            continue block16;
                        }
                        case 'r': {
                            out[outLen++] = 13;
                            continue block16;
                        }
                        case 'n': {
                            out[outLen++] = 10;
                            continue block16;
                        }
                        case 'f': {
                            out[outLen++] = 12;
                            continue block16;
                        }
                        case 'b': {
                            out[outLen++] = 8;
                            continue block16;
                        }
                        case '\"': {
                            out[outLen++] = 34;
                            continue block16;
                        }
                        case '\'': {
                            out[outLen++] = 39;
                            continue block16;
                        }
                        case '\\': {
                            out[outLen++] = 92;
                            continue block16;
                        }
                    }
                    if (errorMessage == null) {
                        errorMessage = this.getInvalidEscapeSequenceMessage();
                        errorIndex = off - 2;
                        errorLength = 2;
                    }
                    out[outLen++] = aChar;
                    continue;
                }
                if (errorMessage == null) {
                    errorMessage = this.getInvalidEscapeSequenceMessage();
                    errorIndex = off - 1;
                    errorLength = 1;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        if (off < end) {
            if (off != end - 1) {
                throw new IllegalStateException();
            }
            aChar = in[off];
            if (in[0] != in[off]) {
                out[outLen++] = aChar;
                if (errorMessage == null) {
                    if (in[off] == '\\') {
                        errorMessage = this.getInvalidEscapeSequenceMessage();
                        errorIndex = off;
                        errorLength = 1;
                    } else {
                        errorMessage = this.getStringNotClosedMessage();
                    }
                } else {
                    errorMessage = this.getStringNotClosedMessage();
                    errorIndex = -1;
                    errorLength = -1;
                }
            }
        }
        if (errorMessage != null) {
            throw new ValueConverterWithValueException(errorMessage, node, new String(out, 0, outLen), errorIndex, errorLength, null);
        }
        return new String(out, 0, outLen);
    }

    protected String getInvalidEscapeSequenceMessage() {
        return "Invalid escape sequence (valid ones are  \\b  \\t  \\n  \\f  \\r  \\\"  \\'  \\\\ )";
    }

    protected String getStringNotClosedMessage() {
        return "String literal is not properly closed";
    }

    protected boolean isHexSequence(char[] in, int off, int chars) {
        block3: for (int i = off; i < in.length && i < off + chars; ++i) {
            char c = in[i];
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

