/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.util.IAcceptor;

@Singleton
public class DefaultResourceDescriptionStrategy
implements IDefaultResourceDescriptionStrategy {
    private static final Logger LOG = Logger.getLogger(DefaultResourceDescriptionStrategy.class);
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private LazyURIEncoder uriEncoder;

    public void setQualifiedNameProvider(IQualifiedNameProvider qualifiedNameProvider) {
        this.qualifiedNameProvider = qualifiedNameProvider;
    }

    public IQualifiedNameProvider getQualifiedNameProvider() {
        return this.qualifiedNameProvider;
    }

    public void setLazyURIEncoder(LazyURIEncoder uriEncoder) {
        this.uriEncoder = uriEncoder;
    }

    public LazyURIEncoder getLazyURIEncoder() {
        return this.uriEncoder;
    }

    @Override
    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        try {
            QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName(eObject);
            if (qualifiedName != null) {
                acceptor.accept(EObjectDescription.create(qualifiedName, eObject));
            }
        }
        catch (Exception exc) {
            LOG.error(exc.getMessage(), exc);
        }
        return true;
    }

    @Override
    public boolean createReferenceDescriptions(EObject from, URI exportedContainerURI, IAcceptor<IReferenceDescription> acceptor) {
        EList<EReference> references = from.eClass().getEAllReferences();
        for (EReference eReference : references) {
            Object val;
            if (!this.isIndexable(eReference) || !from.eIsSet(eReference) || (val = from.eGet(eReference, false)) == null) continue;
            if (eReference.isMany()) {
                InternalEList list = (InternalEList)val;
                for (int i = 0; i < list.size(); ++i) {
                    EObject to = (EObject)list.basicGet(i);
                    if (!this.isResolvedAndExternal(from, to)) continue;
                    acceptor.accept(this.createReferenceDescription(from, exportedContainerURI, eReference, i, to));
                }
                continue;
            }
            EObject to = (EObject)val;
            if (!this.isResolvedAndExternal(from, to)) continue;
            acceptor.accept(this.createReferenceDescription(from, exportedContainerURI, eReference, -1, to));
        }
        return true;
    }

    protected IReferenceDescription createReferenceDescription(EObject owner, URI exportedContainerURI, EReference eReference, int indexInList, EObject target) {
        return new DefaultReferenceDescription(owner, target, eReference, indexInList, exportedContainerURI);
    }

    protected boolean isIndexable(EReference eReference) {
        return !(eReference.isContainment() && !eReference.isResolveProxies() || eReference.isDerived() || eReference.isVolatile() || eReference.isTransient() || eReference.isContainer() && !eReference.isResolveProxies());
    }

    protected boolean isResolvedAndExternal(EObject from, EObject to) {
        if (to == null) {
            return false;
        }
        if (!to.eIsProxy()) {
            if (to.eResource() == null) {
                LOG.error("Reference from " + EcoreUtil.getURI(from) + " to " + to + " cannot be exported as the target is not contained in a resource.");
                return false;
            }
            return from.eResource() != to.eResource();
        }
        return !this.getLazyURIEncoder().isCrossLinkFragment(from.eResource(), ((InternalEObject)to).eProxyURI().fragment());
    }
}

