/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Strings {
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char SEPARATOR = ':';
    private static final char[] separator = System.getProperty("line.separator").toCharArray();

    public static boolean equalsIgnoreWhitespace(String left, String right) {
        String l = left == null ? "" : left.replaceAll("\\s", "");
        String r = right == null ? "" : right.replaceAll("\\s", "");
        return l.equals(r);
    }

    public static boolean equal(String literal, String name) {
        return Strings.isEmpty(literal) ? Strings.isEmpty(name) : literal.equals(name);
    }

    public static String notNull(Object o) {
        return String.valueOf(o);
    }

    public static String emptyIfNull(String s2) {
        return s2 == null ? "" : s2;
    }

    public static String concat(String separator, List<String> list) {
        return Strings.concat(separator, list, 0);
    }

    public static <T> String toString(Collection<T> list, Function<T, String> toString, String delim) {
        StringBuffer buffer = new StringBuffer();
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            buffer.append(toString.apply(t));
            if (!iterator.hasNext()) continue;
            buffer.append(delim);
        }
        return buffer.toString();
    }

    public static String concat(String separator, List<String> list, int skip) {
        StringBuffer buff = new StringBuffer();
        int lastIndex = list.size() - skip;
        for (int i = 0; i < lastIndex; ++i) {
            buff.append(list.get(i));
            if (i + 1 >= lastIndex) continue;
            buff.append(separator);
        }
        String string = buff.toString();
        return string.trim().length() == 0 ? null : string;
    }

    public static String skipLastToken(String value, String separator) {
        int endIndex = value.lastIndexOf(separator);
        if (endIndex > 0) {
            return value.substring(0, endIndex);
        }
        return value;
    }

    public static String lastToken(String value, String separator) {
        int index = value.lastIndexOf(separator) + separator.length();
        if (index < value.length()) {
            return value.substring(index, value.length());
        }
        return "";
    }

    public static String toFirstUpper(String s2) {
        if (s2 == null || s2.length() == 0 || Character.isUpperCase(s2.charAt(0))) {
            return s2;
        }
        if (s2.length() == 1) {
            return s2.toUpperCase();
        }
        return s2.substring(0, 1).toUpperCase() + s2.substring(1);
    }

    public static boolean isEmpty(String s2) {
        return s2 == null || s2.equals("");
    }

    public static String newLine() {
        return System.getProperty("line.separator");
    }

    public static String toPlatformLineSeparator(CharSequence cs) {
        return cs.toString().replaceAll("\r?\n", Strings.newLine());
    }

    public static String toFirstLower(String s2) {
        if (s2 == null || s2.length() == 0 || Character.isLowerCase(s2.charAt(0))) {
            return s2;
        }
        if (s2.length() == 1) {
            return s2.toLowerCase();
        }
        return s2.substring(0, 1).toLowerCase() + s2.substring(1);
    }

    public static String convertFromJavaString(String javaString, boolean useUnicode) {
        char[] convtBuf;
        char[] in = javaString.toCharArray();
        int off = 0;
        int len = javaString.length();
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            char aChar;
            if ((aChar = in[off++]) == '\\') {
                aChar = in[off++];
                if (useUnicode && aChar == 'u') {
                    int value = 0;
                    if (off + 4 > end) {
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                    }
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 't') {
                    aChar = '\t';
                } else if (aChar == 'r') {
                    aChar = '\r';
                } else if (aChar == 'n') {
                    aChar = '\n';
                } else if (aChar == 'f') {
                    aChar = '\f';
                } else if (aChar == 'b') {
                    aChar = '\b';
                } else if (aChar == '\"') {
                    aChar = '\"';
                } else if (aChar == '\'') {
                    aChar = '\'';
                } else if (aChar == '\\') {
                    aChar = '\\';
                } else {
                    throw new IllegalArgumentException("Illegal escape character \\" + aChar);
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String convertToJavaString(String theString) {
        return Strings.convertToJavaString(theString, true);
    }

    public static String convertToJavaString(String theString, boolean useUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block10: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    outBuffer.append(' ');
                    continue block10;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block10;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block10;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block10;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block10;
                }
                case '\b': {
                    outBuffer.append('\\');
                    outBuffer.append('b');
                    continue block10;
                }
                case '\'': {
                    outBuffer.append('\\');
                    outBuffer.append('\'');
                    continue block10;
                }
                case '\"': {
                    outBuffer.append('\\');
                    outBuffer.append('\"');
                    continue block10;
                }
                default: {
                    if (useUnicode && (aChar < ' ' || aChar > '~')) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(Strings.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(Strings.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(Strings.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(Strings.toHex(aChar & 0xF));
                        continue block10;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static List<String> split(String value, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        int index = value.indexOf(delimiter, lastIndex);
        int pendingEmptyStrings = 0;
        while (index != -1) {
            String addMe = value.substring(lastIndex, index);
            if (addMe.length() == 0) {
                ++pendingEmptyStrings;
            } else {
                while (pendingEmptyStrings > 0) {
                    result.add("");
                    --pendingEmptyStrings;
                }
                result.add(addMe);
            }
            lastIndex = index + delimiter.length();
            index = value.indexOf(delimiter, lastIndex);
        }
        if (lastIndex != value.length()) {
            while (pendingEmptyStrings > 0) {
                result.add("");
                --pendingEmptyStrings;
            }
            result.add(value.substring(lastIndex));
        }
        return result;
    }

    public static List<String> split(String value, char delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        int index = value.indexOf(delimiter, lastIndex);
        int pendingEmptyStrings = 0;
        while (index != -1) {
            String addMe = value.substring(lastIndex, index);
            if (addMe.length() == 0) {
                ++pendingEmptyStrings;
            } else {
                while (pendingEmptyStrings > 0) {
                    result.add("");
                    --pendingEmptyStrings;
                }
                result.add(addMe);
            }
            lastIndex = index + 1;
            index = value.indexOf(delimiter, lastIndex);
        }
        if (lastIndex != value.length()) {
            while (pendingEmptyStrings > 0) {
                result.add("");
                --pendingEmptyStrings;
            }
            result.add(value.substring(lastIndex));
        }
        return result;
    }

    public static String pack(String[] strings) {
        if (strings != null && strings.length > 0) {
            StringBuffer buffer = new StringBuffer();
            for (String s2 : strings) {
                buffer.append(s2.length());
                buffer.append(':');
                buffer.append(s2);
            }
            return buffer.toString();
        }
        return null;
    }

    public static String[] unpack(String packed) {
        if (Strings.isEmpty(packed)) {
            return null;
        }
        ArrayList<String> strings = Lists.newArrayList();
        Strings.unpack(strings, packed);
        return strings.toArray(new String[strings.size()]);
    }

    private static void unpack(List<String> strings, String packed) {
        int delimiterIndex = packed.indexOf(":");
        int size = Integer.parseInt(packed.substring(0, delimiterIndex));
        int endIndex = delimiterIndex + 1 + size;
        strings.add(packed.substring(delimiterIndex + 1, endIndex));
        if (endIndex < packed.length()) {
            Strings.unpack(strings, packed.substring(endIndex));
        }
    }

    public static String removeLeadingWhitespace(String indentationString) {
        int i;
        for (i = 0; i < indentationString.length() && Character.isWhitespace(indentationString.charAt(i)); ++i) {
        }
        return indentationString.substring(i);
    }

    public static int countLineBreaks(CharSequence text) {
        return Strings.countLineBreaks(text, 0, text.length());
    }

    public static int countLineBreaks(CharSequence text, int startInclusive, int endExclusive) {
        int result = 0;
        for (int i = startInclusive; i < endExclusive; ++i) {
            char ch = text.charAt(i);
            if (ch == '\r') {
                ++result;
                if (i + 1 >= endExclusive || text.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            if (ch != '\n') continue;
            ++result;
        }
        return result;
    }

    public static CharSequence trimTrailingLineBreak(CharSequence s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.length() == 0) {
            return s2;
        }
        if (s2.charAt(s2.length() - 1) == '\n') {
            if (s2.length() > 1 && s2.charAt(s2.length() - 2) == '\r') {
                return s2.subSequence(0, s2.length() - 2);
            }
            return s2.subSequence(0, s2.length() - 1);
        }
        if (s2.charAt(s2.length() - 1) == '\r') {
            return s2.subSequence(0, s2.length() - 1);
        }
        return s2;
    }

    public static int countLines(String text) {
        return Strings.countLines(text, separator);
    }

    public static int countLines(String text, char[] separator) {
        return Strings.countLines(text, separator, 0, text.length());
    }

    public static int countLines(String text, char[] separator, int startInclusive, int endExclusive) {
        int line = 0;
        if (separator.length == 1) {
            char c = separator[0];
            for (int i = startInclusive; i < endExclusive; ++i) {
                if (text.charAt(i) != c) continue;
                ++line;
            }
        } else if (separator.length == 2) {
            char c1 = separator[0];
            char c2 = separator[1];
            for (int i = startInclusive; i < endExclusive; ++i) {
                if (text.charAt(i) == c1 && endExclusive > i + 1 && text.charAt(i + 1) == c2) {
                    ++line;
                    ++i;
                    continue;
                }
                if (text.charAt(i) != c2) continue;
                ++line;
            }
        } else {
            throw new IllegalArgumentException("Separators with more than two characters are unexpected");
        }
        return line;
    }

    public static String getLeadingWhiteSpace(String original) {
        for (int i = 0; i < original.length(); ++i) {
            if (Character.isWhitespace(original.charAt(i))) continue;
            return original.substring(0, i);
        }
        return original;
    }

    public static String wordWrap(String string, int maxCharsPerLine) {
        StringBuilder document = new StringBuilder();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        StringBuilder ws = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                line.append((CharSequence)ws);
                line.append((CharSequence)word);
                line.append("\n");
                document.append((CharSequence)line);
                line = new StringBuilder();
                word = new StringBuilder();
                ws = new StringBuilder();
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (line.length() + word.length() + 1 > maxCharsPerLine) {
                    line.append("\n");
                    document.append((CharSequence)line);
                    line = new StringBuilder();
                    line.append((CharSequence)word);
                    word = new StringBuilder();
                    ws = new StringBuilder();
                    ws.append(c);
                    continue;
                }
                if (word.length() == 0) {
                    ws.append(c);
                    continue;
                }
                line.append((CharSequence)ws);
                line.append((CharSequence)word);
                word = new StringBuilder();
                ws = new StringBuilder();
                ws.append(c);
                continue;
            }
            word.append(c);
        }
        if (line.length() + word.length() + 1 > maxCharsPerLine) {
            document.append((CharSequence)line);
            document.append("\n");
            document.append((CharSequence)word);
        } else {
            document.append((CharSequence)line);
            document.append((CharSequence)ws);
            document.append((CharSequence)word);
        }
        return document.toString();
    }
}

