/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.debug;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.debug.IStratumBreakpointSupport;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;

public class XbaseStratumBreakpointSupport
implements IStratumBreakpointSupport {
    @Override
    public boolean isValidLineForBreakPoint(XtextResource resource, int line) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null) {
            return false;
        }
        ICompositeNode node = parseResult.getRootNode();
        return this.isValidLineForBreakpoint(node, line);
    }

    protected boolean isValidLineForBreakpoint(ICompositeNode node, int line) {
        for (INode n : node.getChildren()) {
            ITextRegionWithLineInformation textRegion = n.getTextRegionWithLineInformation();
            if (textRegion.getLineNumber() <= line && textRegion.getEndLineNumber() >= line) {
                EObject eObject = n.getSemanticElement();
                if (eObject instanceof XExpression && eObject.eClass() != XbasePackage.Literals.XBLOCK_EXPRESSION) {
                    return true;
                }
                if (n instanceof ICompositeNode && this.isValidLineForBreakpoint((ICompositeNode)n, line)) {
                    return true;
                }
            }
            if (textRegion.getLineNumber() <= line) continue;
            return false;
        }
        return false;
    }
}

