/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractUnresolvableReference;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;

public class TypeInsteadOfConstructorLinkingCandidate
extends AbstractUnresolvableReference
implements IConstructorLinkingCandidate {
    private final IIdentifiableElementDescription description;

    public TypeInsteadOfConstructorLinkingCandidate(XConstructorCall constructorCall, IIdentifiableElementDescription description, ExpressionTypeComputationState state) {
        super(constructorCall, state);
        this.description = description;
    }

    @Override
    public JvmConstructor getConstructor() {
        return null;
    }

    @Override
    public boolean isAnonymousClassConstructorCall() {
        return false;
    }

    @Override
    protected void applyType() {
        JvmType type = (JvmType)this.getFeature();
        if (type == null || type.eIsProxy()) {
            throw new IllegalStateException();
        }
        ITypeReferenceOwner referenceOwner = this.getResolvedTypes().getReferenceOwner();
        ParameterizedTypeReference result = referenceOwner.newParameterizedTypeReference(type);
        for (LightweightTypeReference typeArgument : this.getTypeArguments()) {
            result.addTypeArgument(typeArgument);
        }
        this.getState().acceptActualType(result);
    }

    @Override
    public XConstructorCall getConstructorCall() {
        return (XConstructorCall)this.getExpression();
    }

    @Override
    protected List<XExpression> getArguments() {
        return this.getConstructorCall().getArguments();
    }

    @Override
    public JvmIdentifiableElement getFeature() {
        return this.description.getElementOrProxy();
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        JvmType type = (JvmType)this.description.getElementOrProxy();
        String typeKind = "";
        if (type instanceof JvmPrimitiveType || type instanceof JvmVoid) {
            typeKind = "primitive type";
        } else if (type instanceof JvmAnnotationType) {
            typeKind = "annotation type";
        } else if (type instanceof JvmEnumerationType) {
            typeKind = "enum type";
        } else if (type instanceof JvmGenericType && ((JvmGenericType)type).isInterface()) {
            typeKind = "interface type";
        } else if (type instanceof JvmTypeParameter) {
            typeKind = "type parameter";
        }
        String message = String.format("Cannot instantiate the %s %s", typeKind, type.getSimpleName());
        EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_class_instantiation", message, this.getExpression(), XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, -1, null);
        result.accept(diagnostic);
        return false;
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        EList<JvmTypeParameter> typeParameters;
        JvmType type = (JvmType)this.getFeature();
        if (type == null || type.eIsProxy()) {
            throw new IllegalStateException();
        }
        ITypeReferenceOwner referenceOwner = this.getResolvedTypes().getReferenceOwner();
        if (type instanceof JvmTypeParameterDeclarator && !(typeParameters = ((JvmTypeParameterDeclarator)((Object)type)).getTypeParameters()).isEmpty()) {
            ArrayList<LightweightTypeReference> result = Lists.newArrayList();
            List<LightweightTypeReference> typeArguments = this.getSyntacticTypeArguments();
            int max = Math.min(typeParameters.size(), typeArguments.size());
            for (int i = 0; i < max; ++i) {
                result.add(typeArguments.get(i));
            }
            if (max < typeParameters.size()) {
                TypeParameterByConstraintSubstitutor substitutor = new TypeParameterByConstraintSubstitutor(Collections.emptyMap(), referenceOwner);
                for (int i = max; i < typeParameters.size(); ++i) {
                    JvmTypeParameter typeParameter = (JvmTypeParameter)typeParameters.get(i);
                    result.add(substitutor.substitute(typeParameter));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<LightweightTypeReference> getSyntacticTypeArguments() {
        XConstructorCall constructorCall = this.getConstructorCall();
        EList<JvmTypeReference> typeArguments = constructorCall.getTypeArguments();
        if (typeArguments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LightweightTypeReference> result = Lists.newArrayList();
        for (JvmTypeReference typeArgument : typeArguments) {
            result.add(this.getState().getReferenceOwner().toLightweightTypeReference(typeArgument));
        }
        return result;
    }

    @Override
    public void applyToModel(IResolvedTypes resolvedTypes) {
        Resource resource = this.getExpression().eResource();
        if (resource instanceof LazyLinkingResource) {
            LazyLinkingResource lazyLinkingResource = (LazyLinkingResource)resource;
            InternalEObject referenced = (InternalEObject)this.getExpression().eGet(XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, false);
            lazyLinkingResource.markUnresolvable(referenced);
        }
    }
}

