/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.IOverrideCheckResult;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.LazyOverrideCheckResult;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedOperationInHierarchy;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

public class OverrideTester {
    private final IVisibilityHelper visibilityHelper;

    @Inject
    public OverrideTester(IVisibilityHelper visibilityHelper) {
        this.visibilityHelper = visibilityHelper;
    }

    public OverrideTester() {
        this(IVisibilityHelper.ALL);
    }

    public IOverrideCheckResult isSubsignature(AbstractResolvedOperation overriding, JvmOperation overridden, boolean checkInheritance) {
        JvmOperation declaration = (JvmOperation)overriding.getDeclaration();
        if (declaration == overridden) {
            return new LazyOverrideCheckResult(overriding, overridden, IOverrideCheckResult.OverrideCheckDetails.CURRENT);
        }
        if (overridden.getDeclaringType() == declaration.getDeclaringType()) {
            return new LazyOverrideCheckResult(overriding, overridden, IOverrideCheckResult.OverrideCheckDetails.SAME_DECLARATOR);
        }
        ITypeReferenceOwner owner = overriding.getContextType().getOwner();
        ParameterizedTypeReference currentDeclarator = null;
        if (checkInheritance && !(currentDeclarator = owner.newParameterizedTypeReference(declaration.getDeclaringType())).isSubtypeOf(overridden.getDeclaringType())) {
            return new LazyOverrideCheckResult(overriding, overridden, IOverrideCheckResult.OverrideCheckDetails.NO_INHERITANCE);
        }
        if (!Strings.equal(overridden.getSimpleName(), declaration.getSimpleName())) {
            return new LazyOverrideCheckResult(overriding, overridden, IOverrideCheckResult.OverrideCheckDetails.NAME_MISMATCH);
        }
        int parameterCount = overridden.getParameters().size();
        if (parameterCount != declaration.getParameters().size()) {
            return new LazyOverrideCheckResult(overriding, overridden, IOverrideCheckResult.OverrideCheckDetails.ARITY_MISMATCH);
        }
        if (currentDeclarator == null) {
            currentDeclarator = owner.newParameterizedTypeReference(declaration.getDeclaringType());
        }
        if (!new ContextualVisibilityHelper(this.visibilityHelper, currentDeclarator).isVisible(overridden)) {
            return new LazyOverrideCheckResult(overriding, overridden, IOverrideCheckResult.OverrideCheckDetails.NOT_VISIBLE);
        }
        if (declaration.isStatic() != overridden.isStatic()) {
            return new LazyOverrideCheckResult(overriding, overridden, IOverrideCheckResult.OverrideCheckDetails.STATIC_MISMATCH);
        }
        ResolvedOperationInHierarchy overriddenInHierarchy = new ResolvedOperationInHierarchy(overridden, overriding.getBottom());
        if (parameterCount != 0 && !this.isMatchingParameterList(overriding, overriddenInHierarchy)) {
            return new LazyOverrideCheckResult(overriding, overridden, IOverrideCheckResult.OverrideCheckDetails.PARAMETER_TYPE_MISMATCH);
        }
        if (!this.isMatchingTypeParameters(overriding, overriddenInHierarchy)) {
            return new LazyOverrideCheckResult(overriding, overridden, IOverrideCheckResult.OverrideCheckDetails.TYPE_PARAMETER_MISMATCH);
        }
        return new LazyOverrideCheckResult(overriding, overridden, this.getPrimaryValidDetail(overriding, overridden));
    }

    protected EnumSet<IOverrideCheckResult.OverrideCheckDetails> getAllDetails(AbstractResolvedOperation overriding, JvmOperation overridden, IOverrideCheckResult.OverrideCheckDetails primary) {
        EnumSet<IOverrideCheckResult.OverrideCheckDetails> result = EnumSet.of(primary);
        ResolvedOperationInHierarchy overriddenInHierarchy = new ResolvedOperationInHierarchy(overridden, overriding.getBottom());
        switch (primary) {
            case CURRENT: 
            case NO_INHERITANCE: 
            case NAME_MISMATCH: 
            case ARITY_MISMATCH: {
                return result;
            }
            case SAME_DECLARATOR: 
            case TYPE_PARAMETER_MISMATCH: 
            case PARAMETER_TYPE_MISMATCH: {
                if (this.isSameErasure(overriding, overriddenInHierarchy)) {
                    result.add(IOverrideCheckResult.OverrideCheckDetails.SAME_ERASURE);
                    if (this.isConflictingDefaultImplementation(overriding, overriddenInHierarchy)) {
                        result.add(IOverrideCheckResult.OverrideCheckDetails.DEFAULT_IMPL_CONFLICT);
                    }
                }
                return result;
            }
            case NOT_VISIBLE: 
            case STATIC_MISMATCH: {
                if (!overriding.getResolvedParameterTypes().isEmpty() && !this.isMatchingParameterList(overriding, overriddenInHierarchy)) {
                    result.add(IOverrideCheckResult.OverrideCheckDetails.PARAMETER_TYPE_MISMATCH);
                    return result;
                }
                if (!this.isMatchingTypeParameters(overriding, overriddenInHierarchy)) {
                    result.add(IOverrideCheckResult.OverrideCheckDetails.TYPE_PARAMETER_MISMATCH);
                    return result;
                }
            }
            case REPEATED: 
            case SHADOWED: 
            case IMPLEMENTATION: 
            case REDECLARATION: 
            case OVERRIDE: {
                this.addAdditionalDetails(overriding, overriddenInHierarchy, result);
                return result;
            }
        }
        throw new IllegalArgumentException("Unexpected primary detail: " + (Object)((Object)primary));
    }

    protected boolean isSameErasure(AbstractResolvedOperation overriding, AbstractResolvedOperation overridden) {
        List<LightweightTypeReference> overridingParameterTypes = overriding.getResolvedParameterTypes();
        List<LightweightTypeReference> overriddenParameterTypes = overridden.getResolvedParameterTypes();
        if (overridingParameterTypes.size() != overriddenParameterTypes.size()) {
            return false;
        }
        for (int i = 0; i < overridingParameterTypes.size(); ++i) {
            String erasedOverriddenParameterTypeIdentifier;
            LightweightTypeReference overridingParameterType = overridingParameterTypes.get(i);
            LightweightTypeReference overriddenParameterType = overriddenParameterTypes.get(i);
            String erasedOverridingParameterTypeIdentifier = overridingParameterType.getRawTypeReference().getJavaIdentifier();
            if (erasedOverridingParameterTypeIdentifier.equals(erasedOverriddenParameterTypeIdentifier = overriddenParameterType.getRawTypeReference().getJavaIdentifier())) continue;
            return false;
        }
        return true;
    }

    protected void addAdditionalDetails(AbstractResolvedOperation overriding, AbstractResolvedOperation overridden, EnumSet<IOverrideCheckResult.OverrideCheckDetails> result) {
        this.addReturnTypeDetails(overriding, overridden, result);
        this.addExceptionDetails(overriding, overridden, result);
        JvmOperation overridingDecl = (JvmOperation)overriding.getDeclaration();
        JvmOperation overriddenDecl = (JvmOperation)overridden.getDeclaration();
        if (this.isMorePrivateThan(overridingDecl.getVisibility(), overriddenDecl.getVisibility())) {
            result.add(IOverrideCheckResult.OverrideCheckDetails.REDUCED_VISIBILITY);
        }
        if (overriddenDecl.isFinal()) {
            result.add(IOverrideCheckResult.OverrideCheckDetails.IS_FINAL);
        }
        if (overridingDecl.isVarArgs() != overriddenDecl.isVarArgs()) {
            result.add(IOverrideCheckResult.OverrideCheckDetails.VAR_ARG_MISMATCH);
        }
        if (this.isConflictingDefaultImplementation(overriding, overridden)) {
            result.add(IOverrideCheckResult.OverrideCheckDetails.DEFAULT_IMPL_CONFLICT);
        }
        if (!overridingDecl.isSynchronized() && overriddenDecl.isSynchronized()) {
            result.add(IOverrideCheckResult.OverrideCheckDetails.SYNCHRONIZED_MISMATCH);
        }
    }

    protected void addExceptionDetails(AbstractResolvedOperation overriding, AbstractResolvedOperation overridden, EnumSet<IOverrideCheckResult.OverrideCheckDetails> result) {
        List<LightweightTypeReference> exceptions = overriding.getResolvedExceptions();
        if (exceptions.isEmpty()) {
            return;
        }
        List<LightweightTypeReference> inheritedExceptions = overridden.getResolvedExceptions();
        for (LightweightTypeReference exception : exceptions) {
            if (exception.isSubtypeOf(RuntimeException.class) || exception.isSubtypeOf(Error.class)) continue;
            boolean isDeclared = false;
            for (LightweightTypeReference inheritedException : inheritedExceptions) {
                if (!inheritedException.isAssignableFrom(exception)) continue;
                isDeclared = true;
                break;
            }
            if (isDeclared) continue;
            result.add(IOverrideCheckResult.OverrideCheckDetails.EXCEPTION_MISMATCH);
            return;
        }
    }

    protected void addReturnTypeDetails(AbstractResolvedOperation overriding, AbstractResolvedOperation overridden, EnumSet<IOverrideCheckResult.OverrideCheckDetails> result) {
        TypeConformanceComputationArgument conformanceArgument;
        LightweightTypeReference overridingReturnType = overriding.getResolvedReturnType();
        LightweightTypeReference overriddenReturnType = overridden.getResolvedReturnType();
        if (!overriddenReturnType.isAssignableFrom(overridingReturnType, conformanceArgument = new TypeConformanceComputationArgument(false, false, false, false, false, false))) {
            if (overriding.getTypeParameters().isEmpty() && !overridden.getTypeParameters().isEmpty()) {
                TypeConformanceComputationArgument rawConformanceArgument = new TypeConformanceComputationArgument(true, false, false, false, false, false);
                if (!overriddenReturnType.isAssignableFrom(overridingReturnType, rawConformanceArgument)) {
                    result.add(IOverrideCheckResult.OverrideCheckDetails.RETURN_MISMATCH);
                } else {
                    result.add(IOverrideCheckResult.OverrideCheckDetails.UNCHECKED_CONVERSION_REQUIRED);
                    if (overridingReturnType.getRawTypeReference().getType() != overriddenReturnType.getRawTypeReference().getType()) {
                        result.add(IOverrideCheckResult.OverrideCheckDetails.COVARIANT_RETURN);
                    }
                }
            } else {
                result.add(IOverrideCheckResult.OverrideCheckDetails.RETURN_MISMATCH);
            }
        } else if (!overriddenReturnType.getJavaIdentifier().equals(overridingReturnType.getJavaIdentifier())) {
            if (!overridden.isRawTypeInheritance() && overriding.getTypeParameters().isEmpty() && !overridden.getTypeParameters().isEmpty() && overridden.getTypeParameters().contains(((JvmOperation)overridden.getDeclaration()).getReturnType().getType())) {
                result.add(IOverrideCheckResult.OverrideCheckDetails.UNCHECKED_CONVERSION_REQUIRED);
            }
            result.add(IOverrideCheckResult.OverrideCheckDetails.COVARIANT_RETURN);
        }
    }

    protected boolean isMorePrivateThan(JvmVisibility o1, JvmVisibility o2) {
        if (o1 == o2) {
            return false;
        }
        switch (o1) {
            case DEFAULT: {
                return o2 != JvmVisibility.PRIVATE;
            }
            case PRIVATE: {
                return true;
            }
            case PROTECTED: {
                return o2 == JvmVisibility.PUBLIC;
            }
            case PUBLIC: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown JvmVisibility " + o1);
    }

    protected boolean isConflictingDefaultImplementation(AbstractResolvedOperation overriding, AbstractResolvedOperation overridden) {
        JvmOperation ridingDecl = (JvmOperation)overriding.getDeclaration();
        JvmOperation riddenDecl = (JvmOperation)overridden.getDeclaration();
        if (this.isInterface(ridingDecl.getDeclaringType()) && this.isInterface(riddenDecl.getDeclaringType()) && (!ridingDecl.isAbstract() || !riddenDecl.isAbstract())) {
            LightweightTypeReference ridingTypeRef = overriding.getResolvedDeclarator();
            LightweightTypeReference riddenTypeRef = overridden.getResolvedDeclarator();
            return !riddenTypeRef.isAssignableFrom(ridingTypeRef);
        }
        return false;
    }

    private boolean isInterface(JvmDeclaredType type) {
        return type instanceof JvmGenericType && ((JvmGenericType)type).isInterface();
    }

    protected boolean isMatchingParameterList(AbstractResolvedOperation overriding, AbstractResolvedOperation overridden) {
        LightweightTypeReference overriddenParameterType;
        LightweightTypeReference overridingParameterType;
        int i;
        List<LightweightTypeReference> overridingParameterTypes = overriding.getResolvedParameterTypes();
        List<LightweightTypeReference> overriddenParameterTypes = overridden.getResolvedParameterTypes();
        boolean testErasure = false;
        for (i = 0; i < overridingParameterTypes.size(); ++i) {
            overridingParameterType = overridingParameterTypes.get(i);
            overriddenParameterType = overriddenParameterTypes.get(i);
            String overridingParameterTypeIdentifier = overridingParameterType.getJavaIdentifier();
            if (overridingParameterTypeIdentifier.equals(overriddenParameterType.getJavaIdentifier())) continue;
            if (!overriding.getTypeParameters().isEmpty()) {
                return false;
            }
            testErasure = true;
            break;
        }
        if (testErasure) {
            for (i = 0; i < overridingParameterTypes.size(); ++i) {
                overridingParameterType = overridingParameterTypes.get(i);
                overriddenParameterType = overriddenParameterTypes.get(i);
                LightweightTypeReference erasureType = overriddenParameterType.getRawTypeReference();
                String overridingParameterTypeIdentifier = overridingParameterType.getJavaIdentifier();
                if (overridingParameterTypeIdentifier.equals(erasureType.getJavaIdentifier())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isMatchingTypeParameters(AbstractResolvedOperation overriding, AbstractResolvedOperation overridden) {
        int overridingTypeParameterCount = overriding.getTypeParameters().size();
        if (overridingTypeParameterCount != overridden.getTypeParameters().size()) {
            for (LightweightTypeReference overridingParameterType : overriding.getResolvedParameterTypes()) {
                if (!overridingParameterType.hasTypeArguments()) continue;
                return false;
            }
            return overridingTypeParameterCount == 0;
        }
        TypeParameterSubstitutor<?> substitutor = overridden.getSubstitutor();
        ITypeReferenceOwner owner = overriding.getContextType().getOwner();
        for (int i = 0; i < overridingTypeParameterCount; ++i) {
            JvmTypeParameter overridingTypeParameter = overriding.getTypeParameters().get(i);
            JvmTypeParameter overriddenTypeParameter = overridden.getTypeParameters().get(i);
            List<LightweightTypeReference> overridingSuperTypes = owner.newParameterizedTypeReference(overridingTypeParameter).getSuperTypes();
            List<LightweightTypeReference> overriddenSuperTypes = owner.newParameterizedTypeReference(overriddenTypeParameter).getSuperTypes();
            if (overridingSuperTypes.size() != overriddenSuperTypes.size()) {
                return false;
            }
            if (overridingSuperTypes.size() == 1) {
                LightweightTypeReference resolved = substitutor.substitute(overriddenSuperTypes.get(0));
                if (overridingSuperTypes.get(0).getJavaIdentifier().equals(resolved.getJavaIdentifier())) continue;
                return false;
            }
            HashSet<String> overridingSuperTypeNames = Sets.newHashSetWithExpectedSize(overriddenSuperTypes.size());
            for (LightweightTypeReference overridingSuperType : overridingSuperTypes) {
                overridingSuperTypeNames.add(overridingSuperType.getJavaIdentifier());
            }
            for (LightweightTypeReference overriddenSuperType : overriddenSuperTypes) {
                LightweightTypeReference resolved = substitutor.substitute(overriddenSuperType);
                if (overridingSuperTypeNames.contains(resolved.getJavaIdentifier())) continue;
                return false;
            }
        }
        return true;
    }

    protected IOverrideCheckResult.OverrideCheckDetails getPrimaryValidDetail(IResolvedOperation overriding, JvmOperation overridden) {
        IOverrideCheckResult.OverrideCheckDetails result = IOverrideCheckResult.OverrideCheckDetails.IMPLEMENTATION;
        JvmOperation declaration = overriding.getDeclaration();
        if (declaration.isStatic()) {
            result = IOverrideCheckResult.OverrideCheckDetails.SHADOWED;
        } else if (declaration.isAbstract()) {
            result = overridden.isAbstract() ? IOverrideCheckResult.OverrideCheckDetails.REPEATED : IOverrideCheckResult.OverrideCheckDetails.REDECLARATION;
        } else if (!overridden.isAbstract()) {
            result = IOverrideCheckResult.OverrideCheckDetails.OVERRIDE;
        }
        return result;
    }
}

