/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.xbase.typesystem.conformance.SuperTypeAcceptor;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeKind;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTraversalData;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;

public abstract class LightweightTypeReference {
    public static final int KIND_LIGHTWEIGHT_TYPE_REFERENCE = 1;
    public static final int KIND_ANY_TYPE_REFERENCE = 2;
    public static final int KIND_ARRAY_TYPE_REFERENCE = 3;
    public static final int KIND_COMPOUND_TYPE_REFERENCE = 4;
    public static final int KIND_PARAMETERIZED_TYPE_REFERENCE = 5;
    public static final int KIND_UNBOUND_TYPE_REFERENCE = 6;
    public static final int KIND_UNKNOWN_TYPE_REFERENCE = 7;
    public static final int KIND_WILDCARD_TYPE_REFERENCE = 8;
    public static final int KIND_FUNCTION_TYPE_REFERENCE = 9;
    public static final int KIND_INNER_TYPE_REFERENCE = 10;
    public static final int KIND_INNER_FUNCTION_TYPE_REFERENCE = 11;
    private ITypeReferenceOwner owner;

    public int getKind() {
        return 1;
    }

    protected LightweightTypeReference(ITypeReferenceOwner owner) {
        this.owner = Preconditions.checkNotNull(owner, "owner");
    }

    public List<LightweightTypeReference> getTypeArguments() {
        return Collections.emptyList();
    }

    public LightweightTypeReference getOuter() {
        return null;
    }

    public boolean hasTypeArguments() {
        return !this.getTypeArguments().isEmpty();
    }

    public boolean isResolved() {
        return true;
    }

    public ITypeReferenceOwner getOwner() {
        return this.owner;
    }

    protected TypesFactory getTypesFactory() {
        return this.getOwner().getServices().getTypesFactory();
    }

    protected CommonTypeComputationServices getServices() {
        return this.getOwner().getServices();
    }

    public boolean isOwnedBy(ITypeReferenceOwner owner) {
        if (this.isResolved()) {
            return true;
        }
        return owner == this.getOwner();
    }

    protected <T> List<T> expose(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public abstract JvmTypeReference toTypeReference();

    public final JvmTypeReference toJavaCompliantTypeReference() {
        return this.toJavaCompliantTypeReference(IVisibilityHelper.ALL);
    }

    public abstract boolean isVisible(IVisibilityHelper var1);

    public abstract JvmTypeReference toJavaCompliantTypeReference(IVisibilityHelper var1);

    protected JvmTypeReference toJavaCompliantTypeReference(List<LightweightTypeReference> types, IVisibilityHelper visibilityHelper) {
        LightweightTypeReference type = this.getServices().getTypeConformanceComputer().getCommonSuperType(types, this.getOwner());
        if (type == null) {
            return this.getOwner().getServices().getTypeReferences().getTypeForName(Object.class, (Notifier)this.getOwner().getContextResourceSet(), new JvmTypeReference[0]);
        }
        return type.toJavaCompliantTypeReference(visibilityHelper);
    }

    protected List<LightweightTypeReference> getNonInterfaceTypes(List<LightweightTypeReference> components) {
        List<LightweightTypeReference> nonInterfaceTypes = null;
        for (LightweightTypeReference component : components) {
            if (component.isInterfaceType()) continue;
            if (nonInterfaceTypes == null) {
                nonInterfaceTypes = Collections.singletonList(component);
                continue;
            }
            if (nonInterfaceTypes.size() == 1) {
                nonInterfaceTypes = Lists.newArrayList(nonInterfaceTypes);
                nonInterfaceTypes.add(component);
                continue;
            }
            nonInterfaceTypes.add(component);
        }
        return nonInterfaceTypes;
    }

    public abstract JvmType getType();

    public LightweightTypeReference getWrapperTypeIfPrimitive() {
        return this;
    }

    public LightweightTypeReference getPrimitiveIfWrapperType() {
        return this;
    }

    public Primitives.Primitive getPrimitiveKind() {
        return null;
    }

    public Primitives.Primitive getPrimitiveKindIfWrapperType() {
        return null;
    }

    public List<JvmType> getRawTypes() {
        return this.getServices().getRawTypeHelper().getAllRawTypes(this, this.getOwner().getContextResourceSet());
    }

    public LightweightTypeReference getRawTypeReference() {
        return this.getServices().getRawTypeHelper().getRawTypeReference(this, this.getOwner().getContextResourceSet());
    }

    public LightweightTypeReference getUpperBoundSubstitute() {
        return this;
    }

    public LightweightTypeReference getLowerBoundSubstitute() {
        return this;
    }

    public LightweightTypeReference getInvariantBoundSubstitute() {
        return this;
    }

    public boolean isRawType() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isAny() {
        return false;
    }

    public boolean isAnonymous() {
        return false;
    }

    public LightweightTypeReference getNamedType() {
        if (this.isAnonymous()) {
            return this.getSuperTypes().get(0);
        }
        return this;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean isValidHint() {
        return !this.isAny() && !this.isPrimitiveVoid();
    }

    public LightweightTypeReference tryConvertToListType() {
        return null;
    }

    public LightweightTypeReference getComponentType() {
        return null;
    }

    public List<LightweightTypeReference> getSuperTypes() {
        TypeParameterSubstitutor<?> substitutor = this.createSubstitutor();
        return this.getSuperTypes(substitutor);
    }

    public LightweightTypeReference getSuperType(Class<?> rawType) {
        return null;
    }

    public LightweightTypeReference getSuperType(JvmType rawType) {
        return null;
    }

    public List<LightweightTypeReference> getAllSuperTypes() {
        final ArrayList<LightweightTypeReference> result = Lists.newArrayList();
        final HashMultiset distances = HashMultiset.create(7);
        final HashMultiset counterPerType = HashMultiset.create(7);
        this.collectSuperTypes(new SuperTypeAcceptor(){
            int counter = 0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean accept(LightweightTypeReference superType, int distance) {
                JvmType type = superType.getType();
                counterPerType.add(type, this.counter++);
                if (distances.contains(type)) {
                    int currentCount = distances.count(type);
                    if (currentCount >= distance + 1) return false;
                    distances.setCount(type, distance + 1);
                    return true;
                } else {
                    result.add(superType);
                    distances.add(type, distance + 1);
                }
                return true;
            }
        });
        Collections.sort(result, new Comparator<LightweightTypeReference>(){

            @Override
            public int compare(LightweightTypeReference o1, LightweightTypeReference o2) {
                if (o1 == null || o2 == null) {
                    throw new IllegalArgumentException();
                }
                JvmType type1 = o1.getType();
                JvmType type2 = o2.getType();
                if (type1 == null) {
                    return 1;
                }
                if (type2 == null) {
                    return -1;
                }
                int distanceCompare = Ints.compare(distances.count(type1), distances.count(type2));
                if (distanceCompare != 0) {
                    return distanceCompare;
                }
                return Ints.compare(counterPerType.count(type1), counterPerType.count(type2));
            }
        });
        return result;
    }

    protected TypeParameterSubstitutor<?> createSubstitutor() {
        DeclaratorTypeArgumentCollector collector = new DeclaratorTypeArgumentCollector(){

            @Override
            public Boolean doVisitArrayTypeReference(ArrayTypeReference reference, LightweightTraversalData data) {
                return reference.getComponentType().accept(this, data);
            }
        };
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping = collector.getTypeParameterMapping(this);
        UnboundTypeParameterPreservingSubstitutor substitutor = new UnboundTypeParameterPreservingSubstitutor(mapping, this.getOwner());
        return substitutor;
    }

    protected abstract List<LightweightTypeReference> getSuperTypes(TypeParameterSubstitutor<?> var1);

    public void collectSuperTypes(SuperTypeAcceptor acceptor) {
        TypeParameterSubstitutor<?> substitutor = this.createSubstitutor();
        List<LightweightTypeReference> superTypes = this.getSuperTypes(substitutor);
        this.collectSuperTypes(1, superTypes, substitutor, acceptor, Sets.newHashSet(this.getType()));
    }

    protected void collectSuperTypes(int level, List<LightweightTypeReference> references, TypeParameterSubstitutor<?> substitutor, SuperTypeAcceptor acceptor, Set<JvmType> seenTypes) {
        for (LightweightTypeReference reference : references) {
            if (!acceptor.accept(reference, level) || !seenTypes.add(reference.getType())) continue;
            this.collectSuperTypes(level + 1, reference.getSuperTypes(substitutor), substitutor, acceptor, seenTypes);
        }
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isWrapper() {
        return false;
    }

    public boolean isPrimitiveVoid() {
        return false;
    }

    public boolean isAssignableFrom(LightweightTypeReference reference) {
        TypeConformanceComputationArgument argument = new TypeConformanceComputationArgument();
        return this.isAssignableFrom(reference, argument);
    }

    public boolean isAssignableFrom(LightweightTypeReference reference, TypeConformanceComputationArgument argument) {
        int result = this.internalIsAssignableFrom(reference, argument);
        return (result & 0x40000) == 0;
    }

    public int internalIsAssignableFrom(LightweightTypeReference reference, TypeConformanceComputationArgument argument) {
        TypeConformanceComputer conformanceCompouter = this.getOwner().getServices().getTypeConformanceComputer();
        int result = conformanceCompouter.isConformant(this, reference, argument);
        return result;
    }

    public boolean isAssignableFrom(Class<?> clazz) {
        if (this.isType(clazz)) {
            return true;
        }
        JvmType type = this.findType(clazz);
        if (type == null) {
            return false;
        }
        return this.isAssignableFrom(type);
    }

    public boolean isAssignableFrom(JvmType type) {
        if (type == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        ParameterizedTypeReference other = this.getOwner().newParameterizedTypeReference(type);
        boolean result = this.isAssignableFrom(other);
        return result;
    }

    public boolean isSubtypeOf(Class<?> clazz) {
        if (this.isType(clazz)) {
            return true;
        }
        JvmType type = this.findType(clazz);
        if (type == null) {
            return false;
        }
        return this.isSubtypeOf(type);
    }

    public boolean isSubtypeOf(JvmType type) {
        if (type == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        LightweightTypeReference other = this.owner.toPlainTypeReference(type);
        boolean result = other.isAssignableFrom(this);
        return result;
    }

    public LightweightTypeReference copyInto(ITypeReferenceOwner owner) {
        if (this.isOwnedBy(owner)) {
            return this;
        }
        return this.doCopyInto(owner);
    }

    protected abstract LightweightTypeReference doCopyInto(ITypeReferenceOwner var1);

    public final String toString() {
        return this.getSimpleName();
    }

    public abstract String getSimpleName();

    public String getHumanReadableName() {
        StringBuilder result = new StringBuilder();
        this.accept(this.getServices().getHumanReadableTypeNames(), result);
        return result.toString();
    }

    public abstract String getIdentifier();

    public abstract String getUniqueIdentifier();

    protected String getUniqueIdentifier(JvmType type) {
        String typeIdentifier = type.getIdentifier();
        if (type instanceof JvmTypeParameter) {
            JvmIdentifiableElement declarator = (JvmIdentifiableElement)((Object)((JvmTypeParameter)type).getDeclarator());
            typeIdentifier = declarator != null ? typeIdentifier + ":" + declarator.getQualifiedName() : typeIdentifier + ":";
        }
        return typeIdentifier;
    }

    public abstract String getJavaIdentifier();

    protected JvmType findType(Class<?> type) {
        return this.getServices().getTypeReferences().findDeclaredType(type, (Notifier)this.getOwner().getContextResourceSet());
    }

    protected LightweightTypeReference internalFindTopLevelType(Class<?> rawType) {
        try {
            ResourceSet resourceSet = this.getOwner().getContextResourceSet();
            Resource typeResource = resourceSet.getResource(URIHelperConstants.OBJECTS_URI.appendSegment(rawType.getName()), true);
            EList<EObject> resourceContents = typeResource.getContents();
            if (resourceContents.isEmpty()) {
                return null;
            }
            JvmType type = (JvmType)resourceContents.get(0);
            return this.getOwner().newParameterizedTypeReference(type);
        }
        catch (WrappedException e) {
            return null;
        }
    }

    protected JvmType findNonNullType(Class<?> type) {
        JvmType result = this.findType(type);
        if (result == null) {
            throw new IllegalStateException("Cannot find type " + type);
        }
        return result;
    }

    public abstract boolean isType(Class<?> var1);

    public void accept(TypeReferenceVisitor visitor) {
        visitor.doVisitTypeReference(this);
    }

    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        visitor.doVisitTypeReference(this, param);
    }

    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        return visitor.doVisitTypeReference(this);
    }

    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        return visitor.doVisitTypeReference(this, param);
    }

    public boolean isFunctionType() {
        return this.getFunctionTypeKind() != FunctionTypeKind.NONE;
    }

    public boolean isInterfaceType() {
        return false;
    }

    public FunctionTypeKind getFunctionTypeKind() {
        return FunctionTypeKind.NONE;
    }

    public FunctionTypeReference getAsFunctionTypeReference() {
        return null;
    }

    public FunctionTypeReference tryConvertToFunctionTypeReference(boolean rawType) {
        return null;
    }

    public ArrayTypeReference tryConvertToArray() {
        return null;
    }

    public boolean isWildcard() {
        return false;
    }

    public boolean isMultiType() {
        return false;
    }

    public boolean isSynonym() {
        return false;
    }

    public LightweightTypeReference toJavaType() {
        return this;
    }

    public List<LightweightTypeReference> getMultiTypeComponents() {
        return Collections.emptyList();
    }

    public static class SimpleNameFunction
    implements Function<LightweightTypeReference, String> {
        public static final SimpleNameFunction INSTANCE = new SimpleNameFunction();

        private SimpleNameFunction() {
        }

        @Override
        public String apply(LightweightTypeReference reference) {
            if (reference == null) {
                throw new NullPointerException("reference");
            }
            return reference.getSimpleName();
        }
    }

    public static class JavaIdentifierFunction
    implements Function<LightweightTypeReference, String> {
        public static final JavaIdentifierFunction INSTANCE = new JavaIdentifierFunction();

        private JavaIdentifierFunction() {
        }

        @Override
        public String apply(LightweightTypeReference reference) {
            if (reference == null) {
                throw new NullPointerException("reference");
            }
            return reference.getJavaIdentifier();
        }
    }

    public static class UniqueIdentifierFunction
    implements Function<LightweightTypeReference, String> {
        public static final UniqueIdentifierFunction INSTANCE = new UniqueIdentifierFunction();

        private UniqueIdentifierFunction() {
        }

        @Override
        public String apply(LightweightTypeReference reference) {
            if (reference == null) {
                throw new NullPointerException("reference");
            }
            return reference.getUniqueIdentifier();
        }
    }

    public static class IdentifierFunction
    implements Function<LightweightTypeReference, String> {
        public static final IdentifierFunction INSTANCE = new IdentifierFunction();

        private IdentifierFunction() {
        }

        @Override
        public String apply(LightweightTypeReference reference) {
            if (reference == null) {
                throw new NullPointerException("reference");
            }
            return reference.getIdentifier();
        }
    }
}

