/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

@Singleton
public class BoundTypeArgumentMerger {
    @Inject
    private TypeConformanceComputer conformanceComputer;

    public LightweightMergedBoundTypeArgument merge(Collection<LightweightBoundTypeArgument> allArguments, ITypeReferenceOwner owner) {
        if (allArguments.isEmpty()) {
            return null;
        }
        if (allArguments.size() == 1) {
            LightweightBoundTypeArgument argument = Iterables.getOnlyElement(allArguments);
            return this.getSingleArgumentAsMergedArgument(argument);
        }
        ArrayList<LightweightTypeReference> invariantTypes = Lists.newArrayListWithCapacity(0);
        ArrayList<VarianceInfo> invariantVariances = Lists.newArrayListWithCapacity(0);
        ArrayList<LightweightTypeReference> invariantTypesFromOut = Lists.newArrayListWithCapacity(0);
        ArrayList<VarianceInfo> invariantVariancesFromOut = Lists.newArrayListWithCapacity(0);
        ArrayList<LightweightTypeReference> outTypes = Lists.newArrayListWithCapacity(0);
        ArrayList<LightweightTypeReference> constraintOutTypes = Lists.newArrayListWithCapacity(0);
        ArrayList<VarianceInfo> outVariances = Lists.newArrayListWithCapacity(0);
        ArrayList<LightweightTypeReference> inTypes = Lists.newArrayListWithCapacity(0);
        ArrayList<VarianceInfo> inVariances = Lists.newArrayListWithCapacity(0);
        HashSet<Object> seenOrigin = Sets.newHashSet();
        for (LightweightBoundTypeArgument boundTypeArgument : allArguments) {
            Object origin = boundTypeArgument.getOrigin();
            switch (boundTypeArgument.getDeclaredVariance()) {
                case INVARIANT: {
                    this.processBoundTypeArgument(boundTypeArgument, invariantTypes, invariantVariances, origin, seenOrigin);
                    break;
                }
                case OUT: {
                    BoundTypeArgumentSource source = boundTypeArgument.getSource();
                    if (invariantTypes.isEmpty() && this.isTransitiveHintFromReslved(boundTypeArgument, origin, source)) {
                        invariantTypesFromOut.add(boundTypeArgument.getTypeReference());
                        if (seenOrigin.add(origin)) {
                            invariantVariancesFromOut.add(VarianceInfo.INVARIANT);
                        }
                    }
                    if (source == BoundTypeArgumentSource.CONSTRAINT) {
                        constraintOutTypes.add(boundTypeArgument.getTypeReference());
                    } else {
                        outTypes.add(boundTypeArgument.getTypeReference());
                    }
                    this.addVariance(boundTypeArgument, outVariances, origin, seenOrigin);
                    break;
                }
                case IN: {
                    this.processBoundTypeArgument(boundTypeArgument, inTypes, inVariances, origin, seenOrigin);
                }
            }
        }
        LightweightTypeReference type = null;
        VarianceInfo variance = null;
        if (outTypes.isEmpty() && inTypes.isEmpty()) {
            outTypes = constraintOutTypes;
        }
        if (!invariantTypes.isEmpty()) {
            LightweightTypeReference fromOut;
            type = (LightweightTypeReference)invariantTypes.get(0);
            variance = VarianceInfo.INVARIANT.mergeDeclaredWithActuals(invariantVariances);
            if (variance == null && invariantVariances.contains((Object)VarianceInfo.IN) && invariantTypes.size() > 1) {
                type = this.getCommonSuperTypes(invariantTypes, owner);
            } else if (!invariantTypesFromOut.isEmpty() && (fromOut = (LightweightTypeReference)invariantTypesFromOut.get(0)).isAssignableFrom(type)) {
                type = fromOut;
                variance = VarianceInfo.INVARIANT;
            }
            if (!outVariances.isEmpty()) {
                VarianceInfo outVariance = VarianceInfo.OUT.mergeDeclaredWithActuals(outVariances);
                variance = VarianceInfo.OUT.mergeInvariance(variance, outVariance);
            } else if (!inVariances.isEmpty()) {
                VarianceInfo inVariance = VarianceInfo.IN.mergeDeclaredWithActuals(inVariances);
                variance = VarianceInfo.IN.mergeInvariance(variance, inVariance);
            }
        } else if (!outTypes.isEmpty()) {
            type = this.getCommonSuperTypes(outTypes, owner);
            variance = VarianceInfo.OUT.mergeDeclaredWithActuals(outVariances);
            if (!inVariances.isEmpty()) {
                LightweightTypeReference inType = this.getMostSpecialType(inTypes);
                boolean conformant = type.isAssignableFrom(inType, new TypeConformanceComputationArgument(false, true, false, false, true, false));
                if (conformant) {
                    VarianceInfo inVariance = VarianceInfo.IN.mergeDeclaredWithActuals(inVariances);
                    variance = VarianceInfo.IN.mergeWithOut(variance, inVariance, conformant);
                } else {
                    boolean reverseConformant = inType.isAssignableFrom(type, new TypeConformanceComputationArgument(false, false, false, false, true, false));
                    if (reverseConformant && variance == VarianceInfo.INVARIANT && VarianceInfo.IN.mergeDeclaredWithActuals(inVariances) == VarianceInfo.INVARIANT) {
                        if (VarianceInfo.IN.mergeDeclaredWithActuals(outVariances) != null) {
                            type = inType;
                            variance = VarianceInfo.OUT;
                        }
                    } else {
                        VarianceInfo inVariance = VarianceInfo.IN.mergeDeclaredWithActuals(inVariances);
                        variance = VarianceInfo.IN.mergeWithOut(variance, inVariance, conformant);
                    }
                }
            }
        } else if (!inTypes.isEmpty()) {
            type = this.getMostSpecialType(inTypes);
            variance = VarianceInfo.IN.mergeDeclaredWithActuals(inVariances);
        }
        return new LightweightMergedBoundTypeArgument(type, variance);
    }

    private LightweightTypeReference getCommonSuperTypes(List<LightweightTypeReference> types, ITypeReferenceOwner owner) {
        TypeConformanceComputer conformanceComputer = owner.getServices().getTypeConformanceComputer();
        LightweightTypeReference type = conformanceComputer.getCommonSuperType(types, owner);
        if (type == null) {
            ArrayList<LightweightTypeReference> filteredOutTypes = Lists.newArrayListWithCapacity(types.size());
            for (LightweightTypeReference outType : types) {
                if (outType.isPrimitiveVoid()) continue;
                filteredOutTypes.add(outType);
            }
            if (!filteredOutTypes.isEmpty() && filteredOutTypes.size() != types.size()) {
                type = conformanceComputer.getCommonSuperType(filteredOutTypes, owner);
            }
            if (type == null) {
                type = filteredOutTypes.isEmpty() ? types.get(0) : (LightweightTypeReference)filteredOutTypes.get(0);
            }
        }
        return type;
    }

    private boolean isTransitiveHintFromReslved(LightweightBoundTypeArgument boundTypeArgument, Object origin, BoundTypeArgumentSource source) {
        return origin instanceof LightweightBoundTypeArgument && ((LightweightBoundTypeArgument)origin).getSource() == BoundTypeArgumentSource.RESOLVED && source == BoundTypeArgumentSource.INFERRED && boundTypeArgument.getActualVariance() == VarianceInfo.OUT;
    }

    private void processBoundTypeArgument(LightweightBoundTypeArgument boundTypeArgument, List<LightweightTypeReference> types, List<VarianceInfo> variances, Object origin, Set<Object> seenOrigin) {
        types.add(boundTypeArgument.getTypeReference());
        this.addVariance(boundTypeArgument, variances, origin, seenOrigin);
    }

    private void addVariance(LightweightBoundTypeArgument boundTypeArgument, List<VarianceInfo> result, Object origin, Set<Object> seenOrigin) {
        if (seenOrigin.add(origin) || origin == null || boundTypeArgument.isValidVariancePair()) {
            result.add(boundTypeArgument.getActualVariance());
        }
    }

    protected LightweightMergedBoundTypeArgument getSingleArgumentAsMergedArgument(LightweightBoundTypeArgument argument) {
        LightweightTypeReference typeReference = argument.getTypeReference();
        VarianceInfo varianceInfo = argument.getDeclaredVariance().mergeDeclaredWithActual(argument.getActualVariance());
        if (argument.getDeclaredVariance() == VarianceInfo.IN && varianceInfo == VarianceInfo.INVARIANT && typeReference.getKind() == 8) {
            typeReference = typeReference.getInvariantBoundSubstitute();
        }
        return new LightweightMergedBoundTypeArgument(typeReference, varianceInfo);
    }

    public boolean isPossibleMergeResult(List<LightweightBoundTypeArgument> allArguments, LightweightTypeReference candidate) {
        LightweightTypeReference singleReference;
        LightweightBoundTypeArgument singleArgument;
        if (allArguments.isEmpty()) {
            return false;
        }
        if (allArguments.size() == 1 && !candidate.isWildcard() && VarianceInfo.OUT.equals((Object)(singleArgument = allArguments.get(0)).getActualVariance()) && singleArgument.getActualVariance().equals((Object)singleArgument.getDeclaredVariance()) && (singleReference = singleArgument.getTypeReference()).isResolved()) {
            return candidate.isAssignableFrom(singleReference, new TypeConformanceComputationArgument());
        }
        LightweightMergedBoundTypeArgument merged = this.merge(allArguments, candidate.getOwner());
        if (merged == null) {
            return false;
        }
        VarianceInfo variance = merged.getVariance();
        LightweightTypeReference type = merged.getTypeReference();
        if (variance == null || type == null) {
            return false;
        }
        switch (variance) {
            case INVARIANT: {
                int result = candidate.internalIsAssignableFrom(type, new TypeConformanceComputationArgument(false, true, true, true, false, false));
                return (result & 0x200) != 0 && (result & 0x8000) == 0;
            }
            case OUT: {
                return type.isAssignableFrom(candidate, new TypeConformanceComputationArgument());
            }
            case IN: {
                return candidate.isAssignableFrom(type, new TypeConformanceComputationArgument());
            }
        }
        throw new IllegalStateException("Unknown variance info: " + (Object)((Object)variance));
    }

    protected LightweightTypeReference getMostSpecialType(List<LightweightTypeReference> candidates) {
        LightweightTypeReference type = this.conformanceComputer.getMostSpecialType(candidates);
        if (type == null) {
            type = candidates.get(0);
        }
        return type;
    }
}

