/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.base.Splitter;
import com.google.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.validation.DiagnosticConverterImpl;

public class XtextDiagnosticConverter
extends DiagnosticConverterImpl {
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private IEObjectDocumentationProvider documentationProvider;
    private final Pattern afterLastDot = Pattern.compile(".*\\W(\\w+)$");
    private final Pattern suppressWarnings = Pattern.compile("SuppressWarnings\\[([^]]*)\\]", 2);
    private final Splitter splitter = Splitter.on(',').trimResults().omitEmptyStrings();
    private static final String ALL = "all";

    @Override
    protected DiagnosticConverterImpl.IssueLocation getLocationData(EObject obj, EStructuralFeature structuralFeature, int index) {
        if (NodeModelUtils.getNode(obj) == null) {
            ITextRegion location = this.locationInFileProvider.getSignificantTextRegion(obj);
            if (location != null) {
                ICompositeNode rootNode = NodeModelUtils.getNode(EcoreUtil.getRootContainer(obj));
                if (rootNode != null) {
                    ILeafNode leafNode = NodeModelUtils.findLeafNodeAtOffset(rootNode, location.getOffset());
                    return this.getLocationForNode(leafNode);
                }
            } else {
                return super.getLocationData(obj.eContainer(), null, index);
            }
        }
        return super.getLocationData(obj, structuralFeature, index);
    }

    @Override
    protected Severity getSeverity(Diagnostic diagnostic) {
        EObject causer;
        Severity result = super.getSeverity(diagnostic);
        String issueCode = this.getIssueCode(diagnostic);
        if (result == Severity.WARNING && issueCode != null && (causer = this.getCauser(diagnostic)) != null) {
            AbstractRule rule;
            if (this.isMarkedAsIgnored(causer, issueCode)) {
                return null;
            }
            if (!(causer instanceof AbstractRule) && (rule = GrammarUtil.containingRule(causer)) != null && this.isMarkedAsIgnored(rule, issueCode)) {
                return null;
            }
            Grammar grammar = GrammarUtil.getGrammar(causer);
            if (grammar != null && this.isMarkedAsIgnored(grammar, issueCode)) {
                return null;
            }
        }
        return result;
    }

    protected boolean isMarkedAsIgnored(EObject object, String code) {
        String documentation = this.documentationProvider.getDocumentation(object);
        if (documentation != null) {
            Matcher suppressWarningsMatcher = this.suppressWarnings.matcher(documentation);
            while (suppressWarningsMatcher.find()) {
                String suffix = null;
                String suppressed = suppressWarningsMatcher.group(1);
                for (String next : this.splitter.split(suppressed)) {
                    if (ALL.equalsIgnoreCase(next)) {
                        return true;
                    }
                    if (suffix == null) {
                        Matcher matcher = this.afterLastDot.matcher(code);
                        suffix = matcher.matches() ? matcher.group(1) : "";
                    }
                    if (!suffix.equalsIgnoreCase(next)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

