/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen.csharp;

import com.db.plexus.interop.dsl.Application;
import com.db.plexus.interop.dsl.ConsumedMethod;
import com.db.plexus.interop.dsl.ConsumedService;
import com.db.plexus.interop.dsl.ProvidedMethod;
import com.db.plexus.interop.dsl.ProvidedService;
import com.db.plexus.interop.dsl.gen.GenUtils;
import com.db.plexus.interop.dsl.gen.PlexusGenConfig;
import com.db.plexus.interop.dsl.protobuf.Constant;
import com.db.plexus.interop.dsl.protobuf.Message;
import com.db.plexus.interop.dsl.protobuf.Method;
import com.db.plexus.interop.dsl.protobuf.Option;
import com.db.plexus.interop.dsl.protobuf.Proto;
import com.db.plexus.interop.dsl.protobuf.Service;
import com.db.plexus.interop.dsl.protobuf.StringConstant;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CsharpCodeGenerator {
    private static final QualifiedName CSHARP_NAMESPACE_OPTION_DESCRIPTOR_NAME = QualifiedName.create("", "google", "protobuf", "FileOptions", "csharp_namespace");
    @Inject
    private GenUtils utils;
    private IQualifiedNameProvider qualifiedNameProvider;
    private PlexusGenConfig config;
    private URI baseDirUri;
    private String accessModifier;

    public CsharpCodeGenerator(PlexusGenConfig config, IQualifiedNameProvider qualifiedNameProvider, URI baseDirUri, String accessModifier) {
        this.accessModifier = accessModifier;
        this.config = config;
        this.qualifiedNameProvider = qualifiedNameProvider;
        this.baseDirUri = baseDirUri;
    }

    public String gen(XtextResource resource) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// <auto-generated>");
        _builder.newLine();
        _builder.append("// \tGenerated by the Plexus Interop compiler.  DO NOT EDIT!");
        _builder.newLine();
        _builder.append("// \tsource: ");
        String _fileString = resource.getURI().deresolve(this.baseDirUri).toFileString();
        _builder.append(_fileString);
        _builder.newLineIfNotEmpty();
        _builder.append("// </auto-generated>");
        _builder.newLine();
        _builder.append("#pragma warning disable 1591, 0612, 3021");
        _builder.newLine();
        _builder.append("#region Designer generated code");
        _builder.newLine();
        _builder.append("namespace ");
        String _csharpNamespace = this.getCsharpNamespace(resource);
        _builder.append(_csharpNamespace);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("using System;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("using global::Plexus;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("using global::Plexus.Channels;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("using global::Plexus.Interop;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("using global::System.Threading.Tasks;");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.newLine();
        List<Service> _services = GenUtils.getServices((Resource)resource);
        boolean _hasElements = false;
        for (Service service : _services) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate("\n", "\t");
            }
            _builder.append("\t");
            String _gen = this.gen(service);
            _builder.append(_gen, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t\t\t\t");
        _builder.newLine();
        List<Application> _applications = GenUtils.getApplications((Resource)resource);
        boolean _hasElements_1 = false;
        for (Application application : _applications) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate("\n", "\t");
            }
            _builder.append("\t");
            String _gen_1 = this.gen(application);
            _builder.append(_gen_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.append("#endregion Designer generated code");
        _builder.newLine();
        return _builder.toString();
    }

    public String gen(Application application) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(this.accessModifier);
        _builder.append(" partial interface I");
        String _clientName = this.getClientName(application);
        _builder.append(_clientName);
        _builder.append(": IClient {");
        _builder.newLineIfNotEmpty();
        List<ConsumedService> _consumedServices = GenUtils.getConsumedServices(application);
        boolean _hasElements = false;
        for (ConsumedService consumedService : _consumedServices) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate("\n", "\t");
            }
            _builder.append("\t");
            String _clientName_1 = this.getClientName(application);
            _builder.append(_clientName_1, "\t");
            _builder.append(".I");
            String _aliasOrName = this.getAliasOrName(consumedService);
            _builder.append(_aliasOrName, "\t");
            _builder.append("Proxy ");
            String _aliasOrName_1 = this.getAliasOrName(consumedService);
            _builder.append(_aliasOrName_1, "\t");
            _builder.append(" { get; }");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append(this.accessModifier);
        _builder.append(" sealed partial class ");
        String _clientName_2 = this.getClientName(application);
        _builder.append(_clientName_2);
        _builder.append(": ClientBase, I");
        String _clientName_3 = this.getClientName(application);
        _builder.append(_clientName_3);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public const string Id = \"");
        String _fullName = this.utils.getFullName(application);
        _builder.append(_fullName, "\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        int _length = ((Object[])Conversions.unwrapArray(GenUtils.getProvidedServices(application), Object.class)).length;
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("private static ClientOptions CreateClientOptions(");
            String _clientName_4 = this.getClientName(application);
            _builder.append(_clientName_4, "\t");
            _builder.append(".ServiceBinder serviceBinder, Func<ClientOptionsBuilder, ClientOptionsBuilder> setup = null) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("ClientOptionsBuilder builder = new ClientOptionsBuilder().WithApplicationId(Id).WithDefaultConfiguration();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("serviceBinder.Bind(builder);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (setup != null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("builder = setup(builder);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return builder.Build();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public ");
            String _clientName_5 = this.getClientName(application);
            _builder.append(_clientName_5, "\t");
            _builder.append("(");
            _builder.newLineIfNotEmpty();
            List<ProvidedService> _providedServices = GenUtils.getProvidedServices(application);
            for (ProvidedService providedService : _providedServices) {
                _builder.append("\t");
                _builder.append("\t");
                String _clientName_6 = this.getClientName(application);
                _builder.append(_clientName_6, "\t\t");
                _builder.append(".I");
                String string = this.getAliasOrName(providedService);
                _builder.append(string, "\t\t");
                _builder.append("Impl ");
                String string2 = StringExtensions.toFirstLower(this.getAliasOrName(providedService));
                _builder.append(string2, "\t\t");
                _builder.append(",");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("Func<ClientOptionsBuilder, ClientOptionsBuilder> setup = null");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(")");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(":this(new ");
            String _clientName_7 = this.getClientName(application);
            _builder.append(_clientName_7, "\t");
            _builder.append(".ServiceBinder(");
            _builder.newLineIfNotEmpty();
            List<ProvidedService> _providedServices_1 = GenUtils.getProvidedServices(application);
            boolean _hasElements_1 = false;
            for (ProvidedService providedService : _providedServices_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate(",", "\t\t");
                }
                _builder.append("\t");
                _builder.append("\t");
                String string = StringExtensions.toFirstLower(this.getAliasOrName(providedService));
                _builder.append(string, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("), setup) { }");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public ");
            String _clientName_8 = this.getClientName(application);
            _builder.append(_clientName_8, "\t");
            _builder.append("(");
            String _clientName_9 = this.getClientName(application);
            _builder.append(_clientName_9, "\t");
            _builder.append(".ServiceBinder serviceBinder, Func<ClientOptionsBuilder, ClientOptionsBuilder> setup = null): base(CreateClientOptions(serviceBinder, setup)) ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            List<ConsumedService> _consumedServices_1 = GenUtils.getConsumedServices(application);
            for (ConsumedService consumedService : _consumedServices_1) {
                _builder.append("\t");
                _builder.append("\t");
                String _aliasOrName_3 = this.getAliasOrName(consumedService);
                _builder.append(_aliasOrName_3, "\t\t");
                _builder.append(" = new ");
                String _clientName_10 = this.getClientName(application);
                _builder.append(_clientName_10, "\t\t");
                _builder.append(".");
                String _aliasOrName_4 = this.getAliasOrName(consumedService);
                _builder.append(_aliasOrName_4, "\t\t");
                _builder.append("Proxy(this.CallInvoker);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public sealed partial class ServiceBinder {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("public ServiceBinder(");
            _builder.newLine();
            List<ProvidedService> _providedServices_2 = GenUtils.getProvidedServices(application);
            boolean bl2 = false;
            for (ProvidedService providedService_2 : _providedServices_2) {
                boolean bl3;
                if (!bl3) {
                    bl3 = true;
                } else {
                    _builder.appendImmediate(",", "\t\t\t");
                }
                _builder.append("\t");
                _builder.append("\t\t");
                String _clientName_11 = this.getClientName(application);
                _builder.append(_clientName_11, "\t\t\t");
                _builder.append(".I");
                String _aliasOrName_5 = this.getAliasOrName(providedService_2);
                _builder.append(_aliasOrName_5, "\t\t\t");
                _builder.append("Impl ");
                String _firstLower_2 = StringExtensions.toFirstLower(this.getAliasOrName(providedService_2));
                _builder.append(_firstLower_2, "\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append(") {");
            _builder.newLine();
            List<ProvidedService> _providedServices_3 = GenUtils.getProvidedServices(application);
            for (ProvidedService providedService : _providedServices_3) {
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("_");
                String _firstLower_3 = StringExtensions.toFirstLower(this.getAliasOrName(providedService));
                _builder.append(_firstLower_3, "\t\t\t");
                _builder.append("Binder = new ");
                String _clientName_12 = this.getClientName(application);
                _builder.append(_clientName_12, "\t\t\t");
                _builder.append(".");
                String _aliasOrName_6 = this.getAliasOrName(providedService);
                _builder.append(_aliasOrName_6, "\t\t\t");
                _builder.append("Binder(");
                String _firstLower_4 = StringExtensions.toFirstLower(this.getAliasOrName(providedService));
                _builder.append(_firstLower_4, "\t\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            List<ProvidedService> _providedServices_4 = GenUtils.getProvidedServices(application);
            for (ProvidedService providedService : _providedServices_4) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("private ");
                String _aliasOrName_7 = this.getAliasOrName(providedService);
                _builder.append(_aliasOrName_7, "\t\t");
                _builder.append("Binder _");
                String _firstLower_5 = StringExtensions.toFirstLower(this.getAliasOrName(providedService));
                _builder.append(_firstLower_5, "\t\t");
                _builder.append("Binder;");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("public ClientOptionsBuilder Bind(ClientOptionsBuilder builder) {");
            _builder.newLine();
            List<ProvidedService> _providedServices_5 = GenUtils.getProvidedServices(application);
            for (ProvidedService providedService : _providedServices_5) {
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("builder = _");
                String _firstLower_6 = StringExtensions.toFirstLower(this.getAliasOrName(providedService));
                _builder.append(_firstLower_6, "\t\t\t");
                _builder.append("Binder.Bind(builder);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("return builder;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            List<ProvidedService> _providedServices_6 = GenUtils.getProvidedServices(application);
            boolean bl4 = false;
            for (ProvidedService providedService_6 : _providedServices_6) {
                boolean _greaterThan_2;
                boolean _tripleEquals;
                boolean _tripleNotEquals;
                boolean _greaterThan_1;
                boolean bl5;
                if (!bl5) {
                    bl5 = true;
                } else {
                    _builder.appendImmediate("\n", "\t");
                }
                _builder.append("\t");
                _builder.append("public partial interface I");
                String _aliasOrName_8 = this.getAliasOrName(providedService_6);
                _builder.append(_aliasOrName_8, "\t");
                _builder.append("Impl");
                int _length_1 = ((Object[])Conversions.unwrapArray(GenUtils.getMethods(providedService_6), Object.class)).length;
                boolean bl6 = _greaterThan_1 = _length_1 > 0;
                if (_greaterThan_1) {
                    _builder.append(":");
                }
                _builder.newLineIfNotEmpty();
                List<ProvidedMethod> _methods = GenUtils.getMethods(providedService_6);
                boolean _hasElements_4 = false;
                for (ProvidedMethod providedMethod : _methods) {
                    if (!_hasElements_4) {
                        _hasElements_4 = true;
                    } else {
                        _builder.appendImmediate(",", "\t\t");
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    String _csharpFullName = this.getCsharpFullName(providedService_6.getService());
                    _builder.append(_csharpFullName, "\t\t");
                    _builder.append(".I");
                    String _firstUpper = StringExtensions.toFirstUpper(providedMethod.getMethod().getName());
                    _builder.append(_firstUpper, "\t\t");
                    _builder.append("Impl");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("{ }");
                _builder.newLine();
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("private sealed partial class ");
                String _aliasOrName_9 = this.getAliasOrName(providedService_6);
                _builder.append(_aliasOrName_9, "\t");
                _builder.append("Binder {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                String _alias = providedService_6.getAlias();
                boolean bl7 = _tripleNotEquals = _alias != null;
                if (_tripleNotEquals) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("public const string Alias = \"");
                    String _alias_1 = providedService_6.getAlias();
                    _builder.append(_alias_1, "\t\t");
                    _builder.append("\";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("private readonly I");
                String _aliasOrName_10 = this.getAliasOrName(providedService_6);
                _builder.append(_aliasOrName_10, "\t\t");
                _builder.append("Impl _impl;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public ");
                String _aliasOrName_11 = this.getAliasOrName(providedService_6);
                _builder.append(_aliasOrName_11, "\t\t");
                _builder.append("Binder(I");
                String _aliasOrName_12 = this.getAliasOrName(providedService_6);
                _builder.append(_aliasOrName_12, "\t\t");
                _builder.append("Impl impl) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("_impl = impl;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public ClientOptionsBuilder Bind(ClientOptionsBuilder builder) {");
                _builder.newLine();
                String _alias_2 = providedService_6.getAlias();
                boolean bl8 = _tripleEquals = _alias_2 == null;
                if (_tripleEquals) {
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("return builder.WithProvidedService(");
                    String _csharpFullName_1 = this.getCsharpFullName(providedService_6.getService());
                    _builder.append(_csharpFullName_1, "\t\t\t");
                    _builder.append(".Id, Bind);");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("return builder.WithProvidedService(");
                    String _csharpFullName_2 = this.getCsharpFullName(providedService_6.getService());
                    _builder.append(_csharpFullName_2, "\t\t\t");
                    _builder.append(".Id, Alias, Bind);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("private ProvidedServiceDefinition.Builder Bind(ProvidedServiceDefinition.Builder builder) {");
                _builder.newLine();
                List<ProvidedMethod> _methods_1 = GenUtils.getMethods(providedService_6);
                for (ProvidedMethod providedMethod_1 : _methods_1) {
                    boolean _isPointToPoint = GenUtils.isPointToPoint(providedMethod_1.getMethod());
                    if (_isPointToPoint) {
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("builder = builder.WithUnaryMethod");
                        String _genericArgs = this.getGenericArgs(providedMethod_1.getMethod());
                        _builder.append(_genericArgs, "\t\t\t");
                        _builder.append("(");
                        String string = this.getCsharpFullName(GenUtils.getService(providedMethod_1.getMethod()));
                        _builder.append(string, "\t\t\t");
                        _builder.append(".");
                        String _firstUpper_1 = StringExtensions.toFirstUpper(providedMethod_1.getMethod().getName());
                        _builder.append(_firstUpper_1, "\t\t\t");
                        _builder.append("MethodId, _impl.");
                        String _firstUpper_2 = StringExtensions.toFirstUpper(providedMethod_1.getMethod().getName());
                        _builder.append(_firstUpper_2, "\t\t\t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    boolean _isServerStreaming = GenUtils.isServerStreaming(providedMethod_1.getMethod());
                    if (_isServerStreaming) {
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("builder = builder.WithServerStreamingMethod");
                        String string = this.getGenericArgs(providedMethod_1.getMethod());
                        _builder.append(string, "\t\t\t");
                        _builder.append("(");
                        String _csharpFullName_4 = this.getCsharpFullName(GenUtils.getService(providedMethod_1.getMethod()));
                        _builder.append(_csharpFullName_4, "\t\t\t");
                        _builder.append(".");
                        String _firstUpper_3 = StringExtensions.toFirstUpper(providedMethod_1.getMethod().getName());
                        _builder.append(_firstUpper_3, "\t\t\t");
                        _builder.append("MethodId, _impl.");
                        String _firstUpper_4 = StringExtensions.toFirstUpper(providedMethod_1.getMethod().getName());
                        _builder.append(_firstUpper_4, "\t\t\t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    boolean bl9 = GenUtils.isClientStreaming(providedMethod_1.getMethod());
                    if (bl9) {
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("builder = builder.WithClientStreamingMethod");
                        String _genericArgs_2 = this.getGenericArgs(providedMethod_1.getMethod());
                        _builder.append(_genericArgs_2, "\t\t\t");
                        _builder.append("(");
                        String _csharpFullName_5 = this.getCsharpFullName(GenUtils.getService(providedMethod_1.getMethod()));
                        _builder.append(_csharpFullName_5, "\t\t\t");
                        _builder.append(".");
                        String _firstUpper_5 = StringExtensions.toFirstUpper(providedMethod_1.getMethod().getName());
                        _builder.append(_firstUpper_5, "\t\t\t");
                        _builder.append("MethodId, _impl.");
                        String _firstUpper_6 = StringExtensions.toFirstUpper(providedMethod_1.getMethod().getName());
                        _builder.append(_firstUpper_6, "\t\t\t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    boolean _isBidiStreaming = GenUtils.isBidiStreaming(providedMethod_1.getMethod());
                    if (!_isBidiStreaming) continue;
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("builder = builder.WithDuplexStreamingMethod");
                    String _genericArgs_3 = this.getGenericArgs(providedMethod_1.getMethod());
                    _builder.append(_genericArgs_3, "\t\t\t");
                    _builder.append("(");
                    String _csharpFullName_6 = this.getCsharpFullName(GenUtils.getService(providedMethod_1.getMethod()));
                    _builder.append(_csharpFullName_6, "\t\t\t");
                    _builder.append(".");
                    String _firstUpper_7 = StringExtensions.toFirstUpper(providedMethod_1.getMethod().getName());
                    _builder.append(_firstUpper_7, "\t\t\t");
                    _builder.append("MethodId, _impl.");
                    String _firstUpper_8 = StringExtensions.toFirstUpper(providedMethod_1.getMethod().getName());
                    _builder.append(_firstUpper_8, "\t\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("return builder; \t\t\t\t\t\t\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("public sealed partial class ");
                String _aliasOrName_13 = this.getAliasOrName(providedService_6);
                _builder.append(_aliasOrName_13, "\t");
                _builder.append("Impl: I");
                String _aliasOrName_14 = this.getAliasOrName(providedService_6);
                _builder.append(_aliasOrName_14, "\t");
                _builder.append("Impl");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                List<ProvidedMethod> _methods_2 = GenUtils.getMethods(providedService_6);
                for (ProvidedMethod providedMethod_2 : _methods_2) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("private readonly ");
                    String string = this.genHandlerSignature(providedMethod_2.getMethod());
                    _builder.append(string, "\t\t");
                    _builder.append(" _");
                    String _firstLower_7 = StringExtensions.toFirstLower(providedMethod_2.getMethod().getName());
                    _builder.append(_firstLower_7, "\t\t");
                    _builder.append("Handler;");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public ");
                String _aliasOrName_15 = this.getAliasOrName(providedService_6);
                _builder.append(_aliasOrName_15, "\t\t");
                _builder.append("Impl(");
                _builder.newLineIfNotEmpty();
                List<ProvidedMethod> _methods_3 = GenUtils.getMethods(providedService_6);
                boolean _hasElements_5 = false;
                for (ProvidedMethod providedMethod_3 : _methods_3) {
                    if (!_hasElements_5) {
                        _hasElements_5 = true;
                    } else {
                        _builder.appendImmediate(",", "\t\t\t");
                    }
                    _builder.append("\t");
                    _builder.append("\t\t");
                    String _genHandlerSignature_1 = this.genHandlerSignature(providedMethod_3.getMethod());
                    _builder.append(_genHandlerSignature_1, "\t\t\t");
                    _builder.append(" ");
                    String _firstLower_8 = StringExtensions.toFirstLower(providedMethod_3.getMethod().getName());
                    _builder.append(_firstLower_8, "\t\t\t");
                    _builder.append("Handler");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(") {");
                _builder.newLine();
                List<ProvidedMethod> _methods_4 = GenUtils.getMethods(providedService_6);
                for (ProvidedMethod providedMethod : _methods_4) {
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("_");
                    String _firstLower_9 = StringExtensions.toFirstLower(providedMethod.getMethod().getName());
                    _builder.append(_firstLower_9, "\t\t\t");
                    _builder.append("Handler = ");
                    String _firstLower_10 = StringExtensions.toFirstLower(providedMethod.getMethod().getName());
                    _builder.append(_firstLower_10, "\t\t\t");
                    _builder.append("Handler;");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                List<ProvidedMethod> _methods_5 = GenUtils.getMethods(providedService_6);
                boolean _hasElements_6 = false;
                for (ProvidedMethod providedMethod_5 : _methods_5) {
                    if (!_hasElements_6) {
                        _hasElements_6 = true;
                    } else {
                        _builder.appendImmediate("\n", "\t\t");
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("public ");
                    String _genImplSignature = this.genImplSignature(providedMethod_5.getMethod());
                    _builder.append(_genImplSignature, "\t\t");
                    _builder.append(" {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("return _");
                    String _firstLower_11 = StringExtensions.toFirstLower(providedMethod_5.getMethod().getName());
                    _builder.append(_firstLower_11, "\t\t\t");
                    _builder.append("Handler");
                    String _genCallCode = this.genCallCode(providedMethod_5.getMethod());
                    _builder.append(_genCallCode, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("}\t\t\t\t\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("public sealed partial class ");
                String _aliasOrName_16 = this.getAliasOrName(providedService_6);
                _builder.append(_aliasOrName_16, "\t");
                _builder.append("Impl<T>: I");
                String _aliasOrName_17 = this.getAliasOrName(providedService_6);
                _builder.append(_aliasOrName_17, "\t");
                _builder.append("Impl");
                _builder.newLineIfNotEmpty();
                int n = ((Object[])Conversions.unwrapArray(GenUtils.getMethods(providedService_6), Object.class)).length;
                boolean bl10 = _greaterThan_2 = n > 0;
                if (_greaterThan_2) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("where T:");
                    _builder.newLine();
                    List<ProvidedMethod> _methods_6 = GenUtils.getMethods(providedService_6);
                    boolean _hasElements_7 = false;
                    for (ProvidedMethod providedMethod_6 : _methods_6) {
                        if (!_hasElements_7) {
                            _hasElements_7 = true;
                        } else {
                            _builder.appendImmediate(",", "\t\t");
                        }
                        _builder.append("\t");
                        _builder.append("\t");
                        String _csharpFullName_7 = this.getCsharpFullName(providedService_6.getService());
                        _builder.append(_csharpFullName_7, "\t\t");
                        _builder.append(".I");
                        String _firstUpper_9 = StringExtensions.toFirstUpper(providedMethod_6.getMethod().getName());
                        _builder.append(_firstUpper_9, "\t\t");
                        _builder.append("Impl");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("private readonly T _impl;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public ");
                String string = this.getAliasOrName(providedService_6);
                _builder.append(string, "\t\t");
                _builder.append("Impl(T impl) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("_impl = impl;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                List<ProvidedMethod> _methods_7 = GenUtils.getMethods(providedService_6);
                boolean _hasElements_8 = false;
                for (ProvidedMethod providedMethod_7 : _methods_7) {
                    if (!_hasElements_8) {
                        _hasElements_8 = true;
                    } else {
                        _builder.appendImmediate("\n", "\t\t");
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("public ");
                    String _genImplSignature_1 = this.genImplSignature(providedMethod_7.getMethod());
                    _builder.append(_genImplSignature_1, "\t\t");
                    _builder.append(" {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("return ");
                    String _genImplCallCode = this.genImplCallCode(providedMethod_7.getMethod(), "_impl");
                    _builder.append(_genImplCallCode, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
        } else {
            _builder.append("\t");
            _builder.append("private static ClientOptions CreateClientOptions(Func<ClientOptionsBuilder, ClientOptionsBuilder> setup = null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("ClientOptionsBuilder builder = new ClientOptionsBuilder().WithApplicationId(Id).WithDefaultConfiguration();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (setup != null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("builder = setup(builder);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}\t\t\t\t\t\t\t\t\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return builder.Build();\t\t\t\t\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public ");
            String _clientName_13 = this.getClientName(application);
            _builder.append(_clientName_13, "\t");
            _builder.append("(Func<ClientOptionsBuilder, ClientOptionsBuilder> setup = null): base(CreateClientOptions(setup)) ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{ ");
            _builder.newLine();
            List<ConsumedService> _consumedServices_2 = GenUtils.getConsumedServices(application);
            for (ConsumedService consumedService_2 : _consumedServices_2) {
                _builder.append("\t");
                _builder.append("\t");
                String _aliasOrName_19 = this.getAliasOrName(consumedService_2);
                _builder.append(_aliasOrName_19, "\t\t");
                _builder.append(" = new ");
                String _clientName_14 = this.getClientName(application);
                _builder.append(_clientName_14, "\t\t");
                _builder.append(".");
                String string = this.getAliasOrName(consumedService_2);
                _builder.append(string, "\t\t");
                _builder.append("Proxy(this.CallInvoker);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        List<ConsumedService> _consumedServices_3 = GenUtils.getConsumedServices(application);
        boolean _hasElements_9 = false;
        for (ConsumedService consumedService_3 : _consumedServices_3) {
            boolean bl11;
            boolean _greaterThan_3;
            if (!_hasElements_9) {
                _hasElements_9 = true;
            } else {
                _builder.appendImmediate("\n", "\t");
            }
            _builder.append("\t");
            _builder.append("public partial interface I");
            String _aliasOrName_21 = this.getAliasOrName(consumedService_3);
            _builder.append(_aliasOrName_21, "\t");
            _builder.append("Proxy");
            int _length_3 = ((Object[])Conversions.unwrapArray(GenUtils.getMethods(consumedService_3), Object.class)).length;
            boolean bl12 = _greaterThan_3 = _length_3 > 0;
            if (_greaterThan_3) {
                _builder.append(":");
            }
            _builder.newLineIfNotEmpty();
            List<ConsumedMethod> _methods_8 = GenUtils.getMethods(consumedService_3);
            boolean _hasElements_10 = false;
            for (ConsumedMethod consumedMethod : _methods_8) {
                if (!_hasElements_10) {
                    _hasElements_10 = true;
                } else {
                    _builder.appendImmediate(",", "\t\t");
                }
                _builder.append("\t");
                _builder.append("\t");
                String string = this.getCsharpFullName(consumedService_3.getService());
                _builder.append(string, "\t\t");
                _builder.append(".I");
                String _firstUpper_10 = StringExtensions.toFirstUpper(consumedMethod.getMethod().getName());
                _builder.append(_firstUpper_10, "\t\t");
                _builder.append("Proxy");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("{ }");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public sealed partial class ");
            String _aliasOrName_22 = this.getAliasOrName(consumedService_3);
            _builder.append(_aliasOrName_22, "\t");
            _builder.append("Proxy: I");
            String _aliasOrName_23 = this.getAliasOrName(consumedService_3);
            _builder.append(_aliasOrName_23, "\t");
            _builder.append("Proxy {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            String _alias_3 = consumedService_3.getAlias();
            boolean bl13 = bl11 = _alias_3 == null;
            if (bl11) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public static ");
                String string = this.getCsharpFullName(consumedService_3.getService());
                _builder.append(string, "\t\t");
                _builder.append(".Descriptor Descriptor = ");
                String _csharpFullName_10 = this.getCsharpFullName(consumedService_3.getService());
                _builder.append(_csharpFullName_10, "\t\t");
                _builder.append(".DefaultDescriptor;");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public const string Alias = \"");
                String string = consumedService_3.getAlias();
                _builder.append(string, "\t\t");
                _builder.append("\";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public static ");
                String _csharpFullName_11 = this.getCsharpFullName(consumedService_3.getService());
                _builder.append(_csharpFullName_11, "\t\t");
                _builder.append(".Descriptor Descriptor = ");
                String _csharpFullName_12 = this.getCsharpFullName(consumedService_3.getService());
                _builder.append(_csharpFullName_12, "\t\t");
                _builder.append(".CreateDescriptor(Alias);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("private readonly IClientCallInvoker _callInvoker;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("public ");
            String _aliasOrName_24 = this.getAliasOrName(consumedService_3);
            _builder.append(_aliasOrName_24, "\t\t");
            _builder.append("Proxy(IClientCallInvoker callInvoker) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("_callInvoker = callInvoker;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}\t\t\t\t\t\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            List<ConsumedMethod> list = GenUtils.getMethods(consumedService_3);
            boolean bl14 = false;
            for (ConsumedMethod consumedMethod_1 : list) {
                boolean bl15;
                if (!bl15) {
                    bl15 = true;
                } else {
                    _builder.appendImmediate("\n", "\t\t");
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public ");
                String _genProxySignature = this.genProxySignature(consumedMethod_1.getMethod(), "request");
                _builder.append(_genProxySignature, "\t\t");
                _builder.append(" {");
                _builder.newLineIfNotEmpty();
                Boolean _isStream = consumedMethod_1.getMethod().getRequest().getIsStream();
                if (_isStream.booleanValue()) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("return _callInvoker.Call(Descriptor.");
                    String _firstUpper_11 = StringExtensions.toFirstUpper(consumedMethod_1.getMethod().getName());
                    _builder.append(_firstUpper_11, "\t\t\t");
                    _builder.append("Method);");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("return _callInvoker.Call(Descriptor.");
                    String _firstUpper_12 = StringExtensions.toFirstUpper(consumedMethod_1.getMethod().getName());
                    _builder.append(_firstUpper_12, "\t\t\t");
                    _builder.append("Method, request);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public I");
            String string = this.getAliasOrName(consumedService_3);
            _builder.append(string, "\t");
            _builder.append("Proxy ");
            String string3 = this.getAliasOrName(consumedService_3);
            _builder.append(string3, "\t");
            _builder.append(" { get; private set; }");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public String gen(Service service) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(this.accessModifier);
        _builder.append(" static partial class ");
        String _firstUpper = StringExtensions.toFirstUpper(service.getName());
        _builder.append(_firstUpper);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public const string Id = \"");
        String _fullName = this.utils.getFullName(service);
        _builder.append(_fullName, "\t");
        _builder.append("\";\t\t\t");
        _builder.newLineIfNotEmpty();
        List<Method> _methods = GenUtils.getMethods(service);
        for (Method method : _methods) {
            _builder.append("\t");
            _builder.append("public const string ");
            String _firstUpper_1 = StringExtensions.toFirstUpper(method.getName());
            _builder.append(_firstUpper_1, "\t");
            _builder.append("MethodId = \"");
            String _name = method.getName();
            _builder.append(_name, "\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static readonly ");
        String _firstUpper_2 = StringExtensions.toFirstUpper(service.getName());
        _builder.append(_firstUpper_2, "\t");
        _builder.append(".Descriptor DefaultDescriptor = CreateDescriptor();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static ");
        String _firstUpper_3 = StringExtensions.toFirstUpper(service.getName());
        _builder.append(_firstUpper_3, "\t");
        _builder.append(".Descriptor CreateDescriptor() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return new ");
        String _firstUpper_4 = StringExtensions.toFirstUpper(service.getName());
        _builder.append(_firstUpper_4, "\t\t");
        _builder.append(".Descriptor();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("} ");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static ");
        String _firstUpper_5 = StringExtensions.toFirstUpper(service.getName());
        _builder.append(_firstUpper_5, "\t");
        _builder.append(".Descriptor CreateDescriptor(string alias) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return new ");
        String _firstUpper_6 = StringExtensions.toFirstUpper(service.getName());
        _builder.append(_firstUpper_6, "\t\t");
        _builder.append(".Descriptor(alias);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}\t\t\t\t");
        _builder.newLine();
        _builder.newLine();
        List<Method> _methods_1 = GenUtils.getMethods(service);
        boolean _hasElements = false;
        for (Method method_1 : _methods_1) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate("\n", "\t");
            }
            _builder.append("\t");
            _builder.append("public partial interface I");
            String _firstUpper_7 = StringExtensions.toFirstUpper(method_1.getName());
            _builder.append(_firstUpper_7, "\t");
            _builder.append("Proxy {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            String _genProxySignature = this.genProxySignature(method_1, "request");
            _builder.append(_genProxySignature, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        List<Method> _methods_2 = GenUtils.getMethods(service);
        boolean _hasElements_1 = false;
        for (Method method_2 : _methods_2) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate("\n", "\t");
            }
            _builder.append("\t");
            _builder.append("public partial interface I");
            String _firstUpper_8 = StringExtensions.toFirstUpper(method_2.getName());
            _builder.append(_firstUpper_8, "\t");
            _builder.append("Impl {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            String _genImplSignature = this.genImplSignature(method_2);
            _builder.append(_genImplSignature, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public sealed partial class Descriptor {");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        List<Method> _methods_3 = GenUtils.getMethods(service);
        for (Method method_3 : _methods_3) {
            _builder.append("\t\t");
            _builder.append("public ");
            String _csharpTypeDeclaration = this.getCsharpTypeDeclaration(method_3);
            _builder.append(_csharpTypeDeclaration, "\t\t");
            _builder.append(" ");
            String _firstUpper_9 = StringExtensions.toFirstUpper(method_3.getName());
            _builder.append(_firstUpper_9, "\t\t");
            _builder.append("Method {get; private set; }");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public Descriptor() {\t\t\t\t");
        _builder.newLine();
        List<Method> _methods_4 = GenUtils.getMethods(service);
        for (Method method_4 : _methods_4) {
            _builder.append("\t\t\t");
            String _firstUpper_10 = StringExtensions.toFirstUpper(method_4.getName());
            _builder.append(_firstUpper_10, "\t\t\t");
            _builder.append("Method = Method.");
            String _type = CsharpCodeGenerator.getType(method_4);
            _builder.append(_type, "\t\t\t");
            String _genericArgs = this.getGenericArgs(method_4);
            _builder.append(_genericArgs, "\t\t\t");
            _builder.append("(Id, ");
            String _firstUpper_11 = StringExtensions.toFirstUpper(method_4.getName());
            _builder.append(_firstUpper_11, "\t\t\t");
            _builder.append("MethodId);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public Descriptor(string alias) {");
        _builder.newLine();
        List<Method> _methods_5 = GenUtils.getMethods(service);
        for (Method method_5 : _methods_5) {
            _builder.append("\t\t\t");
            String _firstUpper_12 = StringExtensions.toFirstUpper(method_5.getName());
            _builder.append(_firstUpper_12, "\t\t\t");
            _builder.append("Method = Method.");
            String _type_1 = CsharpCodeGenerator.getType(method_5);
            _builder.append(_type_1, "\t\t\t");
            String _genericArgs_1 = this.getGenericArgs(method_5);
            _builder.append(_genericArgs_1, "\t\t\t");
            _builder.append("(Id, alias, ");
            String _firstUpper_13 = StringExtensions.toFirstUpper(method_5.getName());
            _builder.append(_firstUpper_13, "\t\t\t");
            _builder.append("MethodId);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public String genProxySignature(Method method, String requestVarName) {
        String _xifexpression = null;
        boolean _isPointToPoint = GenUtils.isPointToPoint(method);
        if (_isPointToPoint) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("IUnaryMethodCall<");
            String _csharpFullName = this.getCsharpFullName(method.getResponse().getMessage());
            _builder.append(_csharpFullName);
            _builder.append("> ");
            String _firstUpper = StringExtensions.toFirstUpper(method.getName());
            _builder.append(_firstUpper);
            _builder.append("(");
            String _csharpFullName_1 = this.getCsharpFullName(method.getRequest().getMessage());
            _builder.append(_csharpFullName_1);
            _builder.append(" ");
            _builder.append(requestVarName);
            _builder.append(")");
            _xifexpression = _builder.toString();
        } else {
            String _xifexpression_1 = null;
            boolean _isServerStreaming = GenUtils.isServerStreaming(method);
            if (_isServerStreaming) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("IServerStreamingMethodCall<");
                String _csharpFullName_2 = this.getCsharpFullName(method.getResponse().getMessage());
                _builder_1.append(_csharpFullName_2);
                _builder_1.append("> ");
                String _firstUpper_1 = StringExtensions.toFirstUpper(method.getName());
                _builder_1.append(_firstUpper_1);
                _builder_1.append("(");
                String _csharpFullName_3 = this.getCsharpFullName(method.getRequest().getMessage());
                _builder_1.append(_csharpFullName_3);
                _builder_1.append(" ");
                _builder_1.append(requestVarName);
                _builder_1.append(")");
                _xifexpression_1 = _builder_1.toString();
            } else {
                String _xifexpression_2 = null;
                boolean _isClientStreaming = GenUtils.isClientStreaming(method);
                if (_isClientStreaming) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("IClientStreamingMethodCall<");
                    String _csharpFullName_4 = this.getCsharpFullName(method.getRequest().getMessage());
                    _builder_2.append(_csharpFullName_4);
                    _builder_2.append(", ");
                    String _csharpFullName_5 = this.getCsharpFullName(method.getResponse().getMessage());
                    _builder_2.append(_csharpFullName_5);
                    _builder_2.append("> ");
                    String _firstUpper_2 = StringExtensions.toFirstUpper(method.getName());
                    _builder_2.append(_firstUpper_2);
                    _builder_2.append("()");
                    _xifexpression_2 = _builder_2.toString();
                } else {
                    String _xifexpression_3 = null;
                    boolean _isBidiStreaming = GenUtils.isBidiStreaming(method);
                    if (_isBidiStreaming) {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("IDuplexStreamingMethodCall<");
                        String _csharpFullName_6 = this.getCsharpFullName(method.getRequest().getMessage());
                        _builder_3.append(_csharpFullName_6);
                        _builder_3.append(", ");
                        String _csharpFullName_7 = this.getCsharpFullName(method.getResponse().getMessage());
                        _builder_3.append(_csharpFullName_7);
                        _builder_3.append("> ");
                        String _firstUpper_3 = StringExtensions.toFirstUpper(method.getName());
                        _builder_3.append(_firstUpper_3);
                        _builder_3.append("()");
                        _xifexpression_3 = _builder_3.toString();
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String genImplSignature(Method method) {
        String _xifexpression = null;
        boolean _isPointToPoint = GenUtils.isPointToPoint(method);
        if (_isPointToPoint) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Task<");
            String _csharpFullName = this.getCsharpFullName(method.getResponse().getMessage());
            _builder.append(_csharpFullName);
            _builder.append("> ");
            String _firstUpper = StringExtensions.toFirstUpper(method.getName());
            _builder.append(_firstUpper);
            _builder.append("(");
            String _csharpFullName_1 = this.getCsharpFullName(method.getRequest().getMessage());
            _builder.append(_csharpFullName_1);
            _builder.append(" request, MethodCallContext context)");
            _xifexpression = _builder.toString();
        } else {
            String _xifexpression_1 = null;
            boolean _isServerStreaming = GenUtils.isServerStreaming(method);
            if (_isServerStreaming) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Task ");
                String _firstUpper_1 = StringExtensions.toFirstUpper(method.getName());
                _builder_1.append(_firstUpper_1);
                _builder_1.append("(");
                String _csharpFullName_2 = this.getCsharpFullName(method.getRequest().getMessage());
                _builder_1.append(_csharpFullName_2);
                _builder_1.append(" request, IWritableChannel<");
                String _csharpFullName_3 = this.getCsharpFullName(method.getResponse().getMessage());
                _builder_1.append(_csharpFullName_3);
                _builder_1.append("> responseStream, MethodCallContext context)");
                _xifexpression_1 = _builder_1.toString();
            } else {
                String _xifexpression_2 = null;
                boolean _isClientStreaming = GenUtils.isClientStreaming(method);
                if (_isClientStreaming) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Task<");
                    String _csharpFullName_4 = this.getCsharpFullName(method.getResponse().getMessage());
                    _builder_2.append(_csharpFullName_4);
                    _builder_2.append("> ");
                    String _firstUpper_2 = StringExtensions.toFirstUpper(method.getName());
                    _builder_2.append(_firstUpper_2);
                    _builder_2.append("(IReadableChannel<");
                    String _csharpFullName_5 = this.getCsharpFullName(method.getRequest().getMessage());
                    _builder_2.append(_csharpFullName_5);
                    _builder_2.append("> requestStream, MethodCallContext context)");
                    _xifexpression_2 = _builder_2.toString();
                } else {
                    String _xifexpression_3 = null;
                    boolean _isBidiStreaming = GenUtils.isBidiStreaming(method);
                    if (_isBidiStreaming) {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("Task ");
                        String _firstUpper_3 = StringExtensions.toFirstUpper(method.getName());
                        _builder_3.append(_firstUpper_3);
                        _builder_3.append("(IReadableChannel<");
                        String _csharpFullName_6 = this.getCsharpFullName(method.getRequest().getMessage());
                        _builder_3.append(_csharpFullName_6);
                        _builder_3.append("> requestStream, IWritableChannel<");
                        String _csharpFullName_7 = this.getCsharpFullName(method.getResponse().getMessage());
                        _builder_3.append(_csharpFullName_7);
                        _builder_3.append("> responseStream, MethodCallContext context)");
                        _xifexpression_3 = _builder_3.toString();
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String genHandlerSignature(Method method) {
        StringConcatenation _builder = new StringConcatenation();
        String _type = CsharpCodeGenerator.getType(method);
        _builder.append(_type);
        _builder.append("MethodHandler");
        String _genericArgs = this.getGenericArgs(method);
        _builder.append(_genericArgs);
        return _builder.toString();
    }

    public String genMethodDescriptorStaticDeclaration(Method method) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public static readonly ");
        String _csharpTypeDeclaration = this.getCsharpTypeDeclaration(method);
        _builder.append(_csharpTypeDeclaration);
        _builder.append(" ");
        String _firstUpper = StringExtensions.toFirstUpper(method.getName());
        _builder.append(_firstUpper);
        _builder.append("Method = ");
        String _genMethodDescriptorDeclaration = this.genMethodDescriptorDeclaration(method);
        _builder.append(_genMethodDescriptorDeclaration);
        _builder.append(";");
        return _builder.toString();
    }

    public String genMethodDescriptorDeclaration(Method method) {
        String _xblockexpression = null;
        String serviceName = this.utils.getFullName(GenUtils.getService(method));
        String type = CsharpCodeGenerator.getType(method);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Method.");
        _builder.append(type);
        String _genericArgs = this.getGenericArgs(method);
        _builder.append(_genericArgs);
        _builder.append("(\"");
        _builder.append(serviceName);
        _builder.append("\", \"");
        String _name = method.getName();
        _builder.append(_name);
        _builder.append("\")");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String genMethodDescriptorDeclaration(Method method, String aliasVar) {
        String _xblockexpression = null;
        String serviceName = this.utils.getFullName(GenUtils.getService(method));
        String type = CsharpCodeGenerator.getType(method);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Method.");
        _builder.append(type);
        String _genericArgs = this.getGenericArgs(method);
        _builder.append(_genericArgs);
        _builder.append("(\"");
        _builder.append(serviceName);
        _builder.append("\", ");
        _builder.append(aliasVar);
        _builder.append(", \"");
        String _name = method.getName();
        _builder.append(_name);
        _builder.append("\")");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String getGenericArgs(Method method) {
        String _xblockexpression = null;
        String requestName = this.getCsharpFullName(method.getRequest().getMessage());
        String responseName = this.getCsharpFullName(method.getResponse().getMessage());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<");
        _builder.append(requestName);
        _builder.append(", ");
        _builder.append(responseName);
        _builder.append(">");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String getCsharpTypeDeclaration(Method method) {
        StringConcatenation _builder = new StringConcatenation();
        String _type = CsharpCodeGenerator.getType(method);
        _builder.append(_type);
        _builder.append("Method");
        String _genericArgs = this.getGenericArgs(method);
        _builder.append(_genericArgs);
        return _builder.toString();
    }

    public static String getType(Method method) {
        String _xblockexpression = null;
        String methodType = "Unary";
        String _xifexpression = null;
        boolean _isPointToPoint = GenUtils.isPointToPoint(method);
        if (_isPointToPoint) {
            methodType = "Unary";
            _xifexpression = "Unary";
        } else {
            String _xifexpression_1 = null;
            boolean _isServerStreaming = GenUtils.isServerStreaming(method);
            if (_isServerStreaming) {
                methodType = "ServerStreaming";
                _xifexpression_1 = "ServerStreaming";
            } else {
                String _xifexpression_2 = null;
                boolean _isBidiStreaming = GenUtils.isBidiStreaming(method);
                if (_isBidiStreaming) {
                    methodType = "DuplexStreaming";
                    _xifexpression_2 = "DuplexStreaming";
                } else {
                    String _xifexpression_3 = null;
                    boolean _isClientStreaming = GenUtils.isClientStreaming(method);
                    if (_isClientStreaming) {
                        methodType = "ClientStreaming";
                        _xifexpression_3 = "ClientStreaming";
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getCsharpNamespace(Resource resource) {
        String ns = "Plexus.Interop.Generated";
        Functions.Function1<Proto, Boolean> _function = x -> true;
        Proto package_ = IteratorExtensions.findFirst(Iterators.filter(resource.getAllContents(), Proto.class), _function);
        if (package_ != null) {
            Functions.Function1<String, String> _function_1 = x -> StringExtensions.toFirstUpper(x);
            ns = IterableExtensions.join(ListExtensions.map(this.qualifiedNameProvider.getFullyQualifiedName(package_).skipFirst(1).getSegments(), _function_1), ".");
        }
        Functions.Function1<Option, Boolean> _function_2 = o -> this.qualifiedNameProvider.getFullyQualifiedName(o.getDescriptor()).equals(CSHARP_NAMESPACE_OPTION_DESCRIPTOR_NAME);
        Option option = IterableExtensions.findFirst(Iterables.filter(package_.eContents(), Option.class), _function_2);
        if (option != null) {
            Constant _value = option.getValue();
            ns = ((StringConstant)_value).getValue();
        }
        return ns;
    }

    public String getCsharpFullName(Message obj) {
        String _csharpNamespace = this.getCsharpNamespace(obj.eResource());
        String _plus = "global::" + _csharpNamespace;
        String _plus_1 = _plus + ".";
        String _firstUpper = StringExtensions.toFirstUpper(obj.getName());
        return _plus_1 + _firstUpper;
    }

    public String getCsharpFullName(Service obj) {
        String _csharpNamespace = this.getCsharpNamespace(obj.eResource());
        String _plus = "global::" + _csharpNamespace;
        String _plus_1 = _plus + ".";
        String _firstUpper = StringExtensions.toFirstUpper(obj.getName());
        return _plus_1 + _firstUpper;
    }

    public String genCallCode(Method method) {
        String _xifexpression = null;
        boolean _isPointToPoint = GenUtils.isPointToPoint(method);
        if (_isPointToPoint) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(request, context)");
            _xifexpression = _builder.toString();
        } else {
            String _xifexpression_1 = null;
            boolean _isServerStreaming = GenUtils.isServerStreaming(method);
            if (_isServerStreaming) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("(request, responseStream, context)");
                _xifexpression_1 = _builder_1.toString();
            } else {
                String _xifexpression_2 = null;
                boolean _isClientStreaming = GenUtils.isClientStreaming(method);
                if (_isClientStreaming) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("(requestStream, context)");
                    _xifexpression_2 = _builder_2.toString();
                } else {
                    String _xifexpression_3 = null;
                    boolean _isBidiStreaming = GenUtils.isBidiStreaming(method);
                    if (_isBidiStreaming) {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("(requestStream, responseStream, context)");
                        _xifexpression_3 = _builder_3.toString();
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String genImplCallCode(Method method, String varName) {
        String _xifexpression = null;
        boolean _isPointToPoint = GenUtils.isPointToPoint(method);
        if (_isPointToPoint) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(varName);
            _builder.append(".");
            String _firstUpper = StringExtensions.toFirstUpper(method.getName());
            _builder.append(_firstUpper);
            String _genCallCode = this.genCallCode(method);
            _builder.append(_genCallCode);
            _xifexpression = _builder.toString();
        } else {
            String _xifexpression_1 = null;
            boolean _isServerStreaming = GenUtils.isServerStreaming(method);
            if (_isServerStreaming) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(varName);
                _builder_1.append(".");
                String _firstUpper_1 = StringExtensions.toFirstUpper(method.getName());
                _builder_1.append(_firstUpper_1);
                String _genCallCode_1 = this.genCallCode(method);
                _builder_1.append(_genCallCode_1);
                _xifexpression_1 = _builder_1.toString();
            } else {
                String _xifexpression_2 = null;
                boolean _isClientStreaming = GenUtils.isClientStreaming(method);
                if (_isClientStreaming) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append(varName);
                    _builder_2.append(".");
                    String _firstUpper_2 = StringExtensions.toFirstUpper(method.getName());
                    _builder_2.append(_firstUpper_2);
                    String _genCallCode_2 = this.genCallCode(method);
                    _builder_2.append(_genCallCode_2);
                    _xifexpression_2 = _builder_2.toString();
                } else {
                    String _xifexpression_3 = null;
                    boolean _isBidiStreaming = GenUtils.isBidiStreaming(method);
                    if (_isBidiStreaming) {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append(varName);
                        _builder_3.append(".");
                        String _firstUpper_3 = StringExtensions.toFirstUpper(method.getName());
                        _builder_3.append(_firstUpper_3);
                        String _genCallCode_3 = this.genCallCode(method);
                        _builder_3.append(_genCallCode_3);
                        _xifexpression_3 = _builder_3.toString();
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String getAliasOrName(ProvidedService providedService) {
        String _xifexpression = null;
        String _alias = providedService.getAlias();
        boolean _tripleNotEquals = _alias != null;
        _xifexpression = _tripleNotEquals ? StringExtensions.toFirstUpper(providedService.getAlias()) : StringExtensions.toFirstUpper(providedService.getService().getName());
        return _xifexpression;
    }

    public String getAliasOrName(ConsumedService consumedService) {
        String _xifexpression = null;
        String _alias = consumedService.getAlias();
        boolean _tripleNotEquals = _alias != null;
        _xifexpression = _tripleNotEquals ? StringExtensions.toFirstUpper(consumedService.getAlias()) : StringExtensions.toFirstUpper(consumedService.getService().getName());
        return _xifexpression;
    }

    public String getClientName(Application app) {
        boolean _endsWith = app.getName().endsWith("Client");
        if (_endsWith) {
            return StringExtensions.toFirstUpper(app.getName());
        }
        StringConcatenation _builder = new StringConcatenation();
        String _firstUpper = StringExtensions.toFirstUpper(app.getName());
        _builder.append(_firstUpper);
        _builder.append("Client");
        return _builder.toString();
    }
}

