/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen.js;

import com.db.plexus.interop.dsl.Application;
import com.db.plexus.interop.dsl.ConsumedMethod;
import com.db.plexus.interop.dsl.ConsumedService;
import com.db.plexus.interop.dsl.ProvidedMethod;
import com.db.plexus.interop.dsl.ProvidedService;
import com.db.plexus.interop.dsl.gen.ApplicationCodeGenerator;
import com.db.plexus.interop.dsl.gen.GenUtils;
import com.db.plexus.interop.dsl.gen.PlexusGenConfig;
import com.db.plexus.interop.dsl.protobuf.Method;
import com.google.inject.Inject;
import java.util.List;
import javax.inject.Named;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Named
public class JsComponentApiGenerator
extends ApplicationCodeGenerator {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    public String fullName(EObject obj) {
        return this.qualifiedNameProvider.getFullyQualifiedName(obj).skipFirst(1).toString();
    }

    public String namespace(EObject obj) {
        return this.qualifiedNameProvider.getFullyQualifiedName(obj).skipFirst(1).skipLast(1).toString();
    }

    @Override
    public String generate(PlexusGenConfig genConfig, Application app, List<Resource> resources) {
        boolean _not;
        String _xblockexpression = null;
        List<ConsumedService> consumedServices = GenUtils.getConsumedServices(app);
        List<ProvidedService> providedServices = GenUtils.getProvidedServices(app);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _imports = this.imports(genConfig);
        _builder.append(_imports);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasElements = false;
        for (ConsumedService consumedService : consumedServices) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate("\n", "");
            }
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*  Internal Proxy implementation for ");
            String string = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService));
            _builder.append(string, " ");
            _builder.append(" service");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("export class ");
            String _firstUpper_1 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService));
            _builder.append(_firstUpper_1);
            _builder.append("Proxy {");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("constructor(genericClient) {");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("this.genericClient = genericClient;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            List<ConsumedMethod> _methods = GenUtils.getMethods(consumedService);
            boolean _hasElements_1 = false;
            for (ConsumedMethod consumedMethod : _methods) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate("\n", "    ");
                }
                _builder.append("    ");
                CharSequence _clientMethodSignature = this.clientMethodSignature(consumedMethod, genConfig);
                _builder.append((Object)_clientMethodSignature, "    ");
                _builder.append(" {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                String _clientMethodImpl = this.clientMethodImpl(consumedMethod, consumedService, genConfig);
                _builder.append(_clientMethodImpl, "        ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Client's API internal implementation");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("class ");
        String _name = app.getName();
        _builder.append(_name);
        _builder.append("Client extends GenericClientApiBase {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("constructor(");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("genericClient,");
        _builder.newLine();
        boolean _hasElements_2 = false;
        for (ConsumedService consumedService : consumedServices) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate(",", "        ");
            }
            _builder.append("        ");
            String _firstLower = StringExtensions.toFirstLower(GenUtils.getAliasOrName(consumedService));
            _builder.append(_firstLower, "        ");
            _builder.append("Proxy");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.append(") {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("super(genericClient);");
        _builder.newLine();
        for (ConsumedService consumedService : consumedServices) {
            _builder.append("        ");
            _builder.append("this.");
            String string = StringExtensions.toFirstLower(GenUtils.getAliasOrName(consumedService));
            _builder.append(string, "        ");
            _builder.append("Proxy = ");
            String _firstLower_2 = StringExtensions.toFirstLower(GenUtils.getAliasOrName(consumedService));
            _builder.append(_firstLower_2, "        ");
            _builder.append("Proxy;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _hasElements_3 = false;
        for (ConsumedService consumedService : consumedServices) {
            if (!_hasElements_3) {
                _hasElements_3 = true;
            } else {
                _builder.appendImmediate("\n", "    ");
            }
            _builder.append("    ");
            _builder.append("get");
            String _firstUpper_2 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService));
            _builder.append(_firstUpper_2, "    ");
            _builder.append("Proxy() {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("return this.");
            String _firstLower_3 = StringExtensions.toFirstLower(GenUtils.getAliasOrName(consumedService));
            _builder.append(_firstLower_3, "        ");
            _builder.append("Proxy;");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _hasElements_4 = false;
        for (ProvidedService providedService : providedServices) {
            if (!_hasElements_4) {
                _hasElements_4 = true;
            } else {
                _builder.appendImmediate("\n", "");
            }
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Client invocation handler for ");
            String _firstUpper_3 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(providedService));
            _builder.append(_firstUpper_3, " ");
            _builder.append(", to be implemented by Client");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("export class ");
            String _firstUpper_4 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(providedService));
            _builder.append(_firstUpper_4);
            _builder.append("InvocationHandler {");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            List<ProvidedMethod> _methods_1 = GenUtils.getMethods(providedService);
            for (ProvidedMethod providedMethod : _methods_1) {
                _builder.append("    ");
                CharSequence _clientHandlerSignature = this.clientHandlerSignature(providedMethod.getMethod(), genConfig);
                _builder.append((Object)_clientHandlerSignature, "    ");
                _builder.append(" {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("// TODO implement handler");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _hasElements_5 = false;
        for (ProvidedService providedService : providedServices) {
            if (!_hasElements_5) {
                _hasElements_5 = true;
            } else {
                _builder.appendImmediate("\n", "");
            }
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Internal invocation handler delegate for ");
            String _firstUpper_5 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(providedService));
            _builder.append(_firstUpper_5, " ");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("class ");
            String _firstUpper_6 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(providedService));
            _builder.append(_firstUpper_6);
            _builder.append("InvocationHandlerInternal {");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("constructor(clientHandler) {");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("this.clientHandler = clientHandler;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            List<ProvidedMethod> _methods_2 = GenUtils.getMethods(providedService);
            boolean _hasElements_6 = false;
            for (ProvidedMethod providedMethod_1 : _methods_2) {
                if (!_hasElements_6) {
                    _hasElements_6 = true;
                } else {
                    _builder.appendImmediate("\n", "    ");
                }
                _builder.append("    ");
                CharSequence _genericClientHandlerSignature = this.genericClientHandlerSignature(providedMethod_1.getMethod(), genConfig);
                _builder.append((Object)_genericClientHandlerSignature, "    ");
                _builder.append(" {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                CharSequence _handlerMethodImpl = this.handlerMethodImpl(providedMethod_1.getMethod(), genConfig);
                _builder.append((Object)_handlerMethodImpl, "        ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Client API builder");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("export class ");
        String _name_1 = app.getName();
        _builder.append(_name_1);
        _builder.append("ClientBuilder {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("withClientDetails(clientId) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("this.clientDetails = clientId;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("withAppInstanceId(appInstanceId) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("this.clientDetails = this.clientDetails || {};");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("this.clientDetails.applicationInstanceId = appInstanceId;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("withAppId(appId) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("this.clientDetails = this.clientDetails || {};");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("this.clientDetails.applicationId = appId;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean bl = false;
        for (ProvidedService providedMethod_2 : providedServices) {
            boolean bl2;
            if (!bl2) {
                bl2 = true;
            } else {
                _builder.appendImmediate("\n", "    ");
            }
            _builder.append("    ");
            _builder.append("with");
            String _firstUpper_7 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(providedMethod_2));
            _builder.append(_firstUpper_7, "    ");
            _builder.append("InvocationsHandler(invocationsHandler) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("this.");
            String _firstLower_4 = StringExtensions.toFirstLower(GenUtils.getAliasOrName(providedMethod_2));
            _builder.append(_firstLower_4, "        ");
            _builder.append("Handler = new ");
            String _firstUpper_8 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(providedMethod_2));
            _builder.append(_firstUpper_8, "        ");
            _builder.append("InvocationHandlerInternal(invocationsHandler);");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("return this;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("    ");
        _builder.append("withTransportConnectionProvider(provider) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("this.transportConnectionProvider = provider;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("connect() {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return new ContainerAwareClientAPIBuilder()");
        _builder.newLine();
        _builder.append("            ");
        _builder.append(".withTransportConnectionProvider(this.transportConnectionProvider)");
        _builder.newLine();
        _builder.append("            ");
        _builder.append(".withClientDetails(this.clientDetails)");
        _builder.newLine();
        for (ProvidedService providedService : providedServices) {
            List<ProvidedMethod> _methods_3 = GenUtils.getMethods(providedService);
            for (ProvidedMethod providedMethod_3 : _methods_3) {
                _builder.append("            ");
                CharSequence _invocationHandlerBuilder = this.invocationHandlerBuilder(providedMethod_3.getMethod(), providedService, genConfig);
                _builder.append((Object)_invocationHandlerBuilder, "            ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("            ");
        _builder.append(".connect()");
        _builder.newLine();
        _builder.append("            ");
        _builder.append(".then(genericClient => new ");
        String string = app.getName();
        _builder.append(string, "            ");
        _builder.append("ClientImpl(");
        _builder.newLineIfNotEmpty();
        _builder.append("                ");
        _builder.append("genericClient");
        boolean bl3 = consumedServices.isEmpty();
        boolean bl4 = _not = !bl3;
        if (_not) {
            _builder.append(",");
        }
        _builder.newLineIfNotEmpty();
        boolean bl5 = false;
        for (ConsumedService consumedService_4 : consumedServices) {
            boolean bl6;
            if (!bl6) {
                bl6 = true;
            } else {
                _builder.appendImmediate(",", "                ");
            }
            _builder.append("                ");
            _builder.append("new ");
            String _firstUpper_9 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService_4));
            _builder.append(_firstUpper_9, "                ");
            _builder.append("ProxyImpl(genericClient)");
            _builder.newLineIfNotEmpty();
            _builder.append("                ");
        }
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public CharSequence invocationHandlerBuilder(Method rpcMethod, ProvidedService providedService, PlexusGenConfig genConfig) {
        boolean _isServerStreaming;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        boolean _isPointToPoint = GenUtils.isPointToPoint(rpcMethod);
        if (_isPointToPoint) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(".withUnaryInvocationHandler({");
            _builder.newLine();
            _builder.append("    ");
            String _handlerBuilderParam = this.handlerBuilderParam(rpcMethod, providedService, genConfig);
            _builder.append(_handlerBuilderParam, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append("})");
            _builder.newLine();
            _switchResult = _builder;
        }
        if (!_matched && (GenUtils.isBidiStreaming(rpcMethod) || GenUtils.isClientStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(".withBidiStreamingInvocationHandler({");
            _builder_1.newLine();
            _builder_1.append("    ");
            String _handlerBuilderParam_1 = this.handlerBuilderParam(rpcMethod, providedService, genConfig);
            _builder_1.append(_handlerBuilderParam_1, "    ");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("})");
            _builder_1.newLine();
            _switchResult = _builder_1;
        }
        if (!_matched && (_isServerStreaming = GenUtils.isServerStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(".withServerStreamingInvocationHandler({");
            _builder_2.newLine();
            _builder_2.append("    ");
            String _handlerBuilderParam_2 = this.handlerBuilderParam(rpcMethod, providedService, genConfig);
            _builder_2.append(_handlerBuilderParam_2, "    ");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("})");
            _builder_2.newLine();
            _switchResult = _builder_2;
        }
        return _switchResult;
    }

    public String handlerBuilderParam(Method rpcMethod, ProvidedService providedService, PlexusGenConfig genConfig) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("serviceInfo: {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("serviceId: \"");
        String _fullName = this.fullName(GenUtils.getService(rpcMethod));
        _builder.append(_fullName, "    ");
        _builder.append("\"");
        String _alias = providedService.getAlias();
        boolean bl = _tripleNotEquals = _alias != null;
        if (_tripleNotEquals) {
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("serviceAlias: \"");
            String _alias_1 = providedService.getAlias();
            _builder.append(_alias_1, "    ");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("},");
        _builder.newLine();
        _builder.append("handler: {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("methodId: \"");
        String _name = rpcMethod.getName();
        _builder.append(_name, "    ");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("handle: this.");
        String _firstLower = StringExtensions.toFirstLower(GenUtils.getAliasOrName(providedService));
        _builder.append(_firstLower, "    ");
        _builder.append("Handler.on");
        String _name_1 = rpcMethod.getName();
        _builder.append(_name_1, "    ");
        _builder.append(".bind(this.");
        String _firstLower_1 = StringExtensions.toFirstLower(GenUtils.getAliasOrName(providedService));
        _builder.append(_firstLower_1, "    ");
        _builder.append("Handler)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public CharSequence imports(PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import { MethodInvocationContext, Completion, ClientConnectRequest, StreamingInvocationClient, GenericClientApi, InvocationRequestInfo, InvocationClient, GenericRequest, GenericClientApiBase } from \"@plexus-interop/client\";");
        _builder.newLine();
        _builder.append("import { ProvidedMethodReference, ServiceDiscoveryRequest, ServiceDiscoveryResponse, MethodDiscoveryRequest, MethodDiscoveryResponse, GenericClientApiBuilder, ValueHandler } from \"@plexus-interop/client\";");
        _builder.newLine();
        _builder.append("import { TransportConnection, UniqueId } from \"@plexus-interop/transport-common\";");
        _builder.newLine();
        _builder.append("import { Arrays, Observer } from \"@plexus-interop/common\";");
        _builder.newLine();
        _builder.append("import { InvocationObserver, InvocationObserverConverter, ContainerAwareClientAPIBuilder } from \"@plexus-interop/client\";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import * as plexus from \"");
        String _get = genConfig.getExternalDependencies().get(0);
        _builder.append(_get);
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence clientMethodSignature(ConsumedMethod methodLink, PlexusGenConfig genConfig) {
        return this.clientMethodSignature(methodLink.getMethod(), genConfig);
    }

    public CharSequence clientMethodSignature(Method rpcMethod, PlexusGenConfig genConfig) {
        boolean _isServerStreaming;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        boolean _isPointToPoint = GenUtils.isPointToPoint(rpcMethod);
        if (_isPointToPoint) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            String _firstLower = StringExtensions.toFirstLower(rpcMethod.getName());
            _builder.append(_firstLower);
            _builder.append("(request)");
            _switchResult = _builder;
        }
        if (!_matched && (GenUtils.isBidiStreaming(rpcMethod) || GenUtils.isClientStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            String _firstLower_1 = StringExtensions.toFirstLower(rpcMethod.getName());
            _builder_1.append(_firstLower_1);
            _builder_1.append("(responseObserver)");
            _switchResult = _builder_1;
        }
        if (!_matched && (_isServerStreaming = GenUtils.isServerStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_2 = new StringConcatenation();
            String _firstLower_2 = StringExtensions.toFirstLower(rpcMethod.getName());
            _builder_2.append(_firstLower_2);
            _builder_2.append("(request, responseObserver)");
            _switchResult = _builder_2;
        }
        return _switchResult;
    }

    public CharSequence requestType(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        String _namespace = genConfig.getNamespace();
        _builder.append(_namespace);
        _builder.append(".");
        String _lowerCase = this.namespace(rpcMethod.getRequest().getMessage()).toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".I");
        String _name = rpcMethod.getRequest().getMessage().getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence responseType(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        String _namespace = genConfig.getNamespace();
        _builder.append(_namespace);
        _builder.append(".");
        String _lowerCase = this.namespace(rpcMethod.getResponse().getMessage()).toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".I");
        String _name = rpcMethod.getResponse().getMessage().getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence requestTypeImpl(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        String _namespace = genConfig.getNamespace();
        _builder.append(_namespace);
        _builder.append(".");
        String _lowerCase = this.namespace(rpcMethod.getRequest().getMessage()).toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".");
        String _name = rpcMethod.getRequest().getMessage().getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence responseTypeImpl(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        String _namespace = genConfig.getNamespace();
        _builder.append(_namespace);
        _builder.append(".");
        String _lowerCase = this.namespace(rpcMethod.getResponse().getMessage()).toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".");
        String _name = rpcMethod.getResponse().getMessage().getName();
        _builder.append(_name);
        return _builder;
    }

    public String clientMethodImpl(ConsumedMethod consumed, ConsumedService consumedService, PlexusGenConfig genConfig) {
        boolean _isServerStreaming;
        String _xblockexpression = null;
        Method rpcMethod = consumed.getMethod();
        String _switchResult = null;
        boolean _matched = false;
        boolean _isPointToPoint = GenUtils.isPointToPoint(rpcMethod);
        if (_isPointToPoint) {
            _matched = true;
            _switchResult = this.clientPointToPointImpl(consumed, consumedService, genConfig);
        }
        if (!_matched && (GenUtils.isBidiStreaming(rpcMethod) || GenUtils.isClientStreaming(rpcMethod))) {
            _matched = true;
            _switchResult = this.clientBidiStreamingImpl(consumed, consumedService, genConfig);
        }
        if (!_matched && (_isServerStreaming = GenUtils.isServerStreaming(rpcMethod))) {
            _matched = true;
            _switchResult = this.serverStreamingImpl(consumed, consumedService, genConfig);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public String clientPointToPointImpl(ConsumedMethod consumed, ConsumedService consumedService, PlexusGenConfig genConfig) {
        Method rpcMethod = consumed.getMethod();
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _clientConverters = this.clientConverters(rpcMethod, genConfig);
        _builder.append(_clientConverters);
        _builder.newLineIfNotEmpty();
        String _clientInvocationInfo = this.clientInvocationInfo(consumed, consumedService, genConfig);
        _builder.append(_clientInvocationInfo);
        _builder.newLineIfNotEmpty();
        _builder.append("return new Promise((resolve, reject) => {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("this.genericClient.sendRawUnaryRequest(invocationInfo, requestToBinaryConverter(request), {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("value: responsePayload => {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("resolve(responseFromBinaryConverter(responsePayload));");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("},");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("error: (e) => {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("reject(e);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("});");
        _builder.newLine();
        _builder.append("});");
        _builder.newLine();
        return _builder.toString();
    }

    public String clientBidiStreamingImpl(ConsumedMethod consumed, ConsumedService consumedService, PlexusGenConfig genConfig) {
        Method rpcMethod = consumed.getMethod();
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _clientConverters = this.clientConverters(rpcMethod, genConfig);
        _builder.append(_clientConverters);
        _builder.newLineIfNotEmpty();
        String _clientInvocationInfo = this.clientInvocationInfo(consumed, consumedService, genConfig);
        _builder.append(_clientInvocationInfo);
        _builder.newLineIfNotEmpty();
        _builder.append("return this.genericClient.sendRawBidirectionalStreamingRequest(");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("invocationInfo,");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("new InvocationObserverConverter(responseObserver, responseFromBinaryConverter))");
        _builder.newLine();
        _builder.append("    ");
        _builder.append(".then(baseClient =>  {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("next: (request: ");
        CharSequence _requestType = this.requestType(rpcMethod, genConfig);
        _builder.append((Object)_requestType, "            ");
        _builder.append(") => baseClient.next(requestToBinaryConverter(request)),");
        _builder.newLineIfNotEmpty();
        _builder.append("            ");
        _builder.append("error: baseClient.error.bind(baseClient),");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("complete: baseClient.complete.bind(baseClient),");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("cancel: baseClient.cancel.bind(baseClient)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("};");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("});");
        _builder.newLine();
        return _builder.toString();
    }

    public String serverStreamingImpl(ConsumedMethod consumed, ConsumedService consumedService, PlexusGenConfig genConfig) {
        Method rpcMethod = consumed.getMethod();
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _clientConverters = this.clientConverters(rpcMethod, genConfig);
        _builder.append(_clientConverters);
        _builder.newLineIfNotEmpty();
        String _clientInvocationInfo = this.clientInvocationInfo(consumed, consumedService, genConfig);
        _builder.append(_clientInvocationInfo);
        _builder.newLineIfNotEmpty();
        _builder.append("return this.genericClient.sendRawServerStreamingRequest(");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("invocationInfo,");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("requestToBinaryConverter(request),");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("new InvocationObserverConverter(responseObserver, responseFromBinaryConverter));");
        _builder.newLine();
        return _builder.toString();
    }

    public CharSequence clientConverters(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const requestToBinaryConverter = from => Arrays.toArrayBuffer(");
        CharSequence _requestTypeImpl = this.requestTypeImpl(rpcMethod, genConfig);
        _builder.append(_requestTypeImpl);
        _builder.append(".encode(from).finish());");
        _builder.newLineIfNotEmpty();
        _builder.append("const responseFromBinaryConverter = from => {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("const decoded = ");
        CharSequence _responseTypeImpl = this.responseTypeImpl(rpcMethod, genConfig);
        _builder.append((Object)_responseTypeImpl, "    ");
        _builder.append(".decode(new Uint8Array(from));");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return ");
        CharSequence _responseTypeImpl_1 = this.responseTypeImpl(rpcMethod, genConfig);
        _builder.append((Object)_responseTypeImpl_1, "    ");
        _builder.append(".toObject(decoded);");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    public String clientInvocationInfo(ConsumedMethod consumed, ConsumedService consumedService, PlexusGenConfig genConfig) {
        boolean _tripleNotEquals;
        Method rpcMethod = consumed.getMethod();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const invocationInfo = {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("methodId: \"");
        String _name = rpcMethod.getName();
        _builder.append(_name, "    ");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("serviceId: \"");
        String _fullName = this.fullName(GenUtils.getService(rpcMethod));
        _builder.append(_fullName, "    ");
        _builder.append("\"");
        String _alias = consumedService.getAlias();
        boolean bl = _tripleNotEquals = _alias != null;
        if (_tripleNotEquals) {
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("serviceAlias: \"");
            String _alias_1 = consumedService.getAlias();
            _builder.append(_alias_1, "    ");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder.toString();
    }

    public CharSequence clientHandlerSignature(Method rpcMethod, PlexusGenConfig genConfig) {
        boolean _isServerStreaming;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        boolean _isPointToPoint = GenUtils.isPointToPoint(rpcMethod);
        if (_isPointToPoint) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("on");
            String _name = rpcMethod.getName();
            _builder.append(_name);
            _builder.append("(invocationContext, request)");
            _switchResult = _builder;
        }
        if (!_matched && (GenUtils.isBidiStreaming(rpcMethod) || GenUtils.isClientStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("on");
            String _name_1 = rpcMethod.getName();
            _builder_1.append(_name_1);
            _builder_1.append("(invocationContext, hostClient)");
            _switchResult = _builder_1;
        }
        if (!_matched && (_isServerStreaming = GenUtils.isServerStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("on");
            String _name_2 = rpcMethod.getName();
            _builder_2.append(_name_2);
            _builder_2.append("(invocationContext, request, hostClient)");
            _switchResult = _builder_2;
        }
        return _switchResult;
    }

    public CharSequence genericClientHandlerSignature(Method rpcMethod, PlexusGenConfig genConfig) {
        boolean _isServerStreaming;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        boolean _isPointToPoint = GenUtils.isPointToPoint(rpcMethod);
        if (_isPointToPoint) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("on");
            String _name = rpcMethod.getName();
            _builder.append(_name);
            _builder.append("(invocationContext, request)");
            _switchResult = _builder;
        }
        if (!_matched && (GenUtils.isBidiStreaming(rpcMethod) || GenUtils.isClientStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("on");
            String _name_1 = rpcMethod.getName();
            _builder_1.append(_name_1);
            _builder_1.append("(invocationContext, hostClient)");
            _switchResult = _builder_1;
        }
        if (!_matched && (_isServerStreaming = GenUtils.isServerStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("on");
            String _name_2 = rpcMethod.getName();
            _builder_2.append(_name_2);
            _builder_2.append("(invocationContext, request, hostClient)");
            _switchResult = _builder_2;
        }
        return _switchResult;
    }

    public CharSequence handlerMethodImpl(Method rpcMethod, PlexusGenConfig genConfig) {
        boolean _isServerStreaming;
        CharSequence _switchResult = null;
        boolean _matched = false;
        boolean _isPointToPoint = GenUtils.isPointToPoint(rpcMethod);
        if (_isPointToPoint) {
            _matched = true;
            _switchResult = this.handlerPointToPointImpl(rpcMethod, genConfig);
        }
        if (!_matched && (GenUtils.isBidiStreaming(rpcMethod) || GenUtils.isClientStreaming(rpcMethod))) {
            _matched = true;
            _switchResult = this.handlerBidiStreamingImpl(rpcMethod, genConfig);
        }
        if (!_matched && (_isServerStreaming = GenUtils.isServerStreaming(rpcMethod))) {
            _matched = true;
            _switchResult = this.handlerServerStreamingImpl(rpcMethod, genConfig);
        }
        return _switchResult;
    }

    public CharSequence handlerPointToPointImpl(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _handlerConverters = this.handlerConverters(rpcMethod, genConfig);
        _builder.append(_handlerConverters);
        _builder.newLineIfNotEmpty();
        _builder.append("return this.clientHandler");
        _builder.newLine();
        _builder.append("    ");
        _builder.append(".on");
        String _name = rpcMethod.getName();
        _builder.append(_name, "    ");
        _builder.append("(invocationContext, requestFromBinaryConverter(request))");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append(".then(response => responseToBinaryConverter(response));");
        _builder.newLine();
        return _builder;
    }

    public CharSequence handlerBidiStreamingImpl(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _handlerConverters = this.handlerConverters(rpcMethod, genConfig);
        _builder.append(_handlerConverters);
        _builder.newLineIfNotEmpty();
        _builder.append("const baseObserver = this.clientHandler");
        _builder.newLine();
        _builder.append("    ");
        _builder.append(".on");
        String _name = rpcMethod.getName();
        _builder.append(_name, "    ");
        _builder.append("(invocationContext, {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("next: (response) => hostClient.next(responseToBinaryConverter(response)),");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("complete: hostClient.complete.bind(hostClient),");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("error: hostClient.error.bind(hostClient),");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("cancel: hostClient.cancel.bind(hostClient)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("});");
        _builder.newLine();
        _builder.append("return {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("next: (value) => baseObserver.next(requestFromBinaryConverter(value)),");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("complete: baseObserver.complete.bind(baseObserver),");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("error: baseObserver.error.bind(baseObserver),");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("streamCompleted: baseObserver.streamCompleted.bind(baseObserver)");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    public CharSequence handlerServerStreamingImpl(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _handlerConverters = this.handlerConverters(rpcMethod, genConfig);
        _builder.append(_handlerConverters);
        _builder.newLineIfNotEmpty();
        _builder.append("this.clientHandler");
        _builder.newLine();
        _builder.append("    ");
        _builder.append(".on");
        String _name = rpcMethod.getName();
        _builder.append(_name, "    ");
        _builder.append("(invocationContext, requestFromBinaryConverter(request), {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("next: (response) => hostClient.next(responseToBinaryConverter(response)),");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("complete: hostClient.complete.bind(hostClient),");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("error: hostClient.error.bind(hostClient),");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("cancel: hostClient.cancel.bind(hostClient)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("});");
        _builder.newLine();
        return _builder;
    }

    public CharSequence handlerConverters(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const responseToBinaryConverter = from => Arrays.toArrayBuffer(");
        CharSequence _responseTypeImpl = this.responseTypeImpl(rpcMethod, genConfig);
        _builder.append(_responseTypeImpl);
        _builder.append(".encode(from).finish());");
        _builder.newLineIfNotEmpty();
        _builder.append("const requestFromBinaryConverter = from => {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("const decoded = ");
        CharSequence _requestTypeImpl = this.requestTypeImpl(rpcMethod, genConfig);
        _builder.append((Object)_requestTypeImpl, "    ");
        _builder.append(".decode(new Uint8Array(from));");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return ");
        CharSequence _requestTypeImpl_1 = this.requestTypeImpl(rpcMethod, genConfig);
        _builder.append((Object)_requestTypeImpl_1, "    ");
        _builder.append(".toObject(decoded);");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }
}

