/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen.js;

import com.db.plexus.interop.dsl.Application;
import com.db.plexus.interop.dsl.gen.BaseGenTask;
import com.db.plexus.interop.dsl.gen.GenUtils;
import com.db.plexus.interop.dsl.gen.PlexusGenConfig;
import com.db.plexus.interop.dsl.gen.js.JsComponentApiGenerator;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.XtextResourceSet;

@Named
public class JsGenTask
extends BaseGenTask {
    public static final String PROTO_JS_COMPILER = "pbjs";
    public static final String PROTO_JS_COMPILER_CMD = "pbjs.cmd";
    public static final String PLEXUS_MESSAGES_MODULES = "plexus-messages";
    @Inject
    private JsComponentApiGenerator codeOutputGenerator;

    @Override
    protected void doGenWithResources(PlexusGenConfig config, XtextResourceSet rs) throws IOException {
        EList<Resource> resources = rs.getResources();
        String pbJsPath = null;
        String configProtocPath = config.getProtocPath();
        if (configProtocPath == null || configProtocPath.isEmpty()) {
            this.logger.info("Proto compiler not provided, messages generation will be skipped");
        } else if (!configProtocPath.endsWith(PROTO_JS_COMPILER) && !configProtocPath.endsWith(PROTO_JS_COMPILER_CMD)) {
            this.logger.warning("Only pbjs compiler supported, messages generation will be skipped");
        } else {
            pbJsPath = configProtocPath;
        }
        List protoFilePaths = resources.stream().filter(x -> x.getURI().lastSegment().endsWith(".proto")).filter(x -> !x.getURI().toString().endsWith("google/protobuf/descriptor.proto")).filter(x -> !x.getURI().toString().endsWith("interop/descriptor.proto")).map(resource -> new File(resource.getURI().toFileString()).getAbsolutePath()).collect(Collectors.toList());
        String outDirPath = this.getAbsolutePath(config.getOutDir());
        if (protoFilePaths.isEmpty()) {
            this.logger.warning("No proto resources detected");
        }
        if (pbJsPath != null) {
            this.logger.info("Using " + pbJsPath + " to generate JS messages");
            ArrayList<String> pbJsArgs = new ArrayList<String>(Arrays.asList(pbJsPath));
            pbJsArgs.addAll(this.jsProtoArgs(config, outDirPath));
            pbJsArgs.addAll(protoFilePaths);
            int resultCode = this.generateMessages(pbJsArgs);
            if (resultCode == 0) {
                this.logger.info("Generated successfully");
            }
        }
        List<Application> applications = GenUtils.getApplications(resources.toArray(new Resource[0]));
        config.setExternalDependencies(Arrays.asList("./plexus-messages"));
        for (Application application : applications) {
            this.logger.info("Generating JS Client for " + application.getName());
            String stringContent = this.codeOutputGenerator.generate(config, application, resources);
            this.logger.info("Generated successfully");
            this.writeToFile(config.getOutDir() + "/" + application.getName() + "GeneratedClient.js", stringContent);
        }
    }

    private List<String> jsProtoArgs(PlexusGenConfig config, String outDirPath) {
        return Arrays.asList("--force-long", "-t", "static-module", "-r", config.getNamespace(), "-w", "commonjs", "-o", outDirPath + File.separator + PLEXUS_MESSAGES_MODULES + ".js");
    }
}

