/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen.meta;

import com.db.plexus.interop.dsl.gen.BaseGenTask;
import com.db.plexus.interop.dsl.gen.PlexusGenConfig;
import com.db.plexus.interop.dsl.validation.Issues;
import com.db.plexus.interop.dsl.validation.MetadataPatchValidator;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class MetaPatchValidatorTask
extends BaseGenTask {
    public static final String NAME = "validate-patch";
    @Inject
    private MetadataPatchValidator metadataPatchValidator;

    @Override
    public void doGen(PlexusGenConfig config) {
        try {
            boolean _not;
            URI workingDirUri = this.getWorkingDir();
            URI sourceBaseDir = this.getRelativeURI(config.getBaseDir(), workingDirUri);
            URI targetBaseDir = this.getRelativeURI(config.getTargetBaseDir(), workingDirUri);
            XtextResourceSet sourceResourceSet = new XtextResourceSet();
            XtextResourceSet targetResourceSet = new XtextResourceSet();
            this.loadResources(sourceResourceSet, sourceBaseDir, config.isVerbose(), "*.{proto,interop}");
            this.loadResources(targetResourceSet, targetBaseDir, config.isVerbose(), "*.{proto,interop}");
            List<Issue> issues = this.metadataPatchValidator.validatePatch(targetResourceSet, sourceResourceSet);
            boolean _isEmpty = issues.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                boolean _hasErrors;
                boolean _isVerbose = config.isVerbose();
                if (_isVerbose) {
                    String issuesString = Issues.issuesToString(IterableExtensions.sortWith(issues, Issues.issuesComparator()));
                    InputOutput.println(issuesString);
                }
                if (_hasErrors = Issues.hasErrors(issues)) {
                    System.exit(1);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }
}

