/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen.util;

import com.db.plexus.interop.dsl.gen.util.CombinedFilePathMatcher;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;

public class FileUtils {
    private static Logger log = Logger.getLogger(FileUtils.class);

    public static File createTempDir() throws IOException {
        Path directory = Files.createTempDirectory("plexus" + Long.toString(System.nanoTime()), new FileAttribute[0]);
        return directory.toFile();
    }

    public static void writeStringToFile(File file, String content) throws IOException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.append(content);
        }
    }

    public static void processFiles(String baseDir, String pattern, Consumer<Path> fileHandler) throws IOException {
        Files.walkFileTree(Paths.get(baseDir, new String[0]), new Finder(pattern, fileHandler));
    }

    public static String commonPath(List<String> paths) {
        String commonPath = "";
        String[][] folders = new String[paths.size()][];
        for (int i = 0; i < paths.size(); ++i) {
            folders[i] = paths.get(i).split("\\" + File.separator);
        }
        for (int j = 0; j < folders[0].length; ++j) {
            String thisFolder = folders[0][j];
            boolean allMatched = true;
            for (int i = 1; i < folders.length && allMatched; allMatched &= folders[i][j].equals(thisFolder), ++i) {
                if (folders[i].length >= j) continue;
                allMatched = false;
                break;
            }
            if (!allMatched) break;
            commonPath = commonPath + thisFolder + File.separator;
        }
        return commonPath;
    }

    private static class Finder
    extends SimpleFileVisitor<Path> {
        private final PathMatcher matcher;
        private final Consumer<Path> fileHandler;

        Finder(String pattern, Consumer<Path> fileHandler) {
            this.matcher = new CombinedFilePathMatcher(pattern);
            this.fileHandler = fileHandler;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            Path name = file.getFileName();
            if (this.matcher.matches(file) || name != null && this.matcher.matches(name)) {
                this.fileHandler.accept(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            log.error(String.format("Failed to load %s file", file.toString()), exc);
            return FileVisitResult.CONTINUE;
        }
    }
}

