/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.protobuf;

import com.db.plexus.interop.dsl.protobuf.ProtoLangConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Singleton
public class ProtoLangImportResolver {
    @Inject
    private ProtoLangConfig config;
    @Inject
    protected IResourceDescriptionsProvider resourceDescriptionsProvider;

    public URI resolveURI(ResourceSet resourceSet, String importString) {
        if (importString == null) {
            return null;
        }
        ArrayList<URI> _resolveCandidates = this.getResolveCandidates(importString);
        for (URI resolvedUri : _resolveCandidates) {
            boolean _isValidURI = ProtoLangImportResolver.isValidURI(resourceSet, resolvedUri);
            if (!_isValidURI) continue;
            return resolvedUri;
        }
        return null;
    }

    public Resource resolveResource(ResourceSet resourceSet, String importString) {
        URI uri = this.resolveURI(resourceSet, importString);
        if (uri == null) {
            return null;
        }
        return resourceSet.getResource(uri, true);
    }

    public IResourceDescription resolveResourceDescription(ResourceSet resourceSet, String importString) {
        Resource resource = this.resolveResource(resourceSet, importString);
        if (resource == null) {
            return null;
        }
        return this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet).getResourceDescription(resource.getURI());
    }

    public List<URI> importCandidates(Resource resource) {
        Predicate<Resource> _function = x -> {
            boolean _equals = x.equals(resource);
            return !_equals;
        };
        Function<Resource, Stream> _function_1 = res -> {
            Function<URI, URI> _function_2 = url -> this.deresolve((URI)url, res.getURI());
            return this.config.getBaseURIs().stream().map(_function_2);
        };
        Predicate<URI> _function_2 = uri -> {
            boolean _hasAbsolutePath = uri.hasAbsolutePath();
            return !_hasAbsolutePath;
        };
        return resource.getResourceSet().getResources().stream().filter(_function).flatMap(_function_1).filter(_function_2).collect(Collectors.toList());
    }

    public URI deresolve(URI base, URI uri) {
        URI normalizedBase = URI.createURI(URI.decode(base.toString()));
        URI normalizedUri = URI.createURI(URI.decode(uri.toString()));
        return normalizedUri.deresolve(normalizedBase);
    }

    public ArrayList<URI> getResolveCandidates(String importString) {
        ArrayList<URI> result = new ArrayList<URI>();
        URI uri = URI.createURI(importString);
        List<URI> _baseURIs = this.config.getBaseURIs();
        for (URI root : _baseURIs) {
            try {
                URI resolvedUri = uri.resolve(root);
                result.add(resolvedUri);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception exception = (Exception)_t;
                    continue;
                }
                throw Exceptions.sneakyThrow(_t);
            }
        }
        try {
            boolean _not;
            URI resolvedUri_1 = URI.createURI(ClassLoader.getSystemClassLoader().getResource(importString).toURI().toString());
            boolean _contains = result.contains(resolvedUri_1);
            boolean bl = _not = !_contains;
            if (_not) {
                result.add(resolvedUri_1);
            }
        }
        catch (Throwable _t_1) {
            if (_t_1 instanceof Exception) {
                Exception exception = (Exception)_t_1;
            }
            throw Exceptions.sneakyThrow(_t_1);
        }
        return result;
    }

    private static boolean isValidURI(ResourceSet resourceSet, URI uri) {
        if (uri == null || uri.isEmpty()) {
            return false;
        }
        try {
            boolean _tripleNotEquals;
            Resource _resource = resourceSet.getResource(uri, false);
            boolean bl = _tripleNotEquals = _resource != null;
            if (_tripleNotEquals) {
                return true;
            }
            URIConverter uriConverter = resourceSet.getURIConverter();
            URI normalized = uriConverter.normalize(uri);
            if (normalized != null) {
                if ("platform".equals(normalized.scheme()) && !normalized.isPlatform()) {
                    return false;
                }
                return uriConverter.exists(normalized, Collections.emptyMap());
            }
        }
        catch (Throwable _t) {
            if (_t instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)_t;
            }
            throw Exceptions.sneakyThrow(_t);
        }
        return false;
    }
}

