/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.protobuf;

import com.db.plexus.interop.dsl.protobuf.Enum;
import com.db.plexus.interop.dsl.protobuf.EnumValue;
import com.db.plexus.interop.dsl.protobuf.Field;
import com.db.plexus.interop.dsl.protobuf.Message;
import com.db.plexus.interop.dsl.protobuf.Method;
import com.db.plexus.interop.dsl.protobuf.Option;
import com.db.plexus.interop.dsl.protobuf.Proto;
import com.db.plexus.interop.dsl.protobuf.ProtoLangImportResolver;
import com.db.plexus.interop.dsl.protobuf.ProtobufPackage;
import com.db.plexus.interop.dsl.protobuf.Service;
import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
public class ProtoLangUtils {
    public static final String DESCRIPTOR_RESOURCE_PATH = "google/protobuf/descriptor.proto";
    public static final QualifiedName DESCRIPTOR_PACKAGE_NAME = QualifiedName.create("", "google", "protobuf");
    @Inject
    protected IResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    protected ProtoLangImportResolver importResolver;
    @Inject
    protected IQualifiedNameProvider qualifiedNameProvider;

    public Message getDescriptorsContainer(Option option) {
        QualifiedName name = ProtoLangUtils.getDescriptorContainerName(option);
        if (name == null) {
            return null;
        }
        ResourceSet resourceSet = option.eResource().getResourceSet();
        IResourceDescription description = this.getDescriptorResourceDescription(resourceSet);
        boolean _equals = Objects.equal(description, null);
        if (_equals) {
            Resource descriptorResource = this.importResolver.resolveResource(resourceSet, DESCRIPTOR_RESOURCE_PATH);
            Functions.Function1<Message, Boolean> _function = m3 -> name.equals(this.qualifiedNameProvider.getFullyQualifiedName((EObject)m3));
            Message message = IteratorExtensions.findFirst(Iterators.filter(descriptorResource.getAllContents(), Message.class), _function);
            return message;
        }
        Functions.Function1<IEObjectDescription, Boolean> _function_1 = x -> true;
        EObject _eObjectOrProxy = IterableExtensions.findFirst(description.getExportedObjects(ProtobufPackage.Literals.MESSAGE, name, false), _function_1).getEObjectOrProxy();
        return (Message)_eObjectOrProxy;
    }

    public IResourceDescription getDescriptorResourceDescription(ResourceSet resourceSet) {
        return this.importResolver.resolveResourceDescription(resourceSet, DESCRIPTOR_RESOURCE_PATH);
    }

    private static QualifiedName getDescriptorContainerName(Option option) {
        String shortName = ProtoLangUtils.getOptionDescriptorMessageName(option.eContainer());
        if (shortName == null) {
            return null;
        }
        return DESCRIPTOR_PACKAGE_NAME.append(shortName);
    }

    private static String getOptionDescriptorMessageName(EObject container) {
        String _switchResult = null;
        boolean _matched = false;
        if (container instanceof Proto) {
            _matched = true;
            _switchResult = "FileOptions";
        }
        if (!_matched && container instanceof Message) {
            _matched = true;
            _switchResult = "MessageOptions";
        }
        if (!_matched && container instanceof Field) {
            _matched = true;
            _switchResult = "FieldOptions";
        }
        if (!_matched && container instanceof Service) {
            _matched = true;
            _switchResult = "ServiceOptions";
        }
        if (!_matched && container instanceof Method) {
            _matched = true;
            _switchResult = "MethodOptions";
        }
        if (!_matched && container instanceof Enum) {
            _matched = true;
            _switchResult = "EnumOptions";
        }
        if (!_matched && container instanceof EnumValue) {
            _matched = true;
            _switchResult = "EnumValueOptions";
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }
}

