/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.protobuf.scoping;

import com.db.plexus.interop.dsl.protobuf.Import;
import com.db.plexus.interop.dsl.protobuf.ImportModifier;
import com.db.plexus.interop.dsl.protobuf.ProtoLangImportResolver;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.Conversions;

public class ProtoLangGlobalScopeProvider
extends ImportUriGlobalScopeProvider {
    @Inject
    private ProtoLangImportResolver importResolver;

    @Override
    public IAcceptor<String> createURICollector(Resource resource, Set<URI> collectInto) {
        return new ImportCollector(resource, collectInto, this.importResolver);
    }

    public static class ImportCollector
    implements IAcceptor<String> {
        private Resource resource;
        private Set<URI> result;
        private ProtoLangImportResolver importResolver;

        public ImportCollector(Resource resource, Set<URI> result, ProtoLangImportResolver importResolver) {
            this.resource = resource;
            this.result = result;
            this.importResolver = importResolver;
        }

        public void addTransitiveImports(URI uri) {
            boolean _equals;
            boolean _contains = this.result.contains(uri);
            if (_contains) {
                return;
            }
            this.result.add(uri);
            Resource resource = this.resource.getResourceSet().getResource(uri, true);
            int _length = ((Object[])Conversions.unwrapArray(resource.getContents(), Object.class)).length;
            boolean bl = _equals = _length == 0;
            if (_equals) {
                return;
            }
            Iterable<Import> _filter = Iterables.filter(((EObject)resource.getContents().get(0)).eContents(), Import.class);
            for (Import import_ : _filter) {
                ImportModifier _modifier = import_.getModifier();
                boolean _equals_1 = Objects.equal(_modifier, ImportModifier.PUBLIC);
                if (!_equals_1) continue;
                new ImportCollector(resource, this.result, this.importResolver).accept(import_.getImportURI());
            }
        }

        @Override
        public void accept(String importString) {
            URI resolvedUri = this.importResolver.resolveURI(this.resource.getResourceSet(), importString);
            if (resolvedUri != null) {
                this.addTransitiveImports(resolvedUri);
            }
        }
    }
}

