/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.protobuf.scoping;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.ICaseInsensitivityHelper;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;

public class ProtoLangLocalScopeProvider
extends ImportedNamespaceAwareLocalScopeProvider {
    @Inject
    public ProtoLangLocalScopeProvider(IGlobalScopeProvider globalScopeProvider, IQualifiedNameProvider qualifiedNameProvider, IQualifiedNameConverter qualifiedNameConverter, ICaseInsensitivityHelper caseInsensitivityHelper) {
        super(globalScopeProvider, qualifiedNameProvider, qualifiedNameConverter, caseInsensitivityHelper);
    }

    @Override
    public IScope getScope(EObject context, EReference reference) {
        QualifiedName contextName = this.getQualifiedNameProvider().getFullyQualifiedName(context);
        if (contextName == null) {
            return this.getScope(context.eContainer(), reference);
        }
        IScope globalScope = this.getResourceScope(context.eResource(), reference);
        IQualifiedNameProvider _qualifiedNameProvider = this.getQualifiedNameProvider();
        ProtoLangScope scope = new ProtoLangScope(globalScope, contextName, _qualifiedNameProvider);
        return scope;
    }

    public static class ProtoLangScope
    implements IScope {
        private QualifiedName contextName;
        private IScope globalScope;
        private HashMap<String, Integer> segmentMap = new HashMap();
        private IQualifiedNameProvider qualifiedNameProvider;

        public ProtoLangScope(IScope globalScope, QualifiedName contextName, IQualifiedNameProvider qualifiedNameProvider) {
            this.globalScope = globalScope;
            this.contextName = contextName;
            for (int i = 0; i < contextName.getSegmentCount(); ++i) {
                this.segmentMap.put(contextName.getSegment(i), i);
            }
            this.qualifiedNameProvider = qualifiedNameProvider;
        }

        @Override
        public Iterable<IEObjectDescription> getAllElements() {
            ArrayList<IEObjectDescription> result = new ArrayList<IEObjectDescription>();
            Iterable<IEObjectDescription> _allElements = this.globalScope.getAllElements();
            for (IEObjectDescription elem : _allElements) {
                result.add(elem);
                int _segmentCount = this.contextName.getSegmentCount();
                int _segmentCount_1 = elem.getName().getSegmentCount();
                int _minus = _segmentCount_1 - 1;
                int maxPrefixLength = Math.min(_segmentCount, _minus);
                int i = 0;
                while (i < maxPrefixLength && this.contextName.getSegment(i).equals(elem.getName().getSegment(i))) {
                    QualifiedName suffix = elem.getName().skipFirst(++i);
                    Integer _orDefault = this.segmentMap.getOrDefault(suffix.getFirstSegment(), i);
                    boolean _equals = _orDefault == i;
                    if (!_equals) continue;
                    result.add(EObjectDescription.create(suffix, elem.getEObjectOrProxy()));
                }
            }
            return result;
        }

        @Override
        public Iterable<IEObjectDescription> getElements(QualifiedName name) {
            IEObjectDescription candidate = this.getSingleElement(name);
            if (candidate != null) {
                return Collections.singleton(candidate);
            }
            return Collections.emptySet();
        }

        @Override
        public Iterable<IEObjectDescription> getElements(EObject object) {
            QualifiedName name = this.qualifiedNameProvider.getFullyQualifiedName(object);
            if (name == null) {
                return this.getElements(object.eContainer());
            }
            return this.getElements(name);
        }

        @Override
        public IEObjectDescription getSingleElement(QualifiedName name) {
            IEObjectDescription _xblockexpression = null;
            Integer prefixIndex = this.segmentMap.getOrDefault(name.getFirstSegment(), -1);
            IEObjectDescription _xifexpression = null;
            if (prefixIndex == -1) {
                for (int i = 0; i <= this.contextName.getSegmentCount(); ++i) {
                    QualifiedName newName = this.contextName.skipLast(i).append(name);
                    IEObjectDescription candidate = this.globalScope.getSingleElement(newName);
                    if (candidate == null) continue;
                    return EObjectDescription.create(name, candidate.getEObjectOrProxy());
                }
            } else {
                int _segmentCount = this.contextName.getSegmentCount();
                int _minus = _segmentCount - prefixIndex;
                QualifiedName newName = this.contextName.skipLast(_minus).append(name);
                return this.globalScope.getSingleElement(newName);
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        @Override
        public IEObjectDescription getSingleElement(EObject object) {
            QualifiedName name = this.qualifiedNameProvider.getFullyQualifiedName(object);
            if (name == null) {
                return this.getSingleElement(object.eContainer());
            }
            return this.getSingleElement(name);
        }
    }
}

