/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.validation;

import com.db.plexus.interop.dsl.ConsumedMethod;
import com.db.plexus.interop.dsl.DslPackage;
import com.db.plexus.interop.dsl.ProvidedMethod;
import com.db.plexus.interop.dsl.validation.AbstractInteropLangValidator;
import java.util.List;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;

public class InteropLangValidator
extends AbstractInteropLangValidator {
    @Override
    public boolean isLanguageSpecific() {
        return false;
    }

    @Check
    public void checkUniqueConsumedMethod(ConsumedMethod consumedMethod) {
        List<ConsumedMethod> _siblingsOfType = EcoreUtil2.getSiblingsOfType(consumedMethod, ConsumedMethod.class);
        for (ConsumedMethod otherConsumedMethod : _siblingsOfType) {
            boolean _equals = otherConsumedMethod.getMethod().equals(consumedMethod.getMethod());
            if (!_equals) continue;
            String _name = consumedMethod.getMethod().getName();
            String _plus = "Duplicated consumed method definition: " + _name;
            this.error(_plus, DslPackage.Literals.CONSUMED_METHOD__METHOD);
        }
    }

    @Check
    public void checkUniqueProvidedMethod(ProvidedMethod providedMethod) {
        List<ProvidedMethod> _siblingsOfType = EcoreUtil2.getSiblingsOfType(providedMethod, ProvidedMethod.class);
        for (ProvidedMethod otherProvidedMethod : _siblingsOfType) {
            boolean _equals = otherProvidedMethod.getMethod().equals(providedMethod.getMethod());
            if (!_equals) continue;
            String _name = providedMethod.getMethod().getName();
            String _plus = "Duplicated provided method definition: " + _name;
            this.error(_plus, DslPackage.Literals.PROVIDED_METHOD__METHOD);
        }
    }
}

