/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.validation.rules;

import com.db.plexus.interop.dsl.gen.GenUtils;
import com.db.plexus.interop.dsl.protobuf.Method;
import com.db.plexus.interop.dsl.validation.Issues;
import com.db.plexus.interop.dsl.validation.rules.UpdateRule;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class NoMethodTypesChangedRule
implements UpdateRule {
    private final GenUtils genUtils;

    @Inject
    public NoMethodTypesChangedRule(GenUtils genUtils) {
        this.genUtils = genUtils;
    }

    @Override
    public String getCode() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("service-method-updated");
        return _builder.toString();
    }

    @Override
    public List<Issue> validate(XtextResourceSet baseResourceSet, XtextResourceSet updatedResourceSet) {
        Map<String, Method> baseMethods = this.genUtils.getServiceMethodsMap((Resource[])Conversions.unwrapArray(baseResourceSet.getResources(), Resource.class));
        Map<String, Method> updatedMethods = this.genUtils.getServiceMethodsMap((Resource[])Conversions.unwrapArray(updatedResourceSet.getResources(), Resource.class));
        Set<String> updatedIds = updatedMethods.keySet();
        Functions.Function1<Map.Entry, Boolean> _function = methodEntry -> updatedIds.contains(methodEntry.getKey());
        Functions.Function1<Map.Entry, Boolean> _function_1 = baseMethodEntry -> {
            boolean _methodsEqual = this.methodsEqual((Method)baseMethodEntry.getValue(), (Method)updatedMethods.get(baseMethodEntry.getKey()));
            return !_methodsEqual;
        };
        Functions.Function1<Map.Entry, Issue> _function_2 = methodEntry -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Service Method ");
            String _key = (String)methodEntry.getKey();
            _builder.append(_key);
            _builder.append(" is updated");
            return Issues.createError(_builder.toString(), this.getCode());
        };
        return IterableExtensions.toList(IterableExtensions.map(IterableExtensions.filter(IterableExtensions.filter(baseMethods.entrySet(), _function), _function_1), _function_2));
    }

    public boolean methodsEqual(Method first, Method second) {
        boolean _not_3;
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        boolean _equals = this.genUtils.getFullName(first.getRequest().getMessage()).equals(this.genUtils.getFullName(second.getRequest().getMessage()));
        boolean bl = _not = !_equals;
        if (_not) {
            return false;
        }
        boolean _equals_1 = first.getRequest().getIsStream().equals(second.getRequest().getIsStream());
        boolean bl2 = _not_1 = !_equals_1;
        if (_not_1) {
            return false;
        }
        boolean _equals_2 = this.genUtils.getFullName(first.getResponse().getMessage()).equals(this.genUtils.getFullName(second.getResponse().getMessage()));
        boolean bl3 = _not_2 = !_equals_2;
        if (_not_2) {
            return false;
        }
        boolean _equals_3 = first.getResponse().getIsStream().equals(second.getResponse().getIsStream());
        boolean bl4 = _not_3 = !_equals_3;
        return !_not_3;
    }
}

