/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import java.lang.reflect.Type;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;

public class ClassURIHelper
implements URIHelperConstants {
    private StringBuilder createURIBuilder() {
        StringBuilder builder = new StringBuilder(48);
        builder.append("java");
        builder.append(':');
        return builder;
    }

    private URI createURI(StringBuilder uriBuilder) {
        return URI.createURI(uriBuilder.toString());
    }

    public URI getFullURI(Type type) {
        StringBuilder uriBuilder = this.createURIBuilder();
        this.createResourceURI(type, uriBuilder);
        uriBuilder.append('#');
        this.createFragment(type, uriBuilder);
        return this.createURI(uriBuilder);
    }

    private void createFragment(Type type, StringBuilder uriBuilder) {
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException("Unexpected type: " + type);
        }
        Class clazz = (Class)type;
        this.createFragmentForClass(clazz, uriBuilder);
    }

    private void createFragmentForClass(Class<?> clazz, StringBuilder uriBuilder) {
        if (clazz.isArray()) {
            this.createFragmentForClass(clazz.getComponentType(), uriBuilder);
            uriBuilder.append("[]");
        } else {
            uriBuilder.append(clazz.getName());
        }
    }

    private void createResourceURI(Type type, StringBuilder uriBuilder) {
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException("unexpected type: " + type);
        }
        Class clazz = (Class)type;
        this.createResourceURIForClass(clazz, uriBuilder);
    }

    private void createResourceURIForClass(Class<?> clazz, StringBuilder uriBuilder) {
        if (clazz.isArray()) {
            this.createResourceURIForClass(clazz.getComponentType(), uriBuilder);
        } else if (clazz.isMemberClass()) {
            this.createResourceURIForClass(clazz.getDeclaringClass(), uriBuilder);
        } else if (clazz.isPrimitive()) {
            uriBuilder.append("/Primitives");
        } else {
            uriBuilder.append("/Objects/").append(clazz.getName());
        }
    }
}

