/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ecore;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.ecore.NsURIQualifiedNameProvider;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;

@Singleton
public class EcoreResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    private static final Logger LOG = Logger.getLogger(EcoreResourceDescriptionStrategy.class);
    public static final String NS_URI_INDEX_ENTRY = "nsURI";
    @Inject
    private NsURIQualifiedNameProvider nsURIQualifiedNameProvider;

    @Override
    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        boolean isProcessContents = this.createEObjectDescriptions(this.getQualifiedNameProvider(), false, eObject, acceptor);
        return isProcessContents |= this.createEObjectDescriptions(this.nsURIQualifiedNameProvider, true, eObject, acceptor);
    }

    protected boolean createEObjectDescriptions(IQualifiedNameProvider qualifiedNameProvider, boolean isNsURI, EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        try {
            QualifiedName qualifiedName = qualifiedNameProvider.getFullyQualifiedName(eObject);
            if (qualifiedName != null) {
                HashMap<String, String> userData = Maps.newHashMapWithExpectedSize(1);
                userData.put(NS_URI_INDEX_ENTRY, Boolean.toString(isNsURI));
                IEObjectDescription description = EObjectDescription.create(qualifiedName, eObject, userData);
                acceptor.accept(description);
                return true;
            }
        }
        catch (Exception exc) {
            LOG.error(exc.getMessage(), exc);
        }
        return false;
    }
}

