/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.xtext.formatting2.debug.TextRegionsWithTitleToString;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.util.Pair;

public class RegionsOutsideFrameException
extends RuntimeException {
    private static final long serialVersionUID = 3957771424755606694L;
    private final ITextSegment frameRegion;
    private final String frameTitle;
    private final Pair<String, ITextSegment>[] regions;

    @SafeVarargs
    public RegionsOutsideFrameException(String title, ITextSegment frame, Pair<String, ITextSegment> ... regions) {
        this.frameTitle = title;
        this.frameRegion = frame;
        this.regions = regions;
    }

    @Override
    public String getMessage() {
        String regionsStr;
        if (this.regions.length == 1) {
            regionsStr = "region " + this.regions[0].getFirst();
        } else {
            ArrayList<String> titles = Lists.newArrayList();
            for (Pair<String, ITextSegment> p : this.regions) {
                titles.add(p.getFirst());
            }
            regionsStr = "regions " + Joiner.on(", ").join(titles);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("The " + regionsStr + " must not be outside " + this.frameTitle + ".\n");
        TextRegionsWithTitleToString toStr = new TextRegionsWithTitleToString();
        toStr.add(this.frameTitle, this.frameRegion);
        for (Pair<String, ITextSegment> p : this.regions) {
            toStr.add(p.getFirst(), p.getSecond());
        }
        builder.append(toStr);
        return builder.toString();
    }
}

