/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.impl;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.IDiagnosticProducer;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.impl.AbstractCleaningLinker;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.LinkingDiagnosticProducer;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class Linker
extends AbstractCleaningLinker {
    private static Logger log = Logger.getLogger(Linker.class);
    @Inject
    private ILinkingService linkingService;
    @Inject
    private ILinkingDiagnosticMessageProvider.Extended diagnosticMessageProvider;
    @Inject
    private LinkingHelper linkingHelper;

    public void ensureLinked(EObject obj, IDiagnosticProducer producer) {
        ICompositeNode node = NodeModelUtils.getNode(obj);
        if (node == null) {
            return;
        }
        HashSet<EReference> handledReferences = new HashSet<EReference>();
        this.ensureLinked(obj, producer, node, handledReferences, false);
        producer.setNode(node);
        this.setDefaultValues(obj, handledReferences, producer);
    }

    private void ensureLinked(EObject obj, IDiagnosticProducer producer, ICompositeNode node, Set<EReference> handledReferences, boolean dontCheckParent) {
        for (INode abstractNode = node.getFirstChild(); abstractNode != null; abstractNode = abstractNode.getNextSibling()) {
            RuleCall ruleCall;
            AbstractRule calledRule;
            EObject grammarElement = abstractNode.getGrammarElement();
            if (grammarElement instanceof CrossReference) {
                CrossReference ref = (CrossReference)grammarElement;
                producer.setNode(abstractNode);
                this.ensureIsLinked(obj, abstractNode, ref, handledReferences, producer);
                continue;
            }
            if (!(grammarElement instanceof RuleCall) || !(abstractNode instanceof ICompositeNode) || !((calledRule = (ruleCall = (RuleCall)grammarElement).getRule()) instanceof ParserRule) || !((ParserRule)calledRule).isFragment()) continue;
            this.ensureLinked(obj, producer, (ICompositeNode)abstractNode, handledReferences, true);
        }
        if (!dontCheckParent && this.shouldCheckParentNode(node)) {
            this.ensureLinked(obj, producer, node.getParent(), handledReferences, false);
        }
    }

    protected IDiagnosticProducer createDiagnosticProducer(IDiagnosticConsumer consumer) {
        return new LinkingDiagnosticProducer(consumer);
    }

    private void setDefaultValues(EObject obj, Set<EReference> references, IDiagnosticProducer producer) {
        for (EReference ref : obj.eClass().getEAllReferences()) {
            if (!this.canSetDefaultValues(ref) || references.contains(ref) || obj.eIsSet(ref) || ref.isDerived()) continue;
            this.setDefaultValue(obj, ref, producer);
        }
    }

    protected boolean canSetDefaultValues(EReference ref) {
        return !ref.isContainment() && !ref.isContainer() && ref.isChangeable();
    }

    protected final void setDefaultValue(EObject obj, EReference ref, IDiagnosticProducer producer) {
        producer.setTarget(obj, ref);
        this.setDefaultValueImpl(obj, ref, producer);
    }

    protected void setDefaultValueImpl(EObject obj, EReference ref, IDiagnosticProducer producer) {
    }

    protected void beforeEnsureIsLinked(EObject obj, EReference ref, IDiagnosticProducer producer) {
    }

    protected void ensureIsLinked(EObject obj, INode node, CrossReference ref, Set<EReference> handledReferences, IDiagnosticProducer producer) {
        block13: {
            EReference eRef = GrammarUtil.getReference(ref, obj.eClass());
            if (eRef == null) {
                ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticContext(obj, eRef, node);
                DiagnosticMessage message = this.diagnosticMessageProvider.getIllegalCrossReferenceMessage(context, ref);
                producer.addDiagnostic(message);
                return;
            }
            handledReferences.add(eRef);
            this.beforeEnsureIsLinked(obj, eRef, producer);
            producer.setTarget(obj, eRef);
            try {
                List<EObject> links = this.getLinkedObject(obj, eRef, node);
                if (links == null || links.isEmpty()) {
                    if (!this.isNullValidResult(obj, eRef, node)) {
                        ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticContext(obj, eRef, node);
                        DiagnosticMessage message = this.diagnosticMessageProvider.getUnresolvedProxyMessage(context);
                        producer.addDiagnostic(message);
                    }
                    return;
                }
                if (eRef.getUpperBound() >= 0 && links.size() > eRef.getUpperBound()) {
                    ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticContext(obj, eRef, node);
                    DiagnosticMessage message = this.diagnosticMessageProvider.getViolatedBoundsConstraintMessage(context, links.size());
                    producer.addDiagnostic(message);
                    return;
                }
                if (eRef.getUpperBound() == 1) {
                    obj.eSet(eRef, links.get(0));
                } else {
                    List list = (List)obj.eGet(eRef);
                    if (links.size() > 1 && eRef.isUnique() && list instanceof InternalEList) {
                        LinkedHashSet<EObject> addUs = new LinkedHashSet<EObject>(links);
                        for (int i = 0; i < list.size(); ++i) {
                            addUs.remove(list.get(i));
                        }
                        if (!((InternalEList)list).addAllUnique(addUs)) {
                            ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticContext(obj, eRef, node);
                            DiagnosticMessage message = this.diagnosticMessageProvider.getViolatedBoundsConstraintMessage(context, links.size());
                            producer.addDiagnostic(message);
                        }
                    } else if (!list.addAll(links)) {
                        ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticContext(obj, eRef, node);
                        DiagnosticMessage message = this.diagnosticMessageProvider.getViolatedBoundsConstraintMessage(context, links.size());
                        producer.addDiagnostic(message);
                    }
                }
            }
            catch (IllegalNodeException e) {
                ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticContext(obj, eRef, node);
                DiagnosticMessage message = this.diagnosticMessageProvider.getIllegalNodeMessage(context, e);
                producer.addDiagnostic(message);
                if (!log.isDebugEnabled()) break block13;
                log.debug(e.getMessage(), e);
            }
        }
    }

    protected ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext createDiagnosticContext(EObject obj, EReference eRef, INode node) {
        return new LinkingDiagnosticContext(obj, eRef, node, this.linkingHelper);
    }

    protected List<EObject> getLinkedObject(EObject obj, EReference eRef, INode node) throws IllegalNodeException {
        return this.linkingService.getLinkedObjects(obj, eRef, node);
    }

    protected boolean isNullValidResult(EObject obj, EReference eRef, INode node) {
        return false;
    }

    public ILinkingService getLinkingService() {
        return this.linkingService;
    }

    public void setLinkingService(ILinkingService linkingService) {
        this.linkingService = linkingService;
    }

    @Override
    protected void doLinkModel(EObject model, IDiagnosticConsumer consumer) {
        IDiagnosticProducer producer = this.createDiagnosticProducer(consumer);
        this.ensureModelLinked(model, producer);
    }

    protected void ensureModelLinked(EObject model, IDiagnosticProducer producer) {
        boolean clearAllReferencesRequired = this.isClearAllReferencesRequired(model.eResource());
        TreeIterator<EObject> iterator = this.getAllLinkableContents(model);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            if (clearAllReferencesRequired) {
                this.clearReferences(next);
            }
            this.ensureLinked(next, producer);
        }
    }

    public void setDiagnosticMessageProvider(ILinkingDiagnosticMessageProvider.Extended diagnosticMessageProvider) {
        this.diagnosticMessageProvider = diagnosticMessageProvider;
    }

    public ILinkingDiagnosticMessageProvider.Extended getDiagnosticMessageProvider() {
        return this.diagnosticMessageProvider;
    }

    public LinkingHelper getLinkingHelper() {
        return this.linkingHelper;
    }

    public void setLinkingHelper(LinkingHelper linkingHelper) {
        this.linkingHelper = linkingHelper;
    }

    protected static class LinkingDiagnosticContext
    implements ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext {
        private final EObject obj;
        private final EReference eRef;
        private final INode node;
        private final LinkingHelper linkingHelper;

        protected LinkingDiagnosticContext(EObject obj, EReference eRef, INode node, LinkingHelper helper) {
            this.obj = obj;
            this.eRef = eRef;
            this.node = node;
            this.linkingHelper = helper;
        }

        @Override
        public EObject getContext() {
            return this.obj;
        }

        @Override
        public EReference getReference() {
            return this.eRef;
        }

        @Override
        public String getLinkText() {
            return this.linkingHelper.getCrossRefNodeAsString(this.node, true);
        }
    }
}

