/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.containers.ContainerState;
import org.eclipse.xtext.resource.containers.DescriptionAddingContainer;
import org.eclipse.xtext.resource.containers.FlatResourceSetBasedAllContainersState;
import org.eclipse.xtext.resource.containers.IAllContainersState;
import org.eclipse.xtext.resource.containers.ProjectDescriptionBasedContainerManager;
import org.eclipse.xtext.resource.containers.StateBasedContainer;

public class StateBasedContainerManager
implements IContainer.Manager {
    private static final Logger log = Logger.getLogger(StateBasedContainerManager.class);
    @Inject
    private IAllContainersState.Provider stateProvider;
    @Inject
    private ProjectDescriptionBasedContainerManager delegate;

    @Override
    public IContainer getContainer(IResourceDescription desc, IResourceDescriptions resourceDescriptions) {
        if (this.delegate.shouldUseProjectDescriptionBasedContainers(resourceDescriptions)) {
            return this.delegate.getContainer(desc, resourceDescriptions);
        }
        String root = this.internalGetContainerHandle(desc, resourceDescriptions);
        if (root == null) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot find IContainer for: " + desc.getURI());
            }
            return IContainer.NULL_CONTAINER;
        }
        IContainer result = this.createContainer(root, resourceDescriptions);
        if (!result.hasResourceDescription(desc.getURI())) {
            result = new DescriptionAddingContainer(desc, result);
        }
        return result;
    }

    @Override
    public List<IContainer> getVisibleContainers(IResourceDescription desc, IResourceDescriptions resourceDescriptions) {
        IContainer first;
        if (this.delegate.shouldUseProjectDescriptionBasedContainers(resourceDescriptions)) {
            return this.delegate.getVisibleContainers(desc, resourceDescriptions);
        }
        String root = this.internalGetContainerHandle(desc, resourceDescriptions);
        if (root == null) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot find IContainer for: " + desc.getURI());
            }
            return Collections.emptyList();
        }
        List<String> handles = this.getState(resourceDescriptions).getVisibleContainerHandles(root);
        List<IContainer> result = this.getVisibleContainers(handles, resourceDescriptions);
        if (!result.isEmpty() && !(first = result.get(0)).hasResourceDescription(desc.getURI())) {
            first = new DescriptionAddingContainer(desc, first);
            result.set(0, first);
        }
        return result;
    }

    protected IAllContainersState getState(IResourceDescriptions resourceDescriptions) {
        return this.stateProvider.get(resourceDescriptions);
    }

    protected IContainer createContainer(String handle, IResourceDescriptions resourceDescriptions) {
        IAllContainersState state = this.getState(resourceDescriptions);
        ContainerState containerState = new ContainerState(handle, state);
        StateBasedContainer result = new StateBasedContainer(resourceDescriptions, containerState);
        if (state instanceof FlatResourceSetBasedAllContainersState) {
            result.setUriToDescriptionCacheEnabled(false);
        }
        return result;
    }

    protected List<IContainer> getVisibleContainers(List<String> handles, IResourceDescriptions resourceDescriptions) {
        if (handles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IContainer> result = Lists.newArrayListWithExpectedSize(handles.size());
        for (String handle : handles) {
            IContainer container = this.createContainer(handle, resourceDescriptions);
            if (container.isEmpty() && !result.isEmpty()) continue;
            result.add(container);
        }
        return result;
    }

    protected String internalGetContainerHandle(IResourceDescription desc, IResourceDescriptions resourceDescriptions) {
        return this.getState(resourceDescriptions).getContainerHandle(desc.getURI());
    }

    public IAllContainersState.Provider getStateProvider() {
        return this.stateProvider;
    }

    public void setStateProvider(IAllContainersState.Provider stateProvider) {
        this.stateProvider = stateProvider;
    }

    public void setDelegate(ProjectDescriptionBasedContainerManager delegate) {
        this.delegate = delegate;
    }
}

