/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.EObjectDescriptionLookUp;

public abstract class AbstractResourceDescription
implements IResourceDescription {
    protected EObjectDescriptionLookUp lookup;

    @Override
    public boolean isEmpty() {
        return this.getLookUp().isEmpty();
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects() {
        return this.getLookUp().getExportedObjects();
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        return this.getLookUp().getExportedObjectsByType(type);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        return this.getLookUp().getExportedObjectsByObject(object);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
        return this.getLookUp().getExportedObjects(type, name, ignoreCase);
    }

    protected abstract List<IEObjectDescription> computeExportedObjects();

    protected EObjectDescriptionLookUp getLookUp() {
        if (this.lookup == null) {
            this.lookup = new EObjectDescriptionLookUp(this.computeExportedObjects());
        }
        return this.lookup;
    }

    protected URI getNormalizedURI(Resource resource) {
        URIConverter uriConverter;
        URI uri = resource.getURI();
        URIConverter uRIConverter = uriConverter = resource.getResourceSet() != null ? resource.getResourceSet().getURIConverter() : null;
        if (uri != null && uriConverter != null) {
            if (!uri.isPlatform()) {
                return uriConverter.normalize(uri);
            }
            if (uri.isPlatformPlugin()) {
                URI resourceURI = uri.replacePrefix(URI.createURI("platform:/plugin/"), URI.createURI("platform:/resource/"));
                if (uriConverter.normalize(uri).equals(uriConverter.normalize(resourceURI))) {
                    return resourceURI;
                }
            }
        }
        return uri;
    }
}

