/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.base.Objects;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class PortableURIs {
    public static final String PORTABLE_SCHEME = "portable";
    @Inject
    private IGlobalScopeProvider globalScopeProvider;
    @Inject
    private EPackage.Registry packageRegistry;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;

    public boolean isPortableURIFragment(String uriFragment) {
        return uriFragment.startsWith(PORTABLE_SCHEME);
    }

    public EObject resolve(StorageAwareResource resource, String portableFragment) {
        PortableFragmentDescription desc = this.fromFragmentString(portableFragment);
        EReference mock = EcoreFactory.eINSTANCE.createEReference();
        mock.setEType(desc.descriptionEClass);
        IScope scope = this.globalScopeProvider.getScope(resource, mock, Predicates.alwaysTrue());
        IEObjectDescription description = IterableExtensions.head(scope.getElements(desc.descriptionQualifiedName));
        if (description == null) {
            return null;
        }
        EObject container = EcoreUtil.resolve(description.getEObjectOrProxy(), resource);
        return this.getEObject(container, desc.descriptionRelativeFragment);
    }

    public URI toPortableURI(StorageAwareResource sourceResource, URI targetURI) {
        URI result;
        Resource _resource = sourceResource.getResourceSet().getResource(targetURI.trimFragment(), false);
        EObject _eObject = null;
        if (_resource != null) {
            _eObject = _resource.getEObject(targetURI.fragment());
        }
        EObject to = _eObject;
        boolean _or = false;
        if (to == null) {
            _or = true;
        } else {
            boolean _tripleNotEquals;
            Resource _eResource = to.eResource();
            ResourceSet _resourceSet = null;
            if (_eResource != null) {
                _resourceSet = _eResource.getResourceSet();
            }
            _or = _tripleNotEquals = _resourceSet != null;
        }
        if (_or && (result = this.toPortableURI(sourceResource, to)) != null) {
            return result;
        }
        return null;
    }

    public URI toPortableURI(StorageAwareResource sourceResource, EObject targetObject) {
        if (targetObject == null || targetObject.eIsProxy()) {
            return sourceResource.getURI().appendFragment("UNRESOLVABLE");
        }
        String portableFragment = this.getPortableURIFragment(targetObject);
        if (portableFragment != null) {
            return sourceResource.getURI().appendFragment(portableFragment);
        }
        return null;
    }

    protected String getPortableURIFragment(EObject obj) {
        IResourceDescriptions descriptions = this.resourceDescriptionsProvider.getResourceDescriptions(obj.eResource());
        IResourceDescription desc = descriptions.getResourceDescription(obj.eResource().getURI());
        if (desc == null) {
            return null;
        }
        Functions.Function1<IEObjectDescription, Boolean> _function = it -> {
            boolean _xblockexpression = false;
            EObject possibleContainer = EcoreUtil.resolve(it.getEObjectOrProxy(), obj.eResource());
            _xblockexpression = Objects.equal(obj, possibleContainer) || EcoreUtil.isAncestor(obj, possibleContainer);
            return _xblockexpression;
        };
        IEObjectDescription containerDesc = IterableExtensions.findFirst(desc.getExportedObjects(), _function);
        if (containerDesc != null) {
            PortableFragmentDescription fragmentDescription = this.createPortableFragmentDescription(containerDesc, obj);
            return this.toFragmentString(fragmentDescription);
        }
        return null;
    }

    protected PortableFragmentDescription createPortableFragmentDescription(IEObjectDescription desc, EObject target) {
        EObject possibleContainer = EcoreUtil.resolve(desc.getEObjectOrProxy(), target);
        String fragmentToTarget = this.getFragment(target, possibleContainer);
        EClass _eClass = desc.getEClass();
        QualifiedName _qualifiedName = desc.getQualifiedName();
        return new PortableFragmentDescription(_eClass, _qualifiedName, fragmentToTarget);
    }

    protected String toFragmentString(PortableFragmentDescription desc) {
        String eclassUriAsString = URI.encodeFragment(EcoreUtil.getURI(desc.descriptionEClass).toString(), false);
        List<String> segments = desc.descriptionQualifiedName.getSegments();
        String _encodeFragment = URI.encodeFragment(IterableExtensions.join(segments, ":"), false);
        String uriFragment = "portable#" + eclassUriAsString + "#" + _encodeFragment;
        if (desc.descriptionRelativeFragment != null) {
            String _uriFragment = uriFragment;
            String _encodeFragment_1 = URI.encodeFragment(desc.descriptionRelativeFragment, false);
            String _plus = "#" + _encodeFragment_1;
            uriFragment = _uriFragment + _plus;
        }
        return uriFragment;
    }

    protected PortableFragmentDescription fromFragmentString(String fragmentString) {
        Iterator<String> segments = Splitter.on("#").split(fragmentString).iterator();
        segments.next();
        URI eClassURI = URI.createURI(URI.decode(segments.next()));
        EPackage ePackage = this.packageRegistry.getEPackage(eClassURI.trimFragment().toString());
        Resource _eResource = null;
        if (ePackage != null) {
            _eResource = ePackage.eResource();
        }
        EObject _eObject = null;
        if (_eResource != null) {
            _eObject = _eResource.getEObject(eClassURI.fragment());
        }
        EClass eClass = (EClass)_eObject;
        QualifiedName qname = QualifiedName.create(IterableExtensions.toList(Splitter.on(":").split(URI.decode(segments.next()))));
        String _xifexpression = null;
        boolean _hasNext = segments.hasNext();
        if (_hasNext) {
            _xifexpression = URI.decode(segments.next());
        }
        String fragment = _xifexpression;
        EClass _elvis = null;
        _elvis = eClass != null ? eClass : EcorePackage.Literals.EOBJECT;
        return new PortableFragmentDescription(_elvis, qname, fragment);
    }

    public String getFragment(EObject fromContainer, EObject toChild) {
        boolean _equals = Objects.equal(fromContainer, toChild);
        if (_equals) {
            return null;
        }
        InternalEObject lastChild = (InternalEObject)toChild;
        InternalEObject lastContainer = lastChild.eInternalContainer();
        String result = lastContainer.eURIFragmentSegment(lastChild.eContainingFeature(), lastChild);
        while (lastContainer != null && !Objects.equal(fromContainer, lastContainer)) {
            String _plus_1;
            lastChild = lastContainer;
            if ((lastContainer = lastContainer.eInternalContainer()) == null) {
                throw new IllegalStateException("No more containers for element " + lastChild);
            }
            String _eURIFragmentSegment = lastContainer.eURIFragmentSegment(lastChild.eContainingFeature(), lastChild);
            String _plus = _eURIFragmentSegment + "/";
            result = _plus_1 = _plus + result;
        }
        return result;
    }

    public EObject getEObject(EObject from, String toFragment) {
        if (toFragment == null) {
            return from;
        }
        Iterable<String> splitted = Splitter.on("/").split(toFragment);
        Functions.Function2<EObject, String, EObject> _function = ($0, $1) -> ((InternalEObject)$0).eObjectForURIFragmentSegment((String)$1);
        return IterableExtensions.fold(splitted, from, _function);
    }

    @Data
    public static class PortableFragmentDescription {
        private final EClass descriptionEClass;
        private final QualifiedName descriptionQualifiedName;
        private final String descriptionRelativeFragment;

        public PortableFragmentDescription(EClass descriptionEClass, QualifiedName descriptionQualifiedName, String descriptionRelativeFragment) {
            this.descriptionEClass = descriptionEClass;
            this.descriptionQualifiedName = descriptionQualifiedName;
            this.descriptionRelativeFragment = descriptionRelativeFragment;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.descriptionEClass == null ? 0 : this.descriptionEClass.hashCode());
            result = 31 * result + (this.descriptionQualifiedName == null ? 0 : this.descriptionQualifiedName.hashCode());
            result = 31 * result + (this.descriptionRelativeFragment == null ? 0 : this.descriptionRelativeFragment.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortableFragmentDescription other = (PortableFragmentDescription)obj;
            if (this.descriptionEClass == null ? other.descriptionEClass != null : !this.descriptionEClass.equals(other.descriptionEClass)) {
                return false;
            }
            if (this.descriptionQualifiedName == null ? other.descriptionQualifiedName != null : !this.descriptionQualifiedName.equals(other.descriptionQualifiedName)) {
                return false;
            }
            return !(this.descriptionRelativeFragment == null ? other.descriptionRelativeFragment != null : !this.descriptionRelativeFragment.equals(other.descriptionRelativeFragment));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder(this);
            b.add("descriptionEClass", this.descriptionEClass);
            b.add("descriptionQualifiedName", this.descriptionQualifiedName);
            b.add("descriptionRelativeFragment", this.descriptionRelativeFragment);
            return b.toString();
        }

        @Pure
        public EClass getDescriptionEClass() {
            return this.descriptionEClass;
        }

        @Pure
        public QualifiedName getDescriptionQualifiedName() {
            return this.descriptionQualifiedName;
        }

        @Pure
        public String getDescriptionRelativeFragment() {
            return this.descriptionRelativeFragment;
        }
    }
}

