/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.ResourceSetReferencingResourceSet;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.GlobalResourceDescriptionProvider;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;

public class ResourceSetGlobalScopeProvider
extends AbstractGlobalScopeProvider {
    @Inject
    private GlobalResourceDescriptionProvider resourceDecriptionProvider;

    public void setGlobalResourceDecriptionProvider(GlobalResourceDescriptionProvider resourceDecriptionProvider) {
        this.resourceDecriptionProvider = resourceDecriptionProvider;
    }

    @Override
    protected IScope getScope(Resource resource, boolean ignoreCase, EClass type, Predicate<IEObjectDescription> filter) {
        IScope parent = IScope.NULLSCOPE;
        if (resource == null || resource.getResourceSet() == null) {
            return parent;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet instanceof ResourceSetReferencingResourceSet) {
            ResourceSetReferencingResourceSet set = (ResourceSetReferencingResourceSet)resourceSet;
            List<ResourceSet> referencedSets = Lists.reverse(set.getReferencedResourceSets());
            for (ResourceSet referencedSet : referencedSets) {
                parent = this.createScopeWithQualifiedNames(parent, resource, filter, referencedSet, type, ignoreCase);
            }
        }
        return this.createScopeWithQualifiedNames(parent, resource, filter, resourceSet, type, ignoreCase);
    }

    protected IScope createScopeWithQualifiedNames(IScope parent, Resource resource, Predicate<IEObjectDescription> filter, ResourceSet resourceSet, EClass type, boolean ignoreCase) {
        final Iterable<ISelectable> resourceDescriptions = Iterables.transform(resourceSet.getResources(), new Function<Resource, ISelectable>(){

            @Override
            public ISelectable apply(Resource from) {
                return ResourceSetGlobalScopeProvider.this.resourceDecriptionProvider.getResourceDescription(from);
            }
        });
        ISelectable compound = new ISelectable(){

            @Override
            public boolean isEmpty() {
                for (ISelectable description : resourceDescriptions) {
                    if (description.isEmpty()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Iterable<IEObjectDescription> getExportedObjectsByType(final EClass type) {
                return Iterables.concat(Iterables.transform(resourceDescriptions, new Function<ISelectable, Iterable<IEObjectDescription>>(){

                    @Override
                    public Iterable<IEObjectDescription> apply(ISelectable from) {
                        return from.getExportedObjectsByType(type);
                    }
                }));
            }

            @Override
            public Iterable<IEObjectDescription> getExportedObjectsByObject(final EObject object) {
                return Iterables.concat(Iterables.transform(resourceDescriptions, new Function<ISelectable, Iterable<IEObjectDescription>>(){

                    @Override
                    public Iterable<IEObjectDescription> apply(ISelectable from) {
                        return from.getExportedObjectsByObject(object);
                    }
                }));
            }

            @Override
            public Iterable<IEObjectDescription> getExportedObjects(final EClass type, final QualifiedName name, final boolean ignoreCase) {
                return Iterables.concat(Iterables.transform(resourceDescriptions, new Function<ISelectable, Iterable<IEObjectDescription>>(){

                    @Override
                    public Iterable<IEObjectDescription> apply(ISelectable from) {
                        return from.getExportedObjects(type, name, ignoreCase);
                    }
                }));
            }

            @Override
            public Iterable<IEObjectDescription> getExportedObjects() {
                return Iterables.concat(Iterables.transform(resourceDescriptions, new Function<ISelectable, Iterable<IEObjectDescription>>(){

                    @Override
                    public Iterable<IEObjectDescription> apply(ISelectable from) {
                        return from.getExportedObjects();
                    }
                }));
            }
        };
        return SelectableBasedScope.createScope(parent, compound, filter, type, ignoreCase);
    }
}

