/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.service;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.xtext.service.BindModule;
import org.eclipse.xtext.service.CompoundModule;
import org.eclipse.xtext.service.FreeModule;
import org.eclipse.xtext.service.ProviderModule;

public abstract class AbstractGenericModule
implements Module {
    private static Logger LOGGER = Logger.getLogger(AbstractGenericModule.class);

    @Override
    public void configure(Binder binder) {
        CompoundModule compound = this.getBindings();
        compound.configure(binder);
    }

    public final CompoundModule getBindings() {
        Method[] methods = this.getClass().getMethods();
        CompoundModule result = new CompoundModule();
        for (Method method : methods) {
            try {
                if (method.getName().startsWith("bind")) {
                    result.add(new BindModule(method, this));
                    continue;
                }
                if (method.getName().startsWith("provide")) {
                    result.add(new ProviderModule(method, this));
                    continue;
                }
                if (!method.getName().startsWith("configure") || method.getName().equals("configure") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(Binder.class)) continue;
                result.add(new FreeModule(method, this));
            }
            catch (Exception e) {
                LOGGER.warn("Trying to use method " + method.toGenericString() + " for configuration failed", e);
            }
        }
        return result;
    }

    protected void bindProperties(Binder binder, String propertyFilePath) {
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(propertyFilePath);
            if (in == null) {
                throw new IllegalStateException("Couldn't find property file : " + propertyFilePath);
            }
            Properties properties = new Properties();
            properties.load(in);
            Names.bindProperties(binder, properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Properties tryBindProperties(Binder binder, String propertyFilePath) {
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(propertyFilePath);
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                Names.bindProperties(binder, properties);
                return properties;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

