/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.IDiagnosticConverter;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.impl.ConcreteSyntaxEValidator;

public class ResourceValidatorImpl
implements IResourceValidator {
    private static final Logger log = Logger.getLogger(ResourceValidatorImpl.class);
    @Inject
    private Diagnostician diagnostician;
    @Inject
    private IDiagnosticConverter converter;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Issue> validate(Resource resource, CheckMode mode, CancelIndicator mon) throws OperationCanceledError {
        Stopwatches.StoppedTask task = Stopwatches.forTask("ResourceValidatorImpl.validation");
        try {
            task.start();
            CancelIndicator monitor = mon == null ? CancelIndicator.NullImpl : mon;
            this.resolveProxies(resource, monitor);
            this.operationCanceledManager.checkCanceled(monitor);
            ArrayList<Issue> result = Lists.newArrayListWithExpectedSize(resource.getErrors().size() + resource.getWarnings().size());
            try {
                IAcceptor<Issue> acceptor = this.createAcceptor(result);
                if (mode.shouldCheck(CheckType.FAST)) {
                    this.collectResourceDiagnostics(resource, monitor, acceptor);
                }
                this.operationCanceledManager.checkCanceled(monitor);
                boolean syntaxDiagFail = !result.isEmpty();
                this.logCheckStatus(resource, syntaxDiagFail, "Syntax");
                this.validate(resource, mode, monitor, acceptor);
                this.operationCanceledManager.checkCanceled(monitor);
            }
            catch (RuntimeException e) {
                this.operationCanceledManager.propagateAsErrorIfCancelException(e);
                log.error(e.getMessage(), e);
            }
            ArrayList<Issue> arrayList = result;
            return arrayList;
        }
        finally {
            task.stop();
        }
    }

    protected void collectResourceDiagnostics(Resource resource, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        int i;
        for (i = 0; i < resource.getErrors().size(); ++i) {
            this.operationCanceledManager.checkCanceled(monitor);
            this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getErrors().get(i), Severity.ERROR, acceptor);
        }
        for (i = 0; i < resource.getWarnings().size(); ++i) {
            this.operationCanceledManager.checkCanceled(monitor);
            this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getWarnings().get(i), Severity.WARNING, acceptor);
        }
    }

    protected void validate(Resource resource, CheckMode mode, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        for (EObject ele : resource.getContents()) {
            this.operationCanceledManager.checkCanceled(monitor);
            this.validate(resource, ele, mode, monitor, acceptor);
        }
    }

    protected void validate(Resource resource, EObject element, CheckMode mode, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        try {
            Diagnostic diagnostic;
            HashMap<Object, Object> options = Maps.newHashMap();
            options.put("check.mode", mode);
            options.put(CancelableDiagnostician.CANCEL_INDICATOR, monitor);
            options.put(ConcreteSyntaxEValidator.DISABLE_CONCRETE_SYNTAX_EVALIDATOR, Boolean.TRUE);
            options.put(EValidator.class, this.diagnostician);
            if (resource instanceof XtextResource) {
                options.put(AbstractInjectableValidator.CURRENT_LANGUAGE_NAME, ((XtextResource)resource).getLanguageName());
            }
            if (!(diagnostic = this.diagnostician.validate(element, options)).getChildren().isEmpty()) {
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    this.issueFromEValidatorDiagnostic(childDiagnostic, acceptor);
                }
            } else {
                this.issueFromEValidatorDiagnostic(diagnostic, acceptor);
            }
        }
        catch (RuntimeException e) {
            this.operationCanceledManager.propagateAsErrorIfCancelException(e);
            log.error(e.getMessage(), e);
        }
    }

    protected void resolveProxies(Resource resource, CancelIndicator monitor) {
        EcoreUtil2.resolveLazyCrossReferences(resource, monitor);
    }

    protected IAcceptor<Issue> createAcceptor(List<Issue> result) {
        return new ListBasedMarkerAcceptor(result);
    }

    private void logCheckStatus(Resource resource, boolean parserDiagFail, String string) {
        if (log.isDebugEnabled()) {
            log.debug(string + " check " + (parserDiagFail ? "FAIL" : "OK") + "! Resource: " + resource.getURI());
        }
    }

    protected void issueFromXtextResourceDiagnostic(Resource.Diagnostic diagnostic, Severity severity, IAcceptor<Issue> acceptor) {
        this.converter.convertResourceDiagnostic(diagnostic, severity, acceptor);
    }

    protected void issueFromEValidatorDiagnostic(Diagnostic diagnostic, IAcceptor<Issue> acceptor) {
        this.converter.convertValidatorDiagnostic(diagnostic, acceptor);
    }

    public void setDiagnostician(Diagnostician diagnostician) {
        this.diagnostician = diagnostician;
    }

    public Diagnostician getDiagnostician() {
        return this.diagnostician;
    }

    public void setDiagnosticConverter(IDiagnosticConverter converter) {
        this.converter = converter;
    }

    public IDiagnosticConverter getDiagnosticConverter() {
        return this.converter;
    }

    protected OperationCanceledManager getOperationCanceledManager() {
        return this.operationCanceledManager;
    }

    protected static class ListBasedMarkerAcceptor
    implements IAcceptor<Issue> {
        private final List<Issue> result;

        protected ListBasedMarkerAcceptor(List<Issue> result) {
            this.result = result;
        }

        @Override
        public void accept(Issue issue) {
            if (issue != null) {
                this.result.add(issue);
            }
        }
    }
}

