/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.controlflow;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.controlflow.BooleanResult;
import org.eclipse.xtext.xbase.controlflow.EvaluationContext;
import org.eclipse.xtext.xbase.controlflow.EvaluationResult;
import org.eclipse.xtext.xbase.controlflow.IConstantEvaluationResult;
import org.eclipse.xtext.xbase.controlflow.ThisReference;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.ConstantOperators;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.scoping.XImportSectionNamespaceScopeProvider;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;

@Accessors(value={AccessorType.PROTECTED_GETTER})
public class ConstantConditionsInterpreter {
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;
    @Inject
    @Extension
    private NumberLiterals numberLiterals;
    @Inject
    private ConstantOperators constantOperators;
    @Inject
    @Accessors(value={AccessorType.NONE})
    private Provider<EvaluationContext> evaluationContextProvider;

    public BooleanResult getBooleanConstantOrNull(XExpression it) {
        try {
            EvaluationResult evaluationResult = this.doEvaluate(it, this.newEvaluationContext());
            Object _rawValue = evaluationResult.getRawValue();
            if (_rawValue instanceof Boolean) {
                Object _rawValue_1 = evaluationResult.getRawValue();
                boolean _isCompileTimeConstant = evaluationResult.isCompileTimeConstant();
                return new BooleanResult((Boolean)_rawValue_1, _isCompileTimeConstant);
            }
            return null;
        }
        catch (Throwable _t) {
            if (_t instanceof ConstantExpressionEvaluationException) {
                ConstantExpressionEvaluationException e = (ConstantExpressionEvaluationException)_t;
                return null;
            }
            if (_t instanceof IllegalArgumentException) {
                IllegalArgumentException e_1 = (IllegalArgumentException)_t;
                return null;
            }
            throw Exceptions.sneakyThrow(_t);
        }
    }

    public EvaluationContext newEvaluationContext() {
        return this.evaluationContextProvider.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EvaluationResult doEvaluate(XExpression expression, EvaluationContext context) {
        boolean _tryNext = context.tryNext(expression);
        if (_tryNext) {
            try {
                EvaluationResult evaluationResult = this.internalEvaluate(expression, context);
                return evaluationResult;
            }
            finally {
                context.done(expression);
            }
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    public IConstantEvaluationResult<Object> evaluate(XExpression expression, EvaluationContext context) {
        return this.doEvaluate(expression, context);
    }

    protected EvaluationResult _internalEvaluate(XExpression expression, EvaluationContext context) {
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalEvaluate(Void nullValue, EvaluationContext context) {
        throw new ConstantExpressionEvaluationException("null");
    }

    protected EvaluationResult _internalEvaluate(XNumberLiteral it, EvaluationContext context) {
        Number value = this.numberLiterals.numberValue(it, this.numberLiterals.getJavaType(it));
        boolean _isPrimitive = context.getResolvedTypes().getActualType(it).isPrimitive();
        return new EvaluationResult(value, _isPrimitive);
    }

    protected EvaluationResult _internalEvaluate(XAbstractFeatureCall it, EvaluationContext context) {
        JvmIdentifiableElement feature = this.getFeature(it, context);
        if (feature == null || feature.eIsProxy()) {
            return EvaluationResult.NOT_A_CONSTANT;
        }
        boolean _matched = false;
        if (feature instanceof JvmType) {
            boolean _not;
            boolean _isTypeLiteral = it.isTypeLiteral();
            boolean bl = _not = !_isTypeLiteral;
            if (_not) {
                _matched = true;
                ThisReference _thisReference = new ThisReference((JvmType)feature);
                return new EvaluationResult(_thisReference, false);
            }
        }
        if (!_matched) {
            if (feature instanceof JvmType) {
                _matched = true;
            }
            if (!_matched && feature instanceof JvmEnumerationLiteral) {
                _matched = true;
            }
            if (_matched) {
                return new EvaluationResult(feature, false);
            }
        }
        if (!_matched && feature instanceof JvmField) {
            _matched = true;
            boolean _isSetConstant = ((JvmField)feature).isSetConstant();
            if (_isSetConstant) {
                boolean _isConstant = ((JvmField)feature).isConstant();
                if (_isConstant) {
                    Object _constantValue = ((JvmField)feature).getConstantValue();
                    return new EvaluationResult(_constantValue, true);
                }
            } else {
                boolean _isFinal = ((JvmField)feature).isFinal();
                if (_isFinal) {
                    boolean _tripleNotEquals;
                    XExpression _actualReceiver = it.getActualReceiver();
                    boolean bl = _tripleNotEquals = _actualReceiver != null;
                    if (_tripleNotEquals) {
                        Object _rawValue_2;
                        EvaluationResult receiver = this.doEvaluate(it.getActualReceiver(), context);
                        boolean _isNotAConstant = receiver.isNotAConstant();
                        if (_isNotAConstant) {
                            return receiver;
                        }
                        XExpression associatedExpression = this.getAssociatedExpression((JvmField)feature);
                        if (associatedExpression != null) {
                            EvaluationResult result = this.evaluateAssociatedExpression(associatedExpression, context);
                            Object _rawValue = result.getRawValue();
                            if (_rawValue instanceof ThisReference) {
                                return EvaluationResult.NOT_A_CONSTANT;
                            }
                            Object _rawValue_1 = result.getRawValue();
                            return new EvaluationResult(_rawValue_1, false);
                        }
                        ArrayList<Object> _switchResult_1 = null;
                        Object v = _rawValue_2 = receiver.getRawValue();
                        boolean _matched_1 = false;
                        if (v instanceof JvmIdentifiableElement) {
                            _matched_1 = true;
                        }
                        if (!_matched_1 && v instanceof ThisReference) {
                            _matched_1 = true;
                        }
                        if (_matched_1) {
                            _switchResult_1 = CollectionLiterals.newArrayList(v);
                        }
                        if (!_matched_1 && v instanceof List) {
                            _matched_1 = true;
                            _switchResult_1 = new ArrayList((Collection)v);
                        }
                        ArrayList<Object> list = _switchResult_1;
                        list.add(feature);
                        return new EvaluationResult(list, false);
                    }
                    XExpression associatedExpression_1 = this.getAssociatedExpression((JvmField)feature);
                    if (associatedExpression_1 != null) {
                        EvaluationResult result_1 = this.evaluateAssociatedExpression(associatedExpression_1, context);
                        Object _rawValue_3 = result_1.getRawValue();
                        return new EvaluationResult(_rawValue_3, false);
                    }
                    ArrayList<JvmField> _newArrayList = CollectionLiterals.newArrayList((JvmField)feature);
                    return new EvaluationResult(_newArrayList, false);
                }
            }
        }
        if (!_matched && feature instanceof XVariableDeclaration && !((XVariableDeclaration)feature).isWriteable() && ((XVariableDeclaration)feature).getRight() != null) {
            _matched = true;
            return this.evaluateAssociatedExpression(((XVariableDeclaration)feature).getRight(), context);
        }
        if (!_matched && feature instanceof JvmFormalParameter) {
            EObject _eContainer;
            _matched = true;
            EObject container = _eContainer = ((JvmFormalParameter)feature).eContainer();
            boolean _matched_1 = false;
            if (container instanceof XSwitchExpression) {
                boolean _tripleNotEquals;
                XExpression _switch = ((XSwitchExpression)container).getSwitch();
                boolean bl = _tripleNotEquals = _switch != null;
                if (_tripleNotEquals) {
                    _matched_1 = true;
                    return this.doEvaluate(((XSwitchExpression)container).getSwitch(), context);
                }
            }
            return new EvaluationResult(feature, false);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    public JvmIdentifiableElement getFeature(XAbstractFeatureCall call, EvaluationContext context) {
        Object _eGet = call.eGet(XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, false);
        JvmIdentifiableElement feature = (JvmIdentifiableElement)_eGet;
        if (feature == null || feature.eIsProxy()) {
            feature = context.getResolvedTypes().getLinkedFeature(call);
        }
        return feature;
    }

    public XExpression getAssociatedExpression(JvmField field) {
        boolean _isLoadedFromStorage;
        Resource resource = field.eResource();
        if (resource instanceof StorageAwareResource && (_isLoadedFromStorage = ((StorageAwareResource)resource).isLoadedFromStorage())) {
            return null;
        }
        return this.logicalContainerProvider.getAssociatedExpression(field);
    }

    public EvaluationResult evaluateAssociatedExpression(XExpression it, EvaluationContext context) {
        JvmIdentifiableElement _feature;
        EvaluationResult _switchResult = null;
        boolean _matched = false;
        if (it instanceof XAbstractFeatureCall && (_feature = ((XAbstractFeatureCall)it).getFeature()) instanceof JvmEnumerationLiteral) {
            _matched = true;
            EvaluationResult arg = this.doEvaluate(it, context);
            Object _rawValue = arg.getRawValue();
            return new EvaluationResult(_rawValue, false);
        }
        if (!_matched) {
            _switchResult = this.doEvaluate(it, context);
        }
        return _switchResult;
    }

    protected EvaluationResult _internalEvaluate(XNullLiteral it, EvaluationContext context) {
        return new EvaluationResult(null, true);
    }

    private boolean isFromXbaseLibrary(XAbstractFeatureCall it, EvaluationContext context) {
        boolean _xblockexpression = false;
        JvmIdentifiableElement feature = this.getFeature(it, context);
        boolean _switchResult = false;
        boolean _matched = false;
        if (feature instanceof JvmMember) {
            _matched = true;
            JvmDeclaredType _declaringType = null;
            if ((JvmMember)feature != null) {
                _declaringType = ((JvmMember)feature).getDeclaringType();
            }
            String _packageName = null;
            if (_declaringType != null) {
                _packageName = _declaringType.getPackageName();
            }
            String _string = XImportSectionNamespaceScopeProvider.XBASE_LIB.toString();
            _switchResult = Objects.equal(_packageName, _string);
        }
        if (!_matched) {
            _switchResult = false;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected EvaluationResult _internalEvaluate(XUnaryOperation it, EvaluationContext context) {
        EvaluationResult _switchResult;
        EvaluationResult _xblockexpression;
        EvaluationResult _xifexpression = null;
        boolean _isFromXbaseLibrary = this.isFromXbaseLibrary(it, context);
        if (_isFromXbaseLibrary) {
            _xblockexpression = null;
            EvaluationResult arg = this.doEvaluate(it.getOperand(), context);
            String op = it.getConcreteSyntaxFeatureName();
            _switchResult = null;
            boolean _matched = false;
            if (Objects.equal(op, "-")) {
                _matched = true;
                try {
                    Object result = this.constantOperators.minus(arg.getRawValue());
                    boolean _isCompileTimeConstant = arg.isCompileTimeConstant();
                    return new EvaluationResult(result, _isCompileTimeConstant);
                }
                catch (Throwable _t) {
                    if (_t instanceof ConstantExpressionEvaluationException) {
                        ConstantExpressionEvaluationException e = (ConstantExpressionEvaluationException)_t;
                        return EvaluationResult.NOT_A_CONSTANT;
                    }
                    throw Exceptions.sneakyThrow(_t);
                }
            }
            if (!_matched && Objects.equal(op, "!") && arg.getRawValue() instanceof Boolean) {
                _matched = true;
                Object _rawValue = arg.getRawValue();
                boolean _not = (Boolean)_rawValue == false;
                boolean _isCompileTimeConstant_1 = arg.isCompileTimeConstant();
                _switchResult = new EvaluationResult(_not, _isCompileTimeConstant_1);
            }
            if (!_matched && Objects.equal(op, "+") && arg.getRawValue() instanceof Number) {
                _matched = true;
                _switchResult = arg;
            }
            if (!_matched) {
                _switchResult = EvaluationResult.NOT_A_CONSTANT;
            }
        } else {
            return EvaluationResult.NOT_A_CONSTANT;
        }
        _xifexpression = _xblockexpression = _switchResult;
        return _xifexpression;
    }

    protected EvaluationResult _internalEvaluate(XBinaryOperation it, EvaluationContext context) {
        if (this.isFromXbaseLibrary(it, context) && it.getRightOperand() != null) {
            EvaluationResult left = this.doEvaluate(it.getLeftOperand(), context);
            EvaluationResult right = this.doEvaluate(it.getRightOperand(), context);
            try {
                String op = it.getConcreteSyntaxFeatureName();
                Object _switchResult = null;
                if (op != null) {
                    switch (op) {
                        case "+": {
                            _switchResult = this.constantOperators.plus(left.getRawValue(), right.getRawValue());
                            break;
                        }
                        case "-": {
                            _switchResult = this.constantOperators.minus(left.getRawValue(), right.getRawValue());
                            break;
                        }
                        case "*": {
                            _switchResult = this.constantOperators.multiply(left.getRawValue(), right.getRawValue());
                            break;
                        }
                        case "/": {
                            _switchResult = this.constantOperators.divide(left.getRawValue(), right.getRawValue());
                            break;
                        }
                        case "%": {
                            _switchResult = this.constantOperators.modulo(left.getRawValue(), right.getRawValue());
                            break;
                        }
                        case "<<": {
                            _switchResult = this.constantOperators.shiftLeft(left.getRawValue(), right.getRawValue());
                            break;
                        }
                        case ">>": {
                            _switchResult = this.constantOperators.shiftRight(left.getRawValue(), right.getRawValue());
                            break;
                        }
                        case ">>>": {
                            _switchResult = this.constantOperators.shiftRightUnsigned(left.getRawValue(), right.getRawValue());
                            break;
                        }
                        case "<": {
                            _switchResult = this.constantOperators.lessThan(left.getRawValue(), right.getRawValue());
                            break;
                        }
                        case ">": {
                            _switchResult = this.constantOperators.greaterThan(left.getRawValue(), right.getRawValue());
                            break;
                        }
                        case "<=": {
                            _switchResult = this.constantOperators.lessEquals(left.getRawValue(), right.getRawValue());
                            break;
                        }
                        case ">=": {
                            _switchResult = this.constantOperators.greaterEquals(left.getRawValue(), right.getRawValue());
                            break;
                        }
                        case "&&": {
                            return this.internalLogicalAnd(left.getRawValue(), right.getRawValue(), left.isCompileTimeConstant() && right.isCompileTimeConstant());
                        }
                        case "||": {
                            return this.internalLogicalOr(left.getRawValue(), right.getRawValue(), left.isCompileTimeConstant() && right.isCompileTimeConstant());
                        }
                        case "==": 
                        case "===": {
                            if (left.isNotAConstant() || right.isNotAConstant()) {
                                return EvaluationResult.NOT_A_CONSTANT;
                            }
                            Object _equalValue = left.equalValue(right);
                            return new EvaluationResult(_equalValue, left.isCompileTimeConstant() && right.isCompileTimeConstant());
                        }
                        case "!=": 
                        case "!==": {
                            if (left.isNotAConstant() || right.isNotAConstant()) {
                                return EvaluationResult.NOT_A_CONSTANT;
                            }
                            Object result = left.equalValue(right);
                            boolean _matched = false;
                            if (result instanceof Boolean) {
                                _matched = true;
                                return new EvaluationResult((Boolean)result == false, left.isCompileTimeConstant() && right.isCompileTimeConstant());
                            }
                            return new EvaluationResult(result, left.isCompileTimeConstant() && right.isCompileTimeConstant());
                        }
                        default: {
                            return EvaluationResult.NOT_A_CONSTANT;
                        }
                    }
                } else {
                    return EvaluationResult.NOT_A_CONSTANT;
                }
                Object value = _switchResult;
                return new EvaluationResult(value, left.isCompileTimeConstant() && right.isCompileTimeConstant());
            }
            catch (Throwable _t) {
                if (_t instanceof ConstantExpressionEvaluationException) {
                    ConstantExpressionEvaluationException e = (ConstantExpressionEvaluationException)_t;
                    return EvaluationResult.NOT_A_CONSTANT;
                }
                throw Exceptions.sneakyThrow(_t);
            }
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalAnd(Object left, Object right, boolean compileTimeConstant) {
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalAnd(Boolean left, Boolean right, boolean compileTimeConstant) {
        return new EvaluationResult(left != false && right != false, compileTimeConstant);
    }

    protected EvaluationResult _internalLogicalAnd(Boolean left, Object right, boolean compileTimeConstant) {
        if (!left.booleanValue()) {
            return new EvaluationResult(Boolean.FALSE, compileTimeConstant);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalAnd(Boolean left, Void right, boolean compileTimeConstant) {
        if (!left.booleanValue()) {
            return new EvaluationResult(Boolean.FALSE, compileTimeConstant);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalAnd(Object left, Boolean right, boolean compileTimeConstant) {
        if (!right.booleanValue()) {
            return new EvaluationResult(Boolean.FALSE, compileTimeConstant);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalAnd(Void left, Boolean right, boolean compileTimeConstant) {
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalOr(Object left, Object right, boolean compileTimeConstant) {
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalOr(Boolean left, Boolean right, boolean compileTimeConstant) {
        return new EvaluationResult(left != false || right != false, compileTimeConstant);
    }

    protected EvaluationResult _internalLogicalOr(Boolean left, Object right, boolean compileTimeConstant) {
        if (left.booleanValue()) {
            return new EvaluationResult(Boolean.TRUE, compileTimeConstant);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalOr(Boolean left, Void right, boolean compileTimeConstant) {
        if (left.booleanValue()) {
            return new EvaluationResult(Boolean.TRUE, compileTimeConstant);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalOr(Object left, Boolean right, boolean compileTimeConstant) {
        if (right.booleanValue()) {
            return new EvaluationResult(Boolean.TRUE, compileTimeConstant);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalOr(Void left, Boolean right, boolean compileTimeConstant) {
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalEvaluate(XCastedExpression expression, EvaluationContext context) {
        return this.doEvaluate(expression.getTarget(), context);
    }

    protected EvaluationResult _internalEvaluate(XStringLiteral it, EvaluationContext context) {
        String _value = it.getValue();
        return new EvaluationResult(_value, true);
    }

    protected EvaluationResult _internalEvaluate(XBooleanLiteral it, EvaluationContext context) {
        boolean _isIsTrue = it.isIsTrue();
        return new EvaluationResult(_isIsTrue, true);
    }

    protected EvaluationResult _internalEvaluate(XTypeLiteral it, EvaluationContext context) {
        return new EvaluationResult(it, false);
    }

    public EvaluationResult internalEvaluate(XExpression it, EvaluationContext context) {
        if (it instanceof XBinaryOperation) {
            return this._internalEvaluate((XBinaryOperation)it, context);
        }
        if (it instanceof XUnaryOperation) {
            return this._internalEvaluate((XUnaryOperation)it, context);
        }
        if (it instanceof XAbstractFeatureCall) {
            return this._internalEvaluate((XAbstractFeatureCall)it, context);
        }
        if (it instanceof XBooleanLiteral) {
            return this._internalEvaluate((XBooleanLiteral)it, context);
        }
        if (it instanceof XCastedExpression) {
            return this._internalEvaluate((XCastedExpression)it, context);
        }
        if (it instanceof XNullLiteral) {
            return this._internalEvaluate((XNullLiteral)it, context);
        }
        if (it instanceof XNumberLiteral) {
            return this._internalEvaluate((XNumberLiteral)it, context);
        }
        if (it instanceof XStringLiteral) {
            return this._internalEvaluate((XStringLiteral)it, context);
        }
        if (it instanceof XTypeLiteral) {
            return this._internalEvaluate((XTypeLiteral)it, context);
        }
        if (it != null) {
            return this._internalEvaluate(it, context);
        }
        if (it == null) {
            return this._internalEvaluate((Void)null, context);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, context).toString());
    }

    public EvaluationResult internalLogicalAnd(Object left, Object right, boolean compileTimeConstant) {
        if (left instanceof Boolean && right instanceof Boolean) {
            return this._internalLogicalAnd((Boolean)left, (Boolean)right, compileTimeConstant);
        }
        if (left instanceof Boolean && right == null) {
            return this._internalLogicalAnd((Boolean)left, (Void)null, compileTimeConstant);
        }
        if (left instanceof Boolean && right != null) {
            return this._internalLogicalAnd((Boolean)left, right, compileTimeConstant);
        }
        if (left == null && right instanceof Boolean) {
            return this._internalLogicalAnd((Void)null, (Boolean)right, compileTimeConstant);
        }
        if (left != null && right instanceof Boolean) {
            return this._internalLogicalAnd(left, (Boolean)right, compileTimeConstant);
        }
        if (left != null && right != null) {
            return this._internalLogicalAnd(left, right, compileTimeConstant);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(left, right, compileTimeConstant).toString());
    }

    public EvaluationResult internalLogicalOr(Object left, Object right, boolean compileTimeConstant) {
        if (left instanceof Boolean && right instanceof Boolean) {
            return this._internalLogicalOr((Boolean)left, (Boolean)right, compileTimeConstant);
        }
        if (left instanceof Boolean && right == null) {
            return this._internalLogicalOr((Boolean)left, (Void)null, compileTimeConstant);
        }
        if (left instanceof Boolean && right != null) {
            return this._internalLogicalOr((Boolean)left, right, compileTimeConstant);
        }
        if (left == null && right instanceof Boolean) {
            return this._internalLogicalOr((Void)null, (Boolean)right, compileTimeConstant);
        }
        if (left != null && right instanceof Boolean) {
            return this._internalLogicalOr(left, (Boolean)right, compileTimeConstant);
        }
        if (left != null && right != null) {
            return this._internalLogicalOr(left, right, compileTimeConstant);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(left, right, compileTimeConstant).toString());
    }

    @Pure
    protected ILogicalContainerProvider getLogicalContainerProvider() {
        return this.logicalContainerProvider;
    }

    @Pure
    protected NumberLiterals getNumberLiterals() {
        return this.numberLiterals;
    }

    @Pure
    protected ConstantOperators getConstantOperators() {
        return this.constantOperators;
    }
}

