/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.internal.FunctionDelegate;
import org.eclipse.xtext.xbase.lib.internal.UnmodifiableMergingMapView;

@GwtCompatible
public class MapExtensions {
    public static <K, V> void forEach(Map<K, V> map, Procedures.Procedure2<? super K, ? super V> procedure) {
        if (procedure == null) {
            throw new NullPointerException("procedure");
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            procedure.apply(entry.getKey(), entry.getValue());
        }
    }

    public static <K, V> void forEach(Map<K, V> map, Procedures.Procedure3<? super K, ? super V, ? super Integer> procedure) {
        if (procedure == null) {
            throw new NullPointerException("procedure");
        }
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            procedure.apply(entry.getKey(), entry.getValue(), i);
            if (i == Integer.MAX_VALUE) continue;
            ++i;
        }
    }

    public static <K, V> Map<K, V> filter(Map<K, V> original, final Functions.Function2<? super K, ? super V, Boolean> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        return Maps.filterEntries(original, new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> input) {
                Boolean result = (Boolean)predicate.apply(input.getKey(), input.getValue());
                return result;
            }
        });
    }

    @Inline(value="$1.put($2.getKey(), $2.getValue())", statementExpression=true)
    public static <K, V> V operator_add(Map<K, V> map, Pair<? extends K, ? extends V> entry) {
        return map.put(entry.getKey(), entry.getValue());
    }

    @Inline(value="$1.putAll($2)", statementExpression=true)
    public static <K, V> void operator_add(Map<K, V> outputMap, Map<? extends K, ? extends V> inputMap) {
        outputMap.putAll(inputMap);
    }

    @Pure
    @Inline(value="$3.union($1, $4.singletonMap($2.getKey(), $2.getValue()))", imported={MapExtensions.class, Collections.class})
    public static <K, V> Map<K, V> operator_plus(Map<K, V> left, Pair<? extends K, ? extends V> right) {
        return MapExtensions.union(left, Collections.singletonMap(right.getKey(), right.getValue()));
    }

    @Pure
    @Inline(value="$3.union($1, $2)", imported={MapExtensions.class})
    public static <K, V> Map<K, V> operator_plus(Map<K, V> left, Map<? extends K, ? extends V> right) {
        return MapExtensions.union(left, right);
    }

    @Inline(value="$1.remove($2)", statementExpression=true)
    public static <K, V> V operator_remove(Map<K, V> map, K key) {
        return map.remove(key);
    }

    @Inline(value="$1.remove($2.getKey(), $2.getValue())", statementExpression=true)
    public static <K, V> boolean operator_remove(Map<K, V> map, Pair<? extends K, ? extends V> entry) {
        K key = entry.getKey();
        V storedValue = map.get(entry.getKey());
        if (!Objects.equal(storedValue, entry.getValue()) || storedValue == null && !map.containsKey(key)) {
            return false;
        }
        map.remove(key);
        return true;
    }

    public static <K, V> void operator_remove(Map<K, V> map, Iterable<? super K> keysToRemove) {
        for (K key : keysToRemove) {
            map.remove(key);
        }
    }

    @Pure
    public static <K, V> Map<K, V> operator_minus(Map<K, V> left, final Pair<? extends K, ? extends V> right) {
        return Maps.filterEntries(left, new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> input) {
                return !Objects.equal(input.getKey(), right.getKey()) || !Objects.equal(input.getValue(), right.getValue());
            }
        });
    }

    @Pure
    public static <K, V> Map<K, V> operator_minus(Map<K, V> map, final K key) {
        return Maps.filterKeys(map, new Predicate<K>(){

            @Override
            public boolean apply(K input) {
                return !Objects.equal(input, key);
            }
        });
    }

    @Pure
    public static <K, V> Map<K, V> operator_minus(Map<K, V> left, final Map<? extends K, ? extends V> right) {
        return Maps.filterEntries(left, new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> input) {
                Object value = right.get(input.getKey());
                if (value == null) {
                    return input.getValue() == null && right.containsKey(input.getKey());
                }
                return !Objects.equal(input.getValue(), value);
            }
        });
    }

    @Pure
    public static <K, V> Map<K, V> operator_minus(Map<K, V> map, final Iterable<?> keys) {
        return Maps.filterKeys(map, new Predicate<K>(){

            @Override
            public boolean apply(K input) {
                return !Iterables.contains(keys, input);
            }
        });
    }

    @Pure
    @Inline(value="(new $3<$5, $6>($1, $2))", imported={UnmodifiableMergingMapView.class}, constantExpression=true)
    public static <K, V> Map<K, V> union(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        return new UnmodifiableMergingMapView<K, V>(left, right);
    }

    @Pure
    public static <K, V1, V2> Map<K, V2> mapValues(Map<K, V1> original, Functions.Function1<? super V1, ? extends V2> transformation) {
        return Maps.transformValues(original, new FunctionDelegate<V1, V2>(transformation));
    }
}

