/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.persistence.ResourceStorageWritable;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.jvmmodel.JvmIdentifiableMetaData;
import org.eclipse.xtext.xbase.jvmmodel.JvmModelAssociator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.resource.BatchLinkableResource;
import org.eclipse.xtext.xtype.XComputedTypeReference;

@FinalFieldsConstructor
public class BatchLinkableResourceStorageWritable
extends ResourceStorageWritable {
    private static final Logger LOG = Logger.getLogger(BatchLinkableResourceStorageWritable.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeEntries(StorageAwareResource resource, ZipOutputStream zipOut) throws IOException {
        super.writeEntries(resource, zipOut);
        if (resource instanceof BatchLinkableResource) {
            ZipEntry _zipEntry = new ZipEntry("associations");
            zipOut.putNextEntry(_zipEntry);
            BufferedOutputStream buffOut = new BufferedOutputStream(zipOut);
            try {
                this.writeAssociationsAdapter((BatchLinkableResource)resource, buffOut);
            }
            finally {
                buffOut.flush();
                zipOut.closeEntry();
            }
        }
    }

    @Override
    protected Object beforeSaveEObject(InternalEObject object, BinaryResourceImpl.EObjectOutputStream writable) throws IOException {
        JvmType _xblockexpression = null;
        super.beforeSaveEObject(object, writable);
        JvmType _xifexpression = null;
        if (object instanceof XComputedTypeReference) {
            _xifexpression = ((XComputedTypeReference)((Object)object)).getType();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    protected void handleSaveEObject(InternalEObject object, BinaryResourceImpl.EObjectOutputStream out) throws IOException {
        super.handleSaveEObject(object, out);
        DocumentationAdapter documentationAdapter = null;
        JvmIdentifiableMetaData metaDataAdapter = null;
        EList<Adapter> _eAdapters = object.eAdapters();
        for (Adapter adapter : _eAdapters) {
            if (adapter instanceof DocumentationAdapter) {
                documentationAdapter = (DocumentationAdapter)adapter;
            }
            if (!(adapter instanceof JvmIdentifiableMetaData)) continue;
            metaDataAdapter = (JvmIdentifiableMetaData)adapter;
        }
        if (documentationAdapter != null) {
            out.writeBoolean(true);
            out.writeString(documentationAdapter.getDocumentation());
        } else {
            out.writeBoolean(false);
        }
        if (metaDataAdapter != null) {
            out.writeBoolean(true);
            out.writeBoolean(metaDataAdapter.isSynthetic());
        } else {
            out.writeBoolean(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeAssociationsAdapter(BatchLinkableResource resource, OutputStream zipOut) throws IOException {
        JvmModelAssociator.Adapter adapter = IterableExtensions.head(Iterables.filter(resource.eAdapters(), JvmModelAssociator.Adapter.class));
        if (adapter == null) {
            JvmModelAssociator.Adapter _adapter;
            Functions.Function1<EObject, Boolean> _function = it -> it instanceof JvmType;
            boolean _exists = IterableExtensions.exists(IterableExtensions.tail(resource.getContents()), _function);
            if (_exists) {
                URI _uRI = resource.getURI();
                String _plus = "Missing JvmModelAssociator.Adapter but resource contains inferred types: " + _uRI;
                throw new IOException(_plus);
            }
            adapter = _adapter = new JvmModelAssociator.Adapter();
        }
        ObjectOutputStream objOut = new ObjectOutputStream(zipOut);
        try {
            LinkedHashMap<String, String> logicalMap = CollectionLiterals.newLinkedHashMap();
            Set<Map.Entry<EObject, JvmIdentifiableElement>> _entrySet = adapter.logicalContainerMap.entrySet();
            for (Map.Entry<EObject, JvmIdentifiableElement> entry : _entrySet) {
                boolean bl;
                Resource _eResource = entry.getKey().eResource();
                boolean bl2 = bl = !Objects.equal(_eResource, resource);
                if (bl) {
                    URI _uRI_1 = resource.getURI();
                    String _plus_1 = "entry " + entry + " not from resource " + _uRI_1;
                    String _plus_2 = _plus_1 + " but from ";
                    Resource _eResource_1 = entry.getKey().eResource();
                    URI _uRI_2 = null;
                    if (_eResource_1 != null) {
                        _uRI_2 = _eResource_1.getURI();
                    }
                    String _plus_3 = _plus_2 + _uRI_2;
                    LOG.info(_plus_3);
                    continue;
                }
                logicalMap.put(this.getFragment(entry.getKey()), this.getFragment(entry.getValue()));
            }
            objOut.writeObject(logicalMap);
            LinkedHashMap<String, LinkedHashSet<String>> sourceToTarget = CollectionLiterals.newLinkedHashMap();
            Set<Map.Entry<EObject, Set<EObject>>> _entrySet_1 = adapter.sourceToTargetMap.entrySet();
            for (Map.Entry entry : _entrySet_1) {
                boolean _notEquals_1;
                Resource _eResource_2 = ((EObject)entry.getKey()).eResource();
                boolean bl = _notEquals_1 = !Objects.equal(_eResource_2, resource);
                if (_notEquals_1) {
                    URI _uRI_3 = resource.getURI();
                    String _plus_4 = "entry not from resource " + _uRI_3;
                    String _plus_5 = _plus_4 + " but from ";
                    Resource _eResource_3 = ((EObject)entry.getKey()).eResource();
                    URI _uRI_4 = null;
                    if (_eResource_3 != null) {
                        _uRI_4 = _eResource_3.getURI();
                    }
                    String _plus_6 = _plus_5 + _uRI_4;
                    LOG.info(_plus_6);
                    continue;
                }
                Functions.Function1<EObject, String> _function_1 = it -> this.getFragment((EObject)it);
                sourceToTarget.put(this.getFragment((EObject)entry.getKey()), Sets.newLinkedHashSet(IterableExtensions.map((Iterable)entry.getValue(), _function_1)));
            }
            objOut.writeObject(sourceToTarget);
            LinkedHashMap<String, LinkedHashSet<String>> targetToSource = CollectionLiterals.newLinkedHashMap();
            Set<Map.Entry<EObject, Set<EObject>>> set = adapter.targetToSourceMap.entrySet();
            for (Map.Entry<EObject, Set<EObject>> entry_2 : set) {
                boolean _notEquals_2;
                Resource _eResource_4 = entry_2.getKey().eResource();
                boolean bl = _notEquals_2 = !Objects.equal(_eResource_4, resource);
                if (_notEquals_2) {
                    URI _uRI_5 = resource.getURI();
                    String _plus_7 = "entry not from resource " + _uRI_5;
                    String _plus_8 = _plus_7 + " but from ";
                    Resource _eResource_5 = entry_2.getKey().eResource();
                    URI _uRI_6 = null;
                    if (_eResource_5 != null) {
                        _uRI_6 = _eResource_5.getURI();
                    }
                    String _plus_9 = _plus_8 + _uRI_6;
                    LOG.info(_plus_9);
                    continue;
                }
                Functions.Function1<EObject, String> _function_2 = it -> this.getFragment((EObject)it);
                targetToSource.put(this.getFragment(entry_2.getKey()), Sets.newLinkedHashSet(IterableExtensions.map((Iterable)entry_2.getValue(), _function_2)));
            }
            objOut.writeObject(targetToSource);
        }
        finally {
            objOut.flush();
        }
    }

    protected String getFragment(EObject obj) {
        String _xblockexpression = null;
        if (obj == null || obj.eIsProxy() || obj.eResource() == null) {
            return "none";
        }
        _xblockexpression = obj.eResource().getURIFragment(obj);
        return _xblockexpression;
    }

    public BatchLinkableResourceStorageWritable(OutputStream arg0, boolean arg1) {
        super(arg0, arg1);
    }
}

