/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;

public class NestedTypesScope
extends AbstractScope {
    private final IFeatureScopeSession session;

    public NestedTypesScope(IScope parent, IFeatureScopeSession session) {
        super(parent, false);
        this.session = session;
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        List<JvmDeclaredType> nestedTypeDeclarators = this.session.getNestedTypeDeclarators();
        if (nestedTypeDeclarators.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IEObjectDescription> result = Lists.newArrayList();
        for (JvmDeclaredType declarator : nestedTypeDeclarators) {
            for (JvmDeclaredType nestedType : declarator.getAllNestedTypes()) {
                this.addDescriptions(nestedType, declarator, result);
            }
        }
        return result;
    }

    protected void addDescriptions(JvmDeclaredType type, JvmType declarator, List<IEObjectDescription> result) {
        String typeName = type.getQualifiedName('.');
        String declaratorName = declarator.getQualifiedName('.');
        int declaratorLength = declaratorName.length();
        String subName = typeName.substring(declaratorLength + 1);
        List<String> segments = Strings.split(subName, '.');
        result.add(EObjectDescription.create(QualifiedName.create(segments), (EObject)type));
        result.add(EObjectDescription.create(subName.replace('.', '$'), (EObject)type));
        for (JvmDeclaredType nestedType : type.getAllNestedTypes()) {
            this.addDescriptions(nestedType, declarator, result);
        }
    }

    @Override
    protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        List<JvmDeclaredType> nestedTypeDeclarators = this.session.getNestedTypeDeclarators();
        if (nestedTypeDeclarators.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<JvmDeclaredType> iterator = nestedTypeDeclarators.iterator();
        String simpleName = name.getFirstSegment();
        List<IEObjectDescription> result = null;
        while (iterator.hasNext()) {
            JvmDeclaredType declarator = iterator.next();
            Iterable<JvmDeclaredType> nestedTypes = declarator.findAllNestedTypesByName(simpleName);
            if (name.getSegmentCount() != 1 || !nestedTypes.iterator().hasNext()) continue;
            result = this.addDescriptions(name, 0, nestedTypes, result);
        }
        if (result == null && name.getSegmentCount() == 1 && simpleName.indexOf(36) > 0) {
            QualifiedName splitted = QualifiedName.create(Strings.split(simpleName, '$'));
            return this.getLocalElementsByName(splitted);
        }
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    private List<IEObjectDescription> addDescriptions(QualifiedName name, int idx, Iterable<JvmDeclaredType> declaredTypes, List<IEObjectDescription> result) {
        if (idx == name.getSegmentCount()) {
            return result;
        }
        if (idx == name.getSegmentCount() - 1) {
            if (result == null) {
                result = Lists.newArrayList();
            }
            for (JvmDeclaredType declaredType : declaredTypes) {
                result.add(this.createDescription(name, declaredType));
            }
            return result;
        }
        String nextSegment = name.getSegment(idx);
        for (JvmDeclaredType declaredType : declaredTypes) {
            Iterable<JvmDeclaredType> nestedTypes = declaredType.findAllNestedTypesByName(nextSegment);
            this.addDescriptions(name, idx + 1, nestedTypes, result);
        }
        return result;
    }

    private IEObjectDescription createDescription(QualifiedName name, JvmDeclaredType declaredType) {
        return EObjectDescription.create(name, (EObject)declaredType);
    }
}

