/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.eclipse.xtext.naming.QualifiedName;

@Singleton
public class OperatorMapping {
    public static final QualifiedName PLUS = QualifiedName.create("+");
    public static final QualifiedName PLUS_PLUS = QualifiedName.create("++");
    public static final QualifiedName MINUS = QualifiedName.create("-");
    public static final QualifiedName MINUS_MINUS = QualifiedName.create("--");
    public static final QualifiedName POWER = QualifiedName.create("**");
    public static final QualifiedName MULTIPLY = QualifiedName.create("*");
    public static final QualifiedName DIVIDE = QualifiedName.create("/");
    public static final QualifiedName MODULO = QualifiedName.create("%");
    public static final QualifiedName DOUBLE_LESS_THAN = QualifiedName.create("<<");
    public static final QualifiedName DOUBLE_GREATER_THAN = QualifiedName.create(">>");
    public static final QualifiedName TRIPLE_LESS_THAN = QualifiedName.create("<<<");
    public static final QualifiedName TRIPLE_GREATER_THAN = QualifiedName.create(">>>");
    public static final QualifiedName ELVIS = QualifiedName.create("?:");
    public static final QualifiedName DIAMOND = QualifiedName.create("<>");
    public static final QualifiedName SPACESHIP = QualifiedName.create("<=>");
    public static final QualifiedName OR = QualifiedName.create("||");
    public static final QualifiedName AND = QualifiedName.create("&&");
    public static final QualifiedName ADD = QualifiedName.create("+=");
    public static final QualifiedName REMOVE = QualifiedName.create("-=");
    public static final QualifiedName MULTIPLY_ASSIGN = QualifiedName.create("*=");
    public static final QualifiedName DIVIDE_ASSIGN = QualifiedName.create("/=");
    public static final QualifiedName MODULO_ASSIGN = QualifiedName.create("%=");
    public static final QualifiedName DOUBLE_LESS_THAN_ASSIGN = QualifiedName.create("<<=");
    public static final QualifiedName DOUBLE_GREATER_THAN_ASSIGN = QualifiedName.create(">>=");
    public static final QualifiedName TRIPLE_GREATER_THAN_ASSIGN = QualifiedName.create(">>>=");
    public static final QualifiedName EQUALS = QualifiedName.create("==");
    public static final QualifiedName TRIPLE_EQUALS = QualifiedName.create("===");
    public static final QualifiedName TRIPLE_NOT_EQUALS = QualifiedName.create("!==");
    public static final QualifiedName NOT_EQUALS = QualifiedName.create("!=");
    public static final QualifiedName LESS_THAN = QualifiedName.create("<");
    public static final QualifiedName LESS_EQUALS_THAN = QualifiedName.create("<=");
    public static final QualifiedName GREATER_THAN = QualifiedName.create(">");
    public static final QualifiedName GREATER_EQUALS_THAN = QualifiedName.create(">=");
    public static final QualifiedName MAPPED_TO = QualifiedName.create("->");
    public static final QualifiedName UP_TO = QualifiedName.create("..");
    public static final QualifiedName DOUBLE_DOT_LESS_THAN = QualifiedName.create("..<");
    public static final QualifiedName GREATER_THAN_DOUBLE_DOT = QualifiedName.create(">..");
    public static final QualifiedName NOT = QualifiedName.create("!");
    public static final QualifiedName DOUBLE_ARROW = QualifiedName.create("=>");
    protected BiMap<QualifiedName, QualifiedName> map = HashBiMap.create();
    protected BiMap<QualifiedName, QualifiedName> compoundOperatorMapping = HashBiMap.create();
    public static final String OP_PREFIX = "operator_";

    public OperatorMapping() {
        this.initializeMapping();
    }

    protected void initializeMapping() {
        this.map.put(PLUS, QualifiedName.create("operator_plus"));
        this.map.put(PLUS_PLUS, QualifiedName.create("operator_plusPlus"));
        this.map.put(MINUS, QualifiedName.create("operator_minus"));
        this.map.put(MINUS_MINUS, QualifiedName.create("operator_minusMinus"));
        this.map.put(POWER, QualifiedName.create("operator_power"));
        this.map.put(MULTIPLY, QualifiedName.create("operator_multiply"));
        this.map.put(DIVIDE, QualifiedName.create("operator_divide"));
        this.map.put(MODULO, QualifiedName.create("operator_modulo"));
        this.map.put(DOUBLE_LESS_THAN, QualifiedName.create("operator_doubleLessThan"));
        this.map.put(DOUBLE_GREATER_THAN, QualifiedName.create("operator_doubleGreaterThan"));
        this.map.put(TRIPLE_LESS_THAN, QualifiedName.create("operator_tripleLessThan"));
        this.map.put(TRIPLE_GREATER_THAN, QualifiedName.create("operator_tripleGreaterThan"));
        this.map.put(ELVIS, QualifiedName.create("operator_elvis"));
        this.map.put(DIAMOND, QualifiedName.create("operator_diamond"));
        this.map.put(SPACESHIP, QualifiedName.create("operator_spaceship"));
        this.map.put(OR, QualifiedName.create("operator_or"));
        this.map.put(AND, QualifiedName.create("operator_and"));
        this.map.put(ADD, QualifiedName.create("operator_add"));
        this.map.put(REMOVE, QualifiedName.create("operator_remove"));
        this.map.put(MULTIPLY_ASSIGN, QualifiedName.create("operator_multiplyAssign"));
        this.map.put(DIVIDE_ASSIGN, QualifiedName.create("operator_divideAssign"));
        this.map.put(MODULO_ASSIGN, QualifiedName.create("operator_moduloAssign"));
        this.map.put(DOUBLE_LESS_THAN_ASSIGN, QualifiedName.create("operator_doubleLessThanAssign"));
        this.map.put(DOUBLE_GREATER_THAN_ASSIGN, QualifiedName.create("operator_doubleGreaterThanAssign"));
        this.map.put(TRIPLE_GREATER_THAN_ASSIGN, QualifiedName.create("operator_tripleGreaterThanAssign"));
        this.map.put(EQUALS, QualifiedName.create("operator_equals"));
        this.map.put(TRIPLE_EQUALS, QualifiedName.create("operator_tripleEquals"));
        this.map.put(TRIPLE_NOT_EQUALS, QualifiedName.create("operator_tripleNotEquals"));
        this.map.put(NOT_EQUALS, QualifiedName.create("operator_notEquals"));
        this.map.put(LESS_THAN, QualifiedName.create("operator_lessThan"));
        this.map.put(LESS_EQUALS_THAN, QualifiedName.create("operator_lessEqualsThan"));
        this.map.put(GREATER_THAN, QualifiedName.create("operator_greaterThan"));
        this.map.put(GREATER_EQUALS_THAN, QualifiedName.create("operator_greaterEqualsThan"));
        this.map.put(MAPPED_TO, QualifiedName.create("operator_mappedTo"));
        this.map.put(UP_TO, QualifiedName.create("operator_upTo"));
        this.map.put(DOUBLE_DOT_LESS_THAN, QualifiedName.create("operator_doubleDotLessThan"));
        this.map.put(GREATER_THAN_DOUBLE_DOT, QualifiedName.create("operator_greaterThanDoubleDot"));
        this.map.put(NOT, QualifiedName.create("operator_not"));
        this.map.put(DOUBLE_ARROW, QualifiedName.create("operator_doubleArrow"));
        this.compoundOperatorMapping.put(ADD, PLUS);
        this.compoundOperatorMapping.put(REMOVE, MINUS);
        this.compoundOperatorMapping.put(MULTIPLY_ASSIGN, MULTIPLY);
        this.compoundOperatorMapping.put(DIVIDE_ASSIGN, DIVIDE);
        this.compoundOperatorMapping.put(MODULO_ASSIGN, MODULO);
        this.compoundOperatorMapping.put(DOUBLE_LESS_THAN_ASSIGN, DOUBLE_LESS_THAN);
        this.compoundOperatorMapping.put(DOUBLE_GREATER_THAN_ASSIGN, DOUBLE_GREATER_THAN);
        this.compoundOperatorMapping.put(TRIPLE_GREATER_THAN_ASSIGN, TRIPLE_GREATER_THAN);
    }

    public QualifiedName getMethodName(QualifiedName operator) {
        return (QualifiedName)this.map.get(operator);
    }

    public QualifiedName getOperator(QualifiedName methodName) {
        return (QualifiedName)this.map.inverse().get(methodName);
    }

    public Set<QualifiedName> getOperators() {
        return this.map.keySet();
    }

    public QualifiedName getCompoundOperator(QualifiedName simpleOperator) {
        return (QualifiedName)this.compoundOperatorMapping.inverse().get(simpleOperator);
    }

    public Set<QualifiedName> getCompoundOperators() {
        return this.compoundOperatorMapping.keySet();
    }

    public QualifiedName getSimpleOperator(QualifiedName compoundOperator) {
        return (QualifiedName)this.compoundOperatorMapping.get(compoundOperator);
    }

    public boolean isCompoundMethod(String methodName) {
        QualifiedName operator = this.getOperator(QualifiedName.create(methodName));
        return this.getCompoundOperators().contains(operator);
    }

    public boolean isBinaryOperator(QualifiedName operator) {
        return operator.equals(MINUS) || operator.equals(PLUS) || !this.isUnaryOperator(operator);
    }

    public boolean isUnaryOperator(QualifiedName operator) {
        return operator.equals(PLUS_PLUS) || operator.equals(MINUS_MINUS) || operator.equals(MINUS) || operator.equals(PLUS) || operator.equals(NOT);
    }

    private static class JavaDocGenerator {
        private JavaDocGenerator() {
        }

        public static void main(String[] args) throws Exception {
            System.out.println(" * <table>");
            System.out.println(" *   <tr><th>Operator</th><th>Method Name</th></tr>");
            Field[] fields = OperatorMapping.class.getFields();
            BiMap<QualifiedName, QualifiedName> map = new OperatorMapping().map;
            for (Field field : fields) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(QualifiedName.class)) continue;
                Object operator = field.get(null);
                QualifiedName methodName = (QualifiedName)map.get(operator);
                System.out.println(" *   <tr><td>" + JavaDocGenerator.toHtml(operator) + "</td><td>" + JavaDocGenerator.toHtml(methodName) + "</td></tr>");
            }
            System.out.println(" * </table>");
        }

        private static String toHtml(Object object) {
            String result = String.valueOf(object);
            result = result.replace("<", "&lt;").replace(">", "&gt;");
            return result;
        }
    }
}

