/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.primitives.Booleans;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.xbase.typesystem.conformance.RawTypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.conformance.SuperTypeAcceptor;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

@Singleton
public class TypeConformanceComputer
extends RawTypeConformanceComputer {
    @Inject
    private RawTypeConformanceComputer rawTypeConformanceComputer = new RawTypeConformanceComputer();

    public boolean isConformant(LightweightTypeReference left, LightweightTypeReference right) {
        return (this.isConformant(left, right, 444) & 0x200) != 0;
    }

    public int isConformant(LightweightTypeReference left, LightweightTypeReference right, TypeConformanceComputationArgument argument) {
        int flags = this.toFlags(argument);
        int result = this.isConformant(left, right, flags);
        return result;
    }

    protected int toFlags(TypeConformanceComputationArgument argument) {
        int flags = 260;
        if (argument.allowPrimitiveConversion) {
            flags |= 0x18;
        }
        if (argument.allowPrimitiveWidening) {
            flags |= 0x20;
        }
        if (argument.allowSynonyms) {
            flags |= 0x80;
        }
        if (argument.rawType) {
            flags |= 1;
        }
        if (argument.asTypeArgument) {
            flags |= 2;
        }
        if (argument.unboundComputationAddsHints) {
            flags |= 0x40;
        }
        return flags;
    }

    @Override
    public int isConformant(LightweightTypeReference left, LightweightTypeReference right, int flags) {
        if (left == right && left != null) {
            return flags | 0x200;
        }
        if ((flags & 1) != 0 || (left.isRawType() || right.isRawType()) && (flags & 4) != 0) {
            int result = this.rawTypeConformanceComputer.isConformant(left, right, flags);
            if ((result & 0x200) != 0) {
                if (left.isRawType() != right.isRawType() && left.hasTypeArguments() != right.hasTypeArguments()) {
                    result |= 0x8000;
                }
            } else {
                return this.isSynonymConformant(result, left, right, flags);
            }
            return result;
        }
        int result = this.doIsConformant(left, right, flags);
        if (((result = this.isSynonymConformant(result, left, right, flags)) & 0x200) == 0) {
            result |= 0x40000;
        }
        return result;
    }

    @Override
    protected LightweightTypeReference getSuperType(ParameterizedTypeReference current, JvmType type) {
        return current.getSuperType(type);
    }

    @Override
    protected int doIsConformantTypeArguments(LightweightTypeReference left, LightweightTypeReference right, int flags) {
        List<LightweightTypeReference> leftTypeArguments = left.getTypeArguments();
        List<LightweightTypeReference> rightTypeArguments = right.getTypeArguments();
        int size = leftTypeArguments.size();
        if (size == rightTypeArguments.size()) {
            int argumentFlags = (flags | 2) & 0xFFFFFE43;
            for (int i = 0; i < size; ++i) {
                if ((this.doIsConformant(leftTypeArguments.get(i), rightTypeArguments.get(i), argumentFlags) & 0x200) != 0) continue;
                return flags;
            }
        } else if ((flags & 4) != 0) {
            if (size == 0 || rightTypeArguments.isEmpty()) {
                return flags | 0x200 | 0x8000;
            }
        } else {
            return flags;
        }
        return this.doIsConformantOuterType(left, right, flags);
    }

    protected int doIsConformantOuterType(LightweightTypeReference left, LightweightTypeReference right, int flags) {
        LightweightTypeReference leftOuter = left.getOuter();
        LightweightTypeReference rightOuter = right.getOuter();
        if (leftOuter != null) {
            JvmType rawLeftOuter = (JvmType)left.getType().eContainer();
            if (rightOuter != null) {
                JvmType rawRightOuter = (JvmType)right.getType().eContainer();
                if (rawLeftOuter != rawRightOuter) {
                    throw new IllegalStateException("References must point to same raw types: " + left + " / " + right);
                }
                if (leftOuter.getType() != rawLeftOuter && (leftOuter = leftOuter.getSuperType(rawLeftOuter)) == null) {
                    return flags;
                }
                if (rightOuter.getType() != rawRightOuter && (rightOuter = rightOuter.getSuperType(rawRightOuter)) == null) {
                    return flags;
                }
                return this.doIsConformantTypeArguments(leftOuter, rightOuter, flags);
            }
            throw new IllegalStateException("References must point to same raw types: " + left + " / " + right);
        }
        if (rightOuter != null) {
            throw new IllegalStateException("References must point to same raw types: " + left + " / " + right);
        }
        return flags | 0x200;
    }

    @Override
    protected int doIsConformant(FunctionTypeReference left, FunctionTypeReference right, int flags) {
        boolean rightIsVoid;
        LightweightTypeReference rightReturnType;
        if ((flags & 0x100) == 0 || (flags & 2) != 0) {
            return this.doIsConformant((ParameterizedTypeReference)left, (ParameterizedTypeReference)right, flags);
        }
        List<LightweightTypeReference> leftParameterTypes = left.getParameterTypes();
        List<LightweightTypeReference> rightParameterTypes = right.getParameterTypes();
        if (leftParameterTypes.size() != rightParameterTypes.size()) {
            return flags;
        }
        LightweightTypeReference leftReturnType = left.getReturnType();
        if (leftReturnType != (rightReturnType = right.getReturnType()) && (leftReturnType == null || rightReturnType == null)) {
            return flags;
        }
        boolean leftIsVoid = leftReturnType != null && leftReturnType.isPrimitiveVoid();
        boolean bl = rightIsVoid = rightReturnType != null && rightReturnType.isPrimitiveVoid();
        if (leftIsVoid ? !rightIsVoid : rightIsVoid) {
            return flags;
        }
        if (leftReturnType != rightReturnType && !leftIsVoid && (this.doIsConformant(leftReturnType, rightReturnType, flags & 0xFFFFFE5F) & 0x200) == 0) {
            return flags;
        }
        for (int i = 0; i < leftParameterTypes.size(); ++i) {
            LightweightTypeReference rightParameterType;
            LightweightTypeReference leftParameterType = leftParameterTypes.get(i);
            if (leftParameterType != (rightParameterType = rightParameterTypes.get(i)) && (leftParameterType == null || rightParameterType == null)) {
                return flags;
            }
            if ((this.doIsConformant(rightParameterType, leftParameterType, flags & 0xFFFFFE5F) & 0x200) != 0) continue;
            return flags;
        }
        return flags | 0x200;
    }

    public LightweightTypeReference getCommonSuperType(List<LightweightTypeReference> types, ITypeReferenceOwner owner) {
        if (types == null || types.isEmpty()) {
            throw new IllegalArgumentException("Types can't be null or empty " + types);
        }
        if (types.size() == 1) {
            return types.get(0);
        }
        boolean allVoid = true;
        for (LightweightTypeReference type : types) {
            if (type.isPrimitiveVoid()) continue;
            allVoid = false;
            break;
        }
        if (allVoid) {
            return types.get(0);
        }
        for (LightweightTypeReference type : types) {
            LightweightTypeReference conformantType = this.conformsToAll(type, types);
            if (conformantType != null) {
                return conformantType;
            }
            if (!type.isPrimitiveVoid()) continue;
            return null;
        }
        if (this.containsPrimitiveOrAnyReferences(types)) {
            List<LightweightTypeReference> withoutPrimitives = this.replacePrimitivesAndRemoveAnyReferences(types);
            if (withoutPrimitives.equals(types)) {
                return null;
            }
            return this.getCommonSuperType(withoutPrimitives, owner);
        }
        LightweightTypeReference firstType = types.get(0);
        List<LightweightTypeReference> tail = types.subList(1, types.size());
        LinkedHashMultimap<JvmType, LightweightTypeReference> all = LinkedHashMultimap.create();
        LinkedHashMultiset<JvmType> cumulatedDistance = LinkedHashMultiset.create();
        this.initializeDistance(firstType, all, cumulatedDistance);
        this.cumulateDistance(tail, all, cumulatedDistance);
        ArrayList<Multiset.Entry<JvmType>> candidates = Lists.newArrayList(cumulatedDistance.entrySet());
        if (candidates.size() == 1) {
            JvmType firstRawType = (JvmType)((Multiset.Entry)candidates.get(0)).getElement();
            return this.getFirstForRawType(all, firstRawType);
        }
        this.inplaceSortByDistanceAndName(candidates);
        ArrayList<LightweightTypeReference> referencesWithSameDistance = Lists.newArrayListWithExpectedSize(2);
        int wasDistance = -1;
        boolean classSeen = false;
        block2: for (Multiset.Entry entry : candidates) {
            JvmType rawType = (JvmType)entry.getElement();
            LightweightTypeReference result = null;
            if (wasDistance == -1) {
                wasDistance = entry.getCount();
            } else if (wasDistance != entry.getCount()) {
                if (classSeen) break;
                result = this.getTypeParametersForSupertype(all, rawType, owner, types);
                for (LightweightTypeReference alreadyCollected : referencesWithSameDistance) {
                    if ((this.isConformant(result, alreadyCollected, 445) & 0x200) == 0) continue;
                    classSeen = classSeen || this.isClass(rawType);
                    continue block2;
                }
                wasDistance = entry.getCount();
            }
            if (result == null) {
                result = this.getTypeParametersForSupertype(all, rawType, owner, types);
            }
            if (result == null) continue;
            boolean isClass = this.isClass(rawType);
            boolean bl = classSeen = classSeen || isClass;
            if (isClass) {
                referencesWithSameDistance.add(0, result);
                continue;
            }
            referencesWithSameDistance.add(result);
        }
        if (referencesWithSameDistance.size() == 1) {
            return (LightweightTypeReference)referencesWithSameDistance.get(0);
        }
        if (referencesWithSameDistance.size() > 1) {
            CompoundTypeReference result = owner.newCompoundTypeReference(false);
            for (LightweightTypeReference reference : referencesWithSameDistance) {
                result.addComponent(reference);
            }
            return result;
        }
        return null;
    }

    protected boolean isClass(JvmType type) {
        EClass eClass = type.eClass();
        if (eClass == TypesPackage.Literals.JVM_ARRAY_TYPE) {
            return this.isClass(((JvmArrayType)type).getComponentType());
        }
        return eClass == TypesPackage.Literals.JVM_GENERIC_TYPE && !((JvmGenericType)type).isInterface();
    }

    protected void initializeDistance(LightweightTypeReference firstType, Multimap<JvmType, LightweightTypeReference> all, Multiset<JvmType> cumulatedDistance) {
        MaxDistanceRawTypeAcceptor acceptor = new MaxDistanceRawTypeAcceptor(cumulatedDistance, all);
        acceptor.accept(firstType, 0);
        firstType.collectSuperTypes(acceptor);
    }

    protected void cumulateDistance(List<LightweightTypeReference> references, Multimap<JvmType, LightweightTypeReference> all, Multiset<JvmType> cumulatedDistance) {
        for (LightweightTypeReference other : references) {
            LinkedHashMultiset<JvmType> otherDistance = LinkedHashMultiset.create();
            this.initializeDistance(other, all, otherDistance);
            cumulatedDistance.retainAll(otherDistance);
            for (Multiset.Entry typeToDistance : otherDistance.entrySet()) {
                if (!cumulatedDistance.contains(typeToDistance.getElement())) continue;
                cumulatedDistance.add((JvmType)typeToDistance.getElement(), typeToDistance.getCount());
            }
        }
    }

    protected void inplaceSortByDistanceAndName(List<Multiset.Entry<JvmType>> candidates) {
        Collections.sort(candidates, new Comparator<Multiset.Entry<JvmType>>(){

            @Override
            public int compare(Multiset.Entry<JvmType> o1, Multiset.Entry<JvmType> o2) {
                if (o1.getCount() == o2.getCount()) {
                    JvmType element1 = o1.getElement();
                    JvmType element2 = o2.getElement();
                    return this.compare(element1, element2);
                }
                if (o1.getCount() < o2.getCount()) {
                    return -1;
                }
                return 1;
            }

            @Override
            protected int compare(JvmType element1, JvmType element2) {
                int result;
                EClass element1EClass = element1.eClass();
                EClass element2EClass = element2.eClass();
                if (element1EClass == TypesPackage.Literals.JVM_ARRAY_TYPE && element2EClass == TypesPackage.Literals.JVM_ARRAY_TYPE) {
                    return this.compare(((JvmArrayType)element1).getComponentType(), ((JvmArrayType)element2).getComponentType());
                }
                if (element1EClass == TypesPackage.Literals.JVM_GENERIC_TYPE && element2EClass == TypesPackage.Literals.JVM_GENERIC_TYPE && (result = Booleans.compare(((JvmGenericType)element1).isInterface(), ((JvmGenericType)element2).isInterface())) != 0) {
                    return result;
                }
                return element1.getIdentifier().compareTo(element2.getIdentifier());
            }
        });
    }

    protected List<LightweightTypeReference> replacePrimitivesAndRemoveAnyReferences(List<LightweightTypeReference> types) {
        ArrayList<LightweightTypeReference> result = Lists.newArrayList();
        for (LightweightTypeReference type : types) {
            if (type.isAny()) continue;
            result.add(type.getWrapperTypeIfPrimitive());
        }
        return result;
    }

    protected boolean containsPrimitiveOrAnyReferences(List<LightweightTypeReference> types) {
        for (LightweightTypeReference type : types) {
            if (!type.isPrimitive() && !type.isAny()) continue;
            return true;
        }
        return false;
    }

    protected LightweightTypeReference getFirstForRawType(Multimap<JvmType, LightweightTypeReference> all, JvmType rawType) {
        for (LightweightTypeReference result : all.get(rawType)) {
            if (!(result instanceof ParameterizedTypeReference) && !(result instanceof ArrayTypeReference)) continue;
            return result;
        }
        throw new IllegalStateException(all.toString() + " does not contain a useful type reference for rawtype " + rawType.getIdentifier());
    }

    protected LightweightTypeReference getTypeParametersForSupertype(Multimap<JvmType, LightweightTypeReference> all, JvmType rawType, ITypeReferenceOwner owner, List<LightweightTypeReference> initiallyRequested) {
        EClass rawTypeClass = rawType.eClass();
        if (rawTypeClass == TypesPackage.Literals.JVM_GENERIC_TYPE) {
            JvmGenericType castedRawType = (JvmGenericType)rawType;
            if (!this.hasTypeParameters(castedRawType)) {
                return this.getFirstForRawType(all, rawType);
            }
            ParameterizedTypeReference result = owner.newParameterizedTypeReference(rawType);
            if (!this.enhanceSuperType(Lists.newArrayList(all.get(rawType)), initiallyRequested, result)) {
                return null;
            }
            FunctionTypeReference resultAsFunctionType = result.getAsFunctionTypeReference();
            if (resultAsFunctionType != null) {
                return resultAsFunctionType;
            }
            return result;
        }
        if (rawTypeClass == TypesPackage.Literals.JVM_ARRAY_TYPE) {
            JvmComponentType componentType = ((JvmArrayType)rawType).getComponentType();
            LinkedHashMultimap<JvmType, LightweightTypeReference> copiedMultimap = LinkedHashMultimap.create(all);
            Collection<LightweightTypeReference> originalReferences = all.get(rawType);
            ArrayList<LightweightTypeReference> componentReferences = Lists.newArrayListWithCapacity(originalReferences.size());
            for (LightweightTypeReference lightweightTypeReference : originalReferences) {
                this.addComponentType(lightweightTypeReference, componentReferences);
            }
            copiedMultimap.replaceValues(componentType, componentReferences);
            ArrayList<LightweightTypeReference> componentRequests = Lists.newArrayListWithCapacity(initiallyRequested.size());
            for (LightweightTypeReference initialRequest : initiallyRequested) {
                this.addComponentType(initialRequest, componentRequests);
            }
            LightweightTypeReference lightweightTypeReference = this.getTypeParametersForSupertype(copiedMultimap, componentType, owner, componentRequests);
            if (lightweightTypeReference != null) {
                return owner.newArrayTypeReference(lightweightTypeReference);
            }
        }
        return null;
    }

    protected boolean enhanceSuperType(List<LightweightTypeReference> superTypes, List<LightweightTypeReference> initiallyRequested, ParameterizedTypeReference result) {
        JvmType rawType = result.getType();
        ITypeReferenceOwner owner = result.getOwner();
        EList<JvmTypeParameter> typeParameters = ((JvmTypeParameterDeclarator)((Object)rawType)).getTypeParameters();
        ArrayList<LightweightTypeReference> parameterSuperTypes = Lists.newArrayListWithCapacity(superTypes.size());
        int size = typeParameters.size();
        for (int i = 0; i < size; ++i) {
            ArrayList<LightweightTypeReference> parameterReferences = Lists.newArrayListWithCapacity(typeParameters.size());
            int superTypesSize = superTypes.size();
            for (int j = 0; j < superTypesSize; ++j) {
                LightweightTypeReference reference = superTypes.get(j);
                if (reference instanceof ParameterizedTypeReference) {
                    ParameterizedTypeReference parameterized = (ParameterizedTypeReference)reference;
                    if (!parameterized.hasTypeArguments()) {
                        return true;
                    }
                    LightweightTypeReference parameterReference = parameterized.getTypeArguments().get(i);
                    if (parameterized instanceof FunctionTypeReference && !(parameterReference instanceof WildcardTypeReference)) {
                        WildcardTypeReference wildcard;
                        FunctionTypeReference functionType = (FunctionTypeReference)parameterized;
                        if (i == typeParameters.size() - 1 && parameterReference.equals(functionType.getReturnType())) {
                            wildcard = owner.newWildcardTypeReference();
                            wildcard.addUpperBound(parameterReference);
                            parameterReferences.add(wildcard);
                            continue;
                        }
                        if (functionType.getParameterTypes().contains(parameterReference)) {
                            wildcard = owner.newWildcardExtendsObject();
                            wildcard.setLowerBound(parameterReference);
                            parameterReferences.add(wildcard);
                            continue;
                        }
                        parameterReferences.add(parameterReference);
                        continue;
                    }
                    parameterReferences.add(parameterReference);
                    continue;
                }
                return false;
            }
            LightweightTypeReference parameterSuperType = this.getCommonParameterSuperType(parameterReferences, initiallyRequested, owner);
            if (parameterSuperType == null) {
                return false;
            }
            parameterSuperTypes.add(parameterSuperType);
        }
        for (LightweightTypeReference parameterSuperType : parameterSuperTypes) {
            result.addTypeArgument(parameterSuperType.copyInto(owner));
        }
        LightweightTypeReference outer = result.getOuter();
        if (outer != null) {
            ArrayList<LightweightTypeReference> outerSuperTypes = Lists.newArrayListWithCapacity(superTypes.size());
            int size2 = superTypes.size();
            for (int i = 0; i < size2; ++i) {
                outerSuperTypes.add(superTypes.get(i).getOuter());
            }
            this.enhanceSuperType(outerSuperTypes, initiallyRequested, (ParameterizedTypeReference)outer);
        }
        return true;
    }

    private boolean hasTypeParameters(JvmGenericType type) {
        if (!type.getTypeParameters().isEmpty()) {
            return true;
        }
        if (type.eContainer() instanceof JvmGenericType && !type.isStatic()) {
            return this.hasTypeParameters((JvmGenericType)type.eContainer());
        }
        return false;
    }

    public LightweightTypeReference getCommonParameterSuperType(List<LightweightTypeReference> types, List<LightweightTypeReference> initiallyRequested, ITypeReferenceOwner owner) {
        int i;
        LightweightTypeReference mostSpecialTypeIfAllWildcards = this.getMostSpecialTypeIfAllWildcards(types, owner);
        if (mostSpecialTypeIfAllWildcards != null) {
            if (mostSpecialTypeIfAllWildcards instanceof WildcardTypeReference) {
                return mostSpecialTypeIfAllWildcards;
            }
            WildcardTypeReference result = owner.newWildcardExtendsObject();
            result.setLowerBound(mostSpecialTypeIfAllWildcards);
            return result;
        }
        HashSet<String> allNames = Sets.newHashSet();
        HashSet<String> allBoundNames = Sets.newHashSet();
        boolean allResolved = true;
        for (i = 0; i < types.size() && allResolved; ++i) {
            allResolved = types.get(i).isResolved();
        }
        for (i = 0; i < types.size(); ++i) {
            LightweightTypeReference type = types.get(i);
            type = allResolved ? type.getUpperBoundSubstitute() : type.getInvariantBoundSubstitute();
            types.set(i, type);
            this.addIdentifier(type, allNames, allBoundNames);
        }
        if (allNames.size() == 1) {
            return types.get(0);
        }
        if (this.isRecursiveRequest(types, allNames, initiallyRequested)) {
            return owner.newWildcardExtendsObject();
        }
        LightweightTypeReference superType = this.getCommonSuperType(types, owner);
        if (superType instanceof WildcardTypeReference) {
            return superType;
        }
        if (superType == null) {
            return owner.newWildcardExtendsObject();
        }
        if (superType instanceof UnboundTypeReference) {
            return superType;
        }
        if (allBoundNames.size() != allNames.size() && allBoundNames.size() == 1 && allBoundNames.contains(this.getIdentifier(superType))) {
            return superType;
        }
        WildcardTypeReference result = owner.newWildcardTypeReference();
        result.addUpperBound(superType.copyInto(owner));
        return result;
    }

    protected boolean isRecursiveRequest(List<LightweightTypeReference> types, Set<String> allNames, List<LightweightTypeReference> initiallyRequested) {
        if (types.size() < initiallyRequested.size()) {
            return false;
        }
        for (LightweightTypeReference initialRequest : initiallyRequested) {
            if (allNames.contains(this.getIdentifier(initialRequest))) continue;
            return false;
        }
        return true;
    }

    private void addIdentifier(LightweightTypeReference type, Set<String> allNames, Set<String> allBoundNames) {
        if (type instanceof UnboundTypeReference && !type.isResolved()) {
            allNames.add(((UnboundTypeReference)type).getHandle().toString());
        } else {
            String identifier = type.getJavaIdentifier();
            allNames.add(identifier);
            allBoundNames.add(identifier);
        }
    }

    private String getIdentifier(LightweightTypeReference type) {
        if (type instanceof UnboundTypeReference && !type.isResolved()) {
            return ((UnboundTypeReference)type).getHandle().toString();
        }
        return type.getJavaIdentifier();
    }

    private LightweightTypeReference getMostSpecialTypeIfAllWildcards(List<LightweightTypeReference> types, ITypeReferenceOwner owner) {
        boolean objectIsCandidate = false;
        boolean lowerBoundSeen = false;
        for (LightweightTypeReference type : types) {
            if (type instanceof WildcardTypeReference) {
                if (((WildcardTypeReference)type).getLowerBound() == null) {
                    objectIsCandidate = true;
                    continue;
                }
                lowerBoundSeen = true;
                continue;
            }
            return null;
        }
        if (!lowerBoundSeen) {
            return null;
        }
        if (objectIsCandidate) {
            return owner.newWildcardExtendsObject();
        }
        return this.getMostSpecialType(types);
    }

    public LightweightTypeReference getMostSpecialType(List<LightweightTypeReference> candidates) {
        LightweightTypeReference type = candidates.get(0).getLowerBoundSubstitute();
        for (int i = 1; i < candidates.size(); ++i) {
            LightweightTypeReference candidate = candidates.get(i).getLowerBoundSubstitute();
            if (type.isAssignableFrom(candidate)) {
                type = candidate;
                continue;
            }
            if (candidate.isAssignableFrom(type)) continue;
            return null;
        }
        return type;
    }

    protected void addComponentType(LightweightTypeReference reference, List<LightweightTypeReference> result) {
        if (reference.isArray()) {
            result.add(((ArrayTypeReference)reference).getComponentType());
        } else {
            result.add(reference);
        }
    }

    protected LightweightTypeReference conformsToAll(LightweightTypeReference type, List<LightweightTypeReference> types) {
        LightweightTypeReference result = type;
        for (int i = 0; i < types.size(); ++i) {
            LightweightTypeReference other = types.get(i);
            if (result == other) continue;
            int conformance = this.isConformant(result, other, 364);
            if ((conformance & 0x200) != 0) {
                boolean resultIsFunctionType = result instanceof FunctionTypeReference;
                if (resultIsFunctionType || !(other instanceof FunctionTypeReference) || !other.isAssignableFrom(result)) continue;
                result = other;
                continue;
            }
            return null;
        }
        return result;
    }

    protected static class MaxDistanceRawTypeAcceptor
    implements SuperTypeAcceptor {
        private final Multiset<JvmType> distances;
        private final Multimap<JvmType, LightweightTypeReference> rawTypeToReference;

        protected MaxDistanceRawTypeAcceptor(Multiset<JvmType> result, Multimap<JvmType, LightweightTypeReference> all) {
            this.distances = result;
            this.rawTypeToReference = all;
        }

        @Override
        public boolean accept(LightweightTypeReference superType, int distance) {
            if (superType == null) {
                throw new IllegalStateException("superType may not be null");
            }
            JvmType type = superType.getType();
            if (type != null) {
                this.rawTypeToReference.put(type, superType);
                if (this.distances.contains(type)) {
                    int currentCount = this.distances.count(type);
                    if (currentCount < distance + 1) {
                        this.distances.setCount(type, distance + 1);
                    }
                } else {
                    this.distances.add(type, distance + 1);
                }
            }
            return true;
        }
    }
}

