/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedFeature;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public abstract class AbstractResolvedExecutable<T extends JvmExecutable>
extends AbstractResolvedFeature<T>
implements IResolvedExecutable {
    private List<LightweightTypeReference> parameterTypes;
    private List<LightweightTypeReference> declaredExceptions;

    protected AbstractResolvedExecutable(T declaration, LightweightTypeReference contextType) {
        super(declaration, contextType);
    }

    @Override
    public List<JvmTypeParameter> getTypeParameters() {
        return Collections.unmodifiableList(((JvmExecutable)this.getDeclaration()).getTypeParameters());
    }

    @Override
    public List<LightweightTypeReference> getResolvedParameterTypes() {
        JvmExecutable declaration = (JvmExecutable)this.getDeclaration();
        if (declaration.getParameters().isEmpty()) {
            return Collections.emptyList();
        }
        if (this.parameterTypes != null) {
            return this.parameterTypes;
        }
        EList<JvmFormalParameter> parameters = declaration.getParameters();
        ArrayList<JvmTypeReference> unresolvedParameterTypes = Lists.newArrayListWithCapacity(parameters.size());
        for (JvmFormalParameter parameter : parameters) {
            unresolvedParameterTypes.add(parameter.getParameterType());
        }
        this.parameterTypes = this.getResolvedReferences(unresolvedParameterTypes);
        return this.parameterTypes;
    }

    @Override
    public String getResolvedErasureSignature() {
        JvmExecutable declaration = (JvmExecutable)this.getDeclaration();
        List<LightweightTypeReference> parameterTypes = this.getResolvedParameterTypes();
        StringBuilder result = new StringBuilder(declaration.getSimpleName().length() + 2 + 20 * parameterTypes.size());
        result.append(declaration.getSimpleName());
        result.append('(');
        for (int i = 0; i < parameterTypes.size(); ++i) {
            if (i != 0) {
                result.append(',');
            }
            result.append(parameterTypes.get(i).getRawTypeReference().getJavaIdentifier());
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public String getResolvedSignature() {
        JvmExecutable declaration = (JvmExecutable)this.getDeclaration();
        List<LightweightTypeReference> parameterTypes = this.getResolvedParameterTypes();
        StringBuilder result = new StringBuilder(declaration.getSimpleName().length() + 2 + 30 * parameterTypes.size());
        result.append(declaration.getSimpleName());
        result.append('(');
        for (int i = 0; i < parameterTypes.size(); ++i) {
            if (i != 0) {
                result.append(',');
            }
            result.append(parameterTypes.get(i).getJavaIdentifier());
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public String getSimpleSignature() {
        JvmExecutable declaration = (JvmExecutable)this.getDeclaration();
        List<LightweightTypeReference> parameterTypes = this.getResolvedParameterTypes();
        StringBuilder result = new StringBuilder(declaration.getSimpleName().length() + 2 + 10 * parameterTypes.size());
        result.append(declaration.getSimpleName());
        result.append('(');
        for (int i = 0; i < parameterTypes.size(); ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(parameterTypes.get(i).getSimpleName());
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public List<LightweightTypeReference> getResolvedExceptions() {
        JvmExecutable declaration = (JvmExecutable)this.getDeclaration();
        if (declaration.getExceptions().isEmpty()) {
            return Collections.emptyList();
        }
        if (this.declaredExceptions != null) {
            return this.declaredExceptions;
        }
        this.declaredExceptions = this.getResolvedReferences(declaration.getExceptions());
        return this.declaredExceptions;
    }

    public String toString() {
        return String.format("%s in context of %s", ((JvmExecutable)this.getDeclaration()).getIdentifier(), this.getContextType().getSimpleName());
    }
}

