/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen;

import com.db.plexus.interop.dsl.gen.errors.CodeGenerationException;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class ResourceSetValidator {
    @Inject
    protected IResourceValidator validator;
    protected Logger logger = Logger.getLogger("PlexusResourceSetValidator");

    public void validateResources(ResourceSet resourceSet) {
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        ArrayList<Issue> allIssues = this.getValidationIssues(resourceSet);
        List<Issue> errors = this.errors(allIssues);
        boolean _isEmpty = errors.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.logger.severe(this.validationErrorsMessage(errors));
        }
        for (Issue error : errors) {
            this.logger.severe(error.toString());
        }
        List<Issue> otherIssues = this.warnings(allIssues);
        boolean _isEmpty_1 = otherIssues.isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            this.logger.warning(String.format("%d validation warnings found:", otherIssues.size()));
        }
        for (Issue warning : otherIssues) {
            this.logger.warning(warning.toString());
        }
        boolean _isEmpty_2 = errors.isEmpty();
        boolean bl3 = _not_2 = !_isEmpty_2;
        if (_not_2) {
            String _validationErrorsMessage = this.validationErrorsMessage(errors);
            throw new CodeGenerationException(_validationErrorsMessage);
        }
    }

    public ArrayList<Issue> getValidationIssues(ResourceSet resourceSet) {
        EcoreUtil2.resolveAll(resourceSet);
        ArrayList<Issue> allIssues = new ArrayList<Issue>();
        EList<Resource> _resources = resourceSet.getResources();
        for (Resource resource : _resources) {
            List<Issue> issues = this.validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
            allIssues.addAll(issues);
        }
        return allIssues;
    }

    public List<Issue> errors(List<Issue> issues) {
        Predicate<Issue> _function = issue -> {
            Severity _severity = issue.getSeverity();
            return Objects.equal((Object)_severity, (Object)Severity.ERROR);
        };
        return issues.stream().filter(_function).collect(Collectors.toList());
    }

    public List<Issue> warnings(List<Issue> issues) {
        Predicate<Issue> _function = issue -> {
            Severity _severity = issue.getSeverity();
            return !Objects.equal((Object)_severity, (Object)Severity.ERROR);
        };
        return issues.stream().filter(_function).collect(Collectors.toList());
    }

    private String validationErrorsMessage(List<Issue> errors) {
        return String.format("%d validation errors found in loaded resources", errors.size());
    }
}

