/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen.csharp;

import com.db.plexus.interop.dsl.gen.BaseGenTask;
import com.db.plexus.interop.dsl.gen.GenUtils;
import com.db.plexus.interop.dsl.gen.PlexusGenConfig;
import com.db.plexus.interop.dsl.gen.csharp.CsharpCodeGenerator;
import com.db.plexus.interop.dsl.gen.util.FileUtils;
import com.db.plexus.interop.dsl.protobuf.Proto;
import com.db.plexus.interop.dsl.protobuf.ProtoSyntax;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CsharpGenTask
extends BaseGenTask {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private Injector injector;

    @Override
    protected void doGenWithResources(PlexusGenConfig config, XtextResourceSet resourceSet) throws IOException {
        try {
            String accessModifier = "public";
            String internalAccessArg = "";
            if (config.getNamespace() != null && config.getNamespace().startsWith("internal_access:")) {
                config.setNamespace(config.getNamespace().substring("internal_access:".length()));
                boolean _isEmpty = config.getNamespace().isEmpty();
                if (_isEmpty) {
                    config.setNamespace(null);
                }
                accessModifier = "internal";
                internalAccessArg = "internal_access:";
            }
            URI _baseDirUri = this.getBaseDirUri();
            CsharpCodeGenerator generator = new CsharpCodeGenerator(config, this.qualifiedNameProvider, _baseDirUri, accessModifier);
            this.injector.injectMembers(generator);
            EList<Resource> resources = resourceSet.getResources();
            for (Resource resource : resources) {
                int _length_1;
                boolean _greaterThan_1;
                boolean _greaterThan;
                boolean isProto2;
                boolean isBuiltIn = resource.getURI().segmentCount() > 2 && resource.getURI().segment(resource.getURI().segmentCount() - 3).equals("google") && resource.getURI().segment(resource.getURI().segmentCount() - 2).equals("protobuf");
                boolean bl = isProto2 = resource.getURI().lastSegment().endsWith(".proto") && Objects.equal(IterableExtensions.findFirst(Iterables.filter(resource.getContents(), Proto.class), x -> true).getSyntax(), ProtoSyntax.PROTO2);
                if (isBuiltIn || isProto2) continue;
                URI newUri = resource.getURI().resolve(this.getWorkingDirUri());
                String path = newUri.toFileString();
                boolean _startsWith = newUri.toString().startsWith(this.getBaseDirUri().toString());
                boolean _endsWith = (newUri = _startsWith ? newUri.deresolve(this.getBaseDirUri()).resolve(this.getOutDirUri()) : newUri.deresolve(this.getResourceBaseUri()).resolve(this.getOutDirUri())).toString().endsWith(".proto");
                if (_endsWith) {
                    String newPath = newUri.toFileString();
                    File file = new File(newPath);
                    file.getParentFile().mkdirs();
                    LinkedList<String> args = new LinkedList<String>();
                    args.add(config.getProtocPath());
                    String _fileString = this.getBaseDirUri().toFileString();
                    String _plus = "--proto_path=" + _fileString;
                    args.add(_plus);
                    String resourceBasePath = this.getResourceBaseUri().toFileString();
                    if (resourceBasePath != null) {
                        String _fileString_1 = this.getResourceBaseUri().toFileString();
                        String _plus_1 = "--proto_path=" + _fileString_1;
                        args.add(_plus_1);
                    }
                    Path _parent = Paths.get(newPath, new String[0]).getParent();
                    String _plus_2 = "--csharp_out=" + internalAccessArg + _parent;
                    args.add(_plus_2);
                    args.add("--csharp_opt=file_extension=.msg.g.cs");
                    args.add(path);
                    ProcessBuilder procBuilder = new ProcessBuilder(args);
                    procBuilder.inheritIO();
                    String _join = String.join((CharSequence)" ", procBuilder.command());
                    String _plus_3 = "Launching " + _join;
                    this.logger.info(_plus_3);
                    Process proc = null;
                    try {
                        proc = procBuilder.start();
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            String _protocPath = config.getProtocPath();
                            String _plus_4 = "Cannot start Protobuf compiler: " + _protocPath;
                            String _plus_5 = _plus_4 + ". Probably the path is wrong. You can change it using command-line argument --protoc=<path>.";
                            throw new IOException(_plus_5, e);
                        }
                        throw Exceptions.sneakyThrow(_t);
                    }
                    int exitCode = proc.waitFor();
                    if (exitCode != 0) {
                        throw new IOException("protoc process exited with non-zero exit code: " + Integer.valueOf(exitCode));
                    }
                    String _join_1 = String.join((CharSequence)" ", procBuilder.command());
                    String _plus_6 = "Completed " + _join_1;
                    this.logger.info(_plus_6);
                }
                Functions.Function1<String, String> _function = x -> StringExtensions.toFirstUpper(x);
                List<String> fileNameSegments = ListExtensions.map((List)Conversions.doWrapArray(newUri.lastSegment().split("_")), _function);
                newUri = newUri.trimSegments(1).appendSegment(String.join((CharSequence)"", fileNameSegments));
                int _length = ((Object[])Conversions.unwrapArray(GenUtils.getServices(resource), Object.class)).length;
                boolean bl2 = _greaterThan = _length > 0;
                if (_greaterThan) {
                    String newPath_1 = newUri.toFileString().replace(".proto", ".svc.g.cs");
                    this.logger.info("Generating " + newPath_1);
                    File _file = new File(newPath_1);
                    FileUtils.writeStringToFile(_file, generator.gen((XtextResource)resource));
                }
                if (!(_greaterThan_1 = (_length_1 = ((Object[])Conversions.unwrapArray(GenUtils.getApplications(resource), Object.class)).length) > 0)) continue;
                String newPath_2 = newUri.toFileString().replace(".interop", ".app.g.cs");
                this.logger.info("Generating " + newPath_2);
                File _file_1 = new File(newPath_2);
                FileUtils.writeStringToFile(_file_1, generator.gen((XtextResource)resource));
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }
}

