/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen.meta;

import com.db.plexus.interop.dsl.gen.BaseGenTask;
import com.db.plexus.interop.dsl.gen.PlexusGenConfig;
import com.db.plexus.interop.dsl.gen.meta.MetaJsonGenerator;
import com.db.plexus.interop.dsl.gen.util.FileUtils;
import com.db.plexus.interop.dsl.gen.util.ProcessResult;
import com.db.plexus.interop.dsl.gen.util.ProcessUtils;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class MetaJsonGenTask
extends BaseGenTask {
    @Inject
    private MetaJsonGenerator generator;

    @Override
    public void doGenWithResources(PlexusGenConfig config, XtextResourceSet rs) throws IOException {
        try {
            EList<Resource> resources = rs.getResources();
            List<String> protoFilePaths = this.getProtoFilePaths(resources, config);
            String _commonPath = FileUtils.commonPath(protoFilePaths);
            String _plus = _commonPath + "**";
            String _plus_1 = _plus + File.separator;
            String protoFilesGlob = _plus_1 + "*.proto";
            String messagesJson = "[]";
            if (!protoFilePaths.isEmpty() && config.getProtocPath() != null) {
                ArrayList<String> pbJsArgs = CollectionLiterals.newArrayList(config.getProtocPath());
                pbJsArgs.addAll(this.protoArgs());
                pbJsArgs.add(protoFilesGlob);
                this.logger.info(String.format("Running ProtoJS compiler with args [%s]", String.join((CharSequence)" ", pbJsArgs)));
                ProcessResult result = ProcessUtils.execSync((String[])Conversions.unwrapArray(pbJsArgs, String.class));
                if (result.code != 0) {
                    this.logger.severe("ProtoJS compiler has returned non-zero result code: " + Integer.valueOf(result.code));
                    this.logger.severe("ProtoJS compiler output:" + result.stdout);
                    System.exit(1);
                } else {
                    messagesJson = result.stdout;
                }
            }
            config.setMessagesMetadata(messagesJson);
            String str = this.generator.generate(config, rs);
            String _outDir = config.getOutDir();
            String _plus_2 = _outDir + "/interop.json";
            File _file = new File(_plus_2);
            FileUtils.writeStringToFile(_file, str);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    @Override
    public String inputFilesGlob(PlexusGenConfig config) {
        return "*.interop";
    }

    public List<String> protoArgs() {
        return Arrays.asList("-t", "json");
    }
}

