/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.validation;

import com.db.plexus.interop.dsl.ConsumedMethod;
import com.db.plexus.interop.dsl.DslPackage;
import com.db.plexus.interop.dsl.InteropOption;
import com.db.plexus.interop.dsl.ProvidedMethod;
import com.db.plexus.interop.dsl.ProvidedService;
import com.db.plexus.interop.dsl.validation.AbstractInteropLangValidator;
import java.util.List;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;

public class InteropLangValidator
extends AbstractInteropLangValidator {
    @Override
    public boolean isLanguageSpecific() {
        return false;
    }

    @Check
    public void checkUniqueConsumedMethod(ConsumedMethod consumedMethod) {
        List<ConsumedMethod> _siblingsOfType = EcoreUtil2.getSiblingsOfType(consumedMethod, ConsumedMethod.class);
        for (ConsumedMethod otherConsumedMethod : _siblingsOfType) {
            boolean _equals = otherConsumedMethod.getMethod().equals(consumedMethod.getMethod());
            if (!_equals) continue;
            String _name = consumedMethod.getMethod().getName();
            String _plus = "Duplicated consumed method definition: " + _name;
            this.error(_plus, DslPackage.Literals.CONSUMED_METHOD__METHOD);
        }
    }

    @Check
    public void checkUniqueProvidedMethod(ProvidedMethod providedMethod) {
        List<ProvidedMethod> _siblingsOfType = EcoreUtil2.getSiblingsOfType(providedMethod, ProvidedMethod.class);
        for (ProvidedMethod otherProvidedMethod : _siblingsOfType) {
            boolean _equals = otherProvidedMethod.getMethod().equals(providedMethod.getMethod());
            if (!_equals) continue;
            String _name = providedMethod.getMethod().getName();
            String _plus = "Duplicated provided method definition: " + _name;
            this.error(_plus, DslPackage.Literals.PROVIDED_METHOD__METHOD);
        }
    }

    @Check
    public void checkProvidedServiceHasNoAlias(ProvidedService providedService) {
        if (providedService.getAlias() != null && !providedService.getAlias().isEmpty()) {
            String _alias = providedService.getAlias();
            String _plus = "Provided service alias not empty: " + _alias;
            this.error(_plus, DslPackage.Literals.PROVIDED_SERVICE__ALIAS);
        }
    }

    @Check
    public void checkUniqueProvidedService(ProvidedService providedService) {
        List<ProvidedService> _siblingsOfType = EcoreUtil2.getSiblingsOfType(providedService, ProvidedService.class);
        for (ProvidedService otherProvidedService : _siblingsOfType) {
            boolean _equals = otherProvidedService.getService().getName().equals(providedService.getService().getName());
            if (!_equals) continue;
            String _name = providedService.getService().getName();
            String _plus = "Duplicated provided service definition: " + _name;
            this.error(_plus, DslPackage.Literals.PROVIDED_SERVICE__SERVICE);
        }
    }

    @Check
    public void checkUniqueProvidedServiceOption(ProvidedService providedService) {
        List<InteropOption> options = EcoreUtil2.typeSelect(providedService.getElements(), InteropOption.class);
        for (int i = 1; i < options.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                String name = options.get(i).getDescriptor().getName();
                boolean _equals = name.equals(options.get(j).getDescriptor().getName());
                if (!_equals) continue;
                this.error("Duplicated option definition: " + name, DslPackage.Literals.PROVIDED_SERVICE__ELEMENTS);
            }
        }
    }
}

