/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.workspace;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.workspace.UnknownProjectConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class WorkspaceConfig
implements IWorkspaceConfig {
    private final UnknownProjectConfig unknown = new UnknownProjectConfig(this);
    private final HashMap<String, IProjectConfig> projects = CollectionLiterals.newHashMap();

    public WorkspaceConfig(IProjectConfig ... initialProjects) {
        this.addProject(this.unknown);
        Consumer<IProjectConfig> _function = it -> this.addProject((IProjectConfig)it);
        ((List)Conversions.doWrapArray(initialProjects)).forEach(_function);
    }

    @Override
    public Set<? extends IProjectConfig> getProjects() {
        return IterableExtensions.toSet(this.projects.values());
    }

    public void addProject(IProjectConfig project) {
        this.projects.put(project.getName(), project);
    }

    @Override
    public IProjectConfig findProjectByName(String name) {
        return this.projects.get(name);
    }

    @Override
    public IProjectConfig findProjectContaining(URI member) {
        boolean _not;
        Functions.Function1<IProjectConfig, Boolean> _function = it -> {
            ISourceFolder _findSourceFolderContaining = it.findSourceFolderContaining(member);
            return _findSourceFolderContaining != null;
        };
        Iterable<IProjectConfig> candidates = IterableExtensions.filter(this.projects.values(), _function);
        boolean _isEmpty = IterableExtensions.isEmpty(candidates);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1<IProjectConfig, Integer> _function_1 = it -> it.getPath().segmentCount();
            return IterableExtensions.maxBy(candidates, _function_1);
        }
        return this.unknown;
    }
}

