/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.validation.rules;

import com.db.plexus.interop.dsl.Application;
import com.db.plexus.interop.dsl.gen.GenUtils;
import com.db.plexus.interop.dsl.validation.Issues;
import com.db.plexus.interop.dsl.validation.rules.UpdateRule;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class NoAppsDeletedRule
implements UpdateRule {
    private final GenUtils genUtils;

    @Inject
    public NoAppsDeletedRule(GenUtils genUtils) {
        this.genUtils = genUtils;
    }

    @Override
    public String getCode() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("app-deleted");
        return _builder.toString();
    }

    @Override
    public List<Issue> validate(XtextResourceSet baseResourceSet, XtextResourceSet updatedResourceSet) {
        Map<String, Application> baseElements = this.genUtils.getApplicationsMap((Resource[])Conversions.unwrapArray(baseResourceSet.getResources(), Resource.class));
        Set<String> updatedIds = this.genUtils.getApplicationsMap((Resource[])Conversions.unwrapArray(updatedResourceSet.getResources(), Resource.class)).keySet();
        Functions.Function1<String, Boolean> _function = id -> {
            boolean _contains = updatedIds.contains(id);
            return !_contains;
        };
        Functions.Function1<String, Issue> _function_1 = id -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Application ");
            _builder.append((String)id);
            _builder.append(" is deleted");
            return Issues.createError(_builder.toString(), this.getCode());
        };
        return IterableExtensions.toList(IterableExtensions.map(IterableExtensions.filter(baseElements.keySet(), _function), _function_1));
    }
}

