/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.GrammarToDot;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.grammaranalysis.IGrammarNFAProvider;
import org.eclipse.xtext.parsetree.reconstr.impl.TreeConstState;
import org.eclipse.xtext.parsetree.reconstr.impl.TreeConstTransition;
import org.eclipse.xtext.parsetree.reconstr.impl.TreeConstructionNFAProvider;
import org.eclipse.xtext.util.GraphvizDotBuilder;

public class TreeConstNFAToDot
extends GrammarToDot {
    protected IGrammarNFAProvider<TreeConstState, TreeConstTransition> nfaProvider = new TreeConstructionNFAProvider();

    @Override
    protected GraphvizDotBuilder.Node drawAbstractElementTree(AbstractElement grammarElement, GraphvizDotBuilder.Digraph digraph) {
        GraphvizDotBuilder.Node node = super.drawAbstractElementTree(grammarElement, digraph);
        TreeConstState nfas = this.nfaProvider.getNFA(grammarElement);
        for (TreeConstTransition outgoing : nfas.getOutgoing()) {
            digraph.add(this.drawFollowerEdge(grammarElement, outgoing, false));
        }
        for (TreeConstTransition outgoingAfterReturn : nfas.getOutgoingAfterReturn()) {
            digraph.add(this.drawFollowerEdge(grammarElement, outgoingAfterReturn, true));
        }
        if (nfas.getStatusInternal() != TreeConstState.Status.ENABLED) {
            node.setStyle("dashed");
        }
        if (nfas.isEndState()) {
            node.put("peripheries", "2");
        }
        this.setStatusStyle(node, nfas.getStatus());
        node.setLabel(nfas + (String)node.get("label"));
        return node;
    }

    protected GraphvizDotBuilder.Edge drawFollowerEdge(AbstractElement grammarElement, TreeConstTransition transition, boolean isParent) {
        GraphvizDotBuilder.Edge edge = new GraphvizDotBuilder.Edge(this, grammarElement, transition.getTarget().getGrammarElement());
        if (transition.getPrecedence() > -1) {
            edge.setLabel(String.valueOf(transition.getPrecedence()));
        }
        edge.setStyle("dotted");
        if (isParent) {
            edge.put("arrowtail", "odot");
        }
        if (transition.isRuleCall()) {
            edge.put("arrowhead", "onormalonormal");
        } else {
            edge.put("arrowhead", "onormal");
        }
        this.setStatusStyle(edge, transition.getStatus());
        return edge;
    }

    protected void setStatusStyle(GraphvizDotBuilder.Props properties, TreeConstState.Status status) {
        switch (status) {
            case AMBIGIOUS: {
                properties.put("color", "green");
                break;
            }
            case DETOUR_OR_LOOP: {
                properties.put("color", "blue");
                break;
            }
            case ORPHAN: {
                properties.put("color", "grey");
                break;
            }
            case UNKNOWN: {
                properties.put("color", "red");
                break;
            }
        }
    }

    @Override
    protected GraphvizDotBuilder.Node newNode(EObject semanticObject, String label) {
        TreeConstState nfas = this.nfaProvider.getNFA((AbstractElement)semanticObject);
        ArrayList<String> types = Lists.newArrayList();
        for (TypeRef typeRef : nfas.getTypesToCheck()) {
            types.add(typeRef == null ? "null" : typeRef.getClassifier().getName());
        }
        if (semanticObject.eContainer() instanceof AbstractRule) {
            AbstractRule rule = (AbstractRule)semanticObject.eContainer();
            String typesAsString = types.isEmpty() ? "" : " [" + Joiner.on(",").join(types) + "]";
            return new GraphvizDotBuilder.Node(this, semanticObject, rule.getName() + typesAsString + ":\\n" + label, "record");
        }
        String typesAsString = types.isEmpty() ? "" : "[" + Joiner.on(",").join(types) + "]\\n";
        return new GraphvizDotBuilder.Node(this, semanticObject, typesAsString + label);
    }
}

